package org.dromara.zjk.service.impl;

import org.dromara.common.core.utils.MapstructUtils;
import org.dromara.common.core.utils.StringUtils;
import org.dromara.common.mybatis.core.page.TableDataInfo;
import org.dromara.common.mybatis.core.page.PageQuery;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.dromara.zjk.domain.bo.ZjkProductReviewsnBo;
import org.dromara.zjk.domain.vo.ZjkProductReviewsnVo;
import org.dromara.zjk.domain.ZjkProductReviewsn;
import org.dromara.zjk.mapper.ZjkProductReviewsnMapper;
import org.dromara.zjk.service.IZjkProductReviewsnService;

import java.util.List;
import java.util.Map;
import java.util.Collection;

/**
 * 项目阶段文档管理Service业务层处理
 *
 * @author wt
 * @date 2024-11-22
 */
@RequiredArgsConstructor
@Service
public class ZjkProductReviewsnServiceImpl implements IZjkProductReviewsnService {

    private final ZjkProductReviewsnMapper baseMapper;

    /**
     * 查询项目阶段文档管理
     *
     * @param id 主键
     * @return 项目阶段文档管理
     */
    @Override
    public ZjkProductReviewsnVo queryById(Long id){
        return baseMapper.selectVoById(id);
    }

    /**
     * 分页查询项目阶段文档管理列表
     *
     * @param bo        查询条件
     * @param pageQuery 分页参数
     * @return 项目阶段文档管理分页列表
     */
    @Override
    public TableDataInfo<ZjkProductReviewsnVo> queryPageList(ZjkProductReviewsnBo bo, PageQuery pageQuery) {
        LambdaQueryWrapper<ZjkProductReviewsn> lqw = buildQueryWrapper(bo);
        Page<ZjkProductReviewsnVo> result = baseMapper.selectDocumentPage(pageQuery.build(), bo);
        return TableDataInfo.build(result);
    }

    /**
     * 查询符合条件的项目阶段文档管理列表
     *
     * @param bo 查询条件
     * @return 项目阶段文档管理列表
     */
    @Override
    public List<ZjkProductReviewsnVo> queryList(ZjkProductReviewsnBo bo) {
        LambdaQueryWrapper<ZjkProductReviewsn> lqw = buildQueryWrapper(bo);
        return baseMapper.selectVoList(lqw);
    }

    private LambdaQueryWrapper<ZjkProductReviewsn> buildQueryWrapper(ZjkProductReviewsnBo bo) {
        Map<String, Object> params = bo.getParams();
        LambdaQueryWrapper<ZjkProductReviewsn> lqw = Wrappers.lambdaQuery();
        lqw.eq(bo.getProductId() != null, ZjkProductReviewsn::getProductId, bo.getProductId());
        lqw.eq(StringUtils.isNotBlank(bo.getReviewSn()), ZjkProductReviewsn::getReviewSn, bo.getReviewSn());
        lqw.eq(StringUtils.isNotBlank(bo.getStatus()), ZjkProductReviewsn::getStatus, bo.getStatus());
        return lqw;
    }

    /**
     * 新增项目阶段文档管理
     *
     * @param bo 项目阶段文档管理
     * @return 是否新增成功
     */
    @Override
    public Boolean insertByBo(ZjkProductReviewsnBo bo) {
        ZjkProductReviewsn add = MapstructUtils.convert(bo, ZjkProductReviewsn.class);
        validEntityBeforeSave(add);
        boolean flag = baseMapper.insert(add) > 0;
        if (flag) {
            bo.setId(add.getId());
        }
        return flag;
    }

    /**
     * 修改项目阶段文档管理
     *
     * @param bo 项目阶段文档管理
     * @return 是否修改成功
     */
    @Override
    public Boolean updateByBo(ZjkProductReviewsnBo bo) {
        ZjkProductReviewsn update = MapstructUtils.convert(bo, ZjkProductReviewsn.class);
        validEntityBeforeSave(update);
        return baseMapper.updateById(update) > 0;
    }

    /**
     * 保存前的数据校验
     */
    private void validEntityBeforeSave(ZjkProductReviewsn entity){
        //TODO 做一些数据校验,如唯一约束
    }

    /**
     * 校验并批量删除项目阶段文档管理信息
     *
     * @param ids     待删除的主键集合
     * @param isValid 是否进行有效性校验
     * @return 是否删除成功
     */
    @Override
    public Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid) {
        if(isValid){
            //TODO 做一些业务上的校验,判断是否需要校验
        }
        return baseMapper.deleteByIds(ids) > 0;
    }

    @Override
    public boolean deleteByProductId(Long id, String reviewSn) {
        LambdaQueryWrapper<ZjkProductReviewsn> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(ZjkProductReviewsn::getProductId, id);
        wrapper.eq(ZjkProductReviewsn::getReviewSn, reviewSn);
        return baseMapper.delete(wrapper) >0 ;
    }
}
