package org.dromara.zjk.statement.domain;

import org.dromara.common.tenant.core.TenantEntity;
import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.math.BigDecimal;
import org.dromara.zjk.annotation.PropertyMsg;
import java.io.Serial;

/**
 * 报表统计对象 zjk_money_collect_statement
 *
 * @author wt
 * @date 2024-12-16
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("zjk_money_collect_statement")
public class ZjkMoneyCollectStatement extends TenantEntity {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @PropertyMsg(propertyName = "id")
    private Long id;

    /**
     * 支付总金额;支付总金额
     */
    @PropertyMsg(propertyName = "sum_fee")
    private BigDecimal sumFee;

    /**
     * 未支付金额;未支付金额
     */
    @PropertyMsg(propertyName = "no_pay_money")
    private BigDecimal noPayMoney;

    /**
     * 支付金额;支付金额
     */
    @PropertyMsg(propertyName = "pay_money")
    private BigDecimal payMoney;

    /**
     * 专家人数;专家人数
     */
    @PropertyMsg(propertyName = "expert_count")
    private Integer expertCount;

    /**
     * 结算周期;结算周期
     */
    @PropertyMsg(propertyName = "money_cycle")
    private String moneyCycle;

    /**
     * 状态
     */
    @PropertyMsg(propertyName = "status")
    private String status;

    /**
     * 备注
     */
    @PropertyMsg(propertyName = "remark")
    private String remark;

    /**
     * 报表id
     */
    @PropertyMsg(propertyName = "statement_id")
    private Long statementId;

    /**
     * 是否删除
     */
    @TableLogic
    @PropertyMsg(propertyName = "del_flag")
    private Long delFlag;


}
