package org.dromara.zjk.statement.domain;

import org.dromara.common.tenant.core.TenantEntity;
import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.dromara.zjk.annotation.PropertyMsg;
import java.io.Serial;

/**
 * 费用报表对象 zjk_money_statement
 *
 * @author ygh
 * @date 2024-12-16
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("zjk_money_statement")
public class ZjkMoneyStatement extends TenantEntity {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @PropertyMsg(propertyName = "id")
    private Long id;

    /**
     * 编号;编号
     */
    @PropertyMsg(propertyName = "statement_sn")
    private String statementSn;

    /**
     * 类型(年报，月报);类型(年报，月报)
     */
    @PropertyMsg(propertyName = "type")
    private String type;

    /**
     * 周期（每年，每月）;周期（每年，每月）
     */
    @PropertyMsg(propertyName = "period")
    private String period;

    /**
     * 时间范围开始
     */
    @PropertyMsg(propertyName = "scope_start_time")
    private Date scopeStartTime;

    /**
     * 状态
     */
    @PropertyMsg(propertyName = "status")
    private String status;

    /**
     * 备注
     */
    @PropertyMsg(propertyName = "remark")
    private String remark;

    /**
     * 是否删除
     */
    @TableLogic
    @PropertyMsg(propertyName = "del_flag")
    private Long delFlag;

    /**
     * 时间范围结束
     */
    @PropertyMsg(propertyName = "scope_end_time")
    private Date scopeEndTime;

    private Date nameDate;
}
