package org.dromara.zjk.statement.domain.bo;

import org.dromara.zjk.statement.domain.ZjkMoneyExpertStatement;
import org.dromara.common.mybatis.core.domain.BaseEntity;
import org.dromara.common.core.validate.AddGroup;
import org.dromara.common.core.validate.EditGroup;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import lombok.EqualsAndHashCode;
import jakarta.validation.constraints.*;
import java.math.BigDecimal;

/**
 * 专家费用报表业务对象 zjk_money_expert_statement
 *
 * @author ygh
 * @date 2024-12-16
 */
@Data
@EqualsAndHashCode(callSuper = true)
@AutoMapper(target = ZjkMoneyExpertStatement.class, reverseConvertGenerate = false)
public class ZjkMoneyExpertStatementBo extends BaseEntity {

    /**
     * id
     */
    @NotNull(message = "id不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long id;

    /**
     * 专家姓名;专家姓名
     */
    @NotBlank(message = "专家姓名;专家姓名不能为空", groups = { AddGroup.class, EditGroup.class })
    private String expertName;

    /**
     * 专家类型;专家类型
     */
    @NotBlank(message = "专家类型;专家类型不能为空", groups = { AddGroup.class, EditGroup.class })
    private String expertType;

    /**
     * 总费用;总费用
     */
    @NotNull(message = "总费用;总费用不能为空", groups = { AddGroup.class, EditGroup.class })
    private BigDecimal sumFee;

    /**
     * 未支付费用;未支付费用
     */
    @NotNull(message = "未支付费用;未支付费用不能为空", groups = { AddGroup.class, EditGroup.class })
    private BigDecimal noPayFee;

    /**
     * 已支付费用;已支付费用
     */
    @NotNull(message = "已支付费用;已支付费用不能为空", groups = { AddGroup.class, EditGroup.class })
    private BigDecimal payFee;

    /**
     * 结算周期;结算周期
     */
    @NotBlank(message = "结算周期;结算周期不能为空", groups = { AddGroup.class, EditGroup.class })
    private String moneyCycle;

    /**
     * 状态
     */
    @NotBlank(message = "状态不能为空", groups = { AddGroup.class, EditGroup.class })
    private String status;

    /**
     * 备注
     */
    @NotBlank(message = "备注不能为空", groups = { AddGroup.class, EditGroup.class })
    private String remark;

    /**
     * 报表id
     */
    private Long statementId;

}
