package org.dromara.zjk.statement.domain.bo;

import org.dromara.zjk.statement.domain.ZjkMoneyStatement;
import org.dromara.common.mybatis.core.domain.BaseEntity;
import org.dromara.common.core.validate.AddGroup;
import org.dromara.common.core.validate.EditGroup;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import lombok.EqualsAndHashCode;
import jakarta.validation.constraints.*;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 费用报表业务对象 zjk_money_statement
 *
 * @author ygh
 * @date 2024-12-16
 */
@Data
@EqualsAndHashCode(callSuper = true)
@AutoMapper(target = ZjkMoneyStatement.class, reverseConvertGenerate = false)
public class ZjkMoneyStatementBo extends BaseEntity {

    /**
     * id
     */
    @NotNull(message = "id不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long id;

    /**
     * 编号;编号
     */
    @NotNull(message = "编号;编号不能为空", groups = { AddGroup.class, EditGroup.class })
    private Date statementSn;

    /**
     * 类型(年报，月报);类型(年报，月报)
     */
    @NotBlank(message = "类型(年报，月报);类型(年报，月报)不能为空", groups = { AddGroup.class, EditGroup.class })
    private String type;

    /**
     * 周期（每年，每月）;周期（每年，每月）
     */
    @NotBlank(message = "周期（每年，每月）;周期（每年，每月）不能为空", groups = { AddGroup.class, EditGroup.class })
    private String period;

    /**
     * 时间范围开始
     */
    @NotNull(message = "时间范围开始不能为空", groups = { AddGroup.class, EditGroup.class })
    private Date scopeStartTime;

    /**
     * 状态
     */
    @NotBlank(message = "状态不能为空", groups = { AddGroup.class, EditGroup.class })
    private String status;

    /**
     * 备注
     */
    @NotBlank(message = "备注不能为空", groups = { AddGroup.class, EditGroup.class })
    private String remark;

    /**
     * 时间范围结束
     */
    @NotNull(message = "时间范围结束不能为空", groups = { AddGroup.class, EditGroup.class })
    private Date scopeEndTime;


}
