package org.dromara.zjk.statement.domain.vo;

import java.math.BigDecimal;
import org.dromara.zjk.statement.domain.ZjkMoneyAnalyseStatement;
import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import org.dromara.common.excel.annotation.ExcelDictFormat;
import org.dromara.common.excel.convert.ExcelDictConvert;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;
import java.util.Date;



/**
 * 报表分析视图对象 zjk_money_analyse_statement
 *
 * @author ygh
 * @date 2024-12-16
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = ZjkMoneyAnalyseStatement.class)
public class ZjkMoneyAnalyseStatementVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @ExcelProperty(value = "id")
    private Long id;

    /**
     * 专家类型;专家类型
     */
    @ExcelProperty(value = "专家类型;专家类型")
    private String expertType;

    /**
     * 总费用;总费用
     */
    @ExcelProperty(value = "总费用;总费用")
    private BigDecimal sumFee;

    /**
     * 占比;占比
     */
    @ExcelProperty(value = "占比;占比")
    private BigDecimal proportion;

    /**
     * 变化趋势;变化趋势
     */
    @ExcelProperty(value = "变化趋势;变化趋势")
    private BigDecimal tendency;

    /**
     * 状态
     */
    @ExcelProperty(value = "状态")
    private String status;

    /**
     * 备注
     */
    @ExcelProperty(value = "备注")
    private String remark;


}
