package org.dromara.zjk.statement.domain.vo;

import java.math.BigDecimal;
import org.dromara.zjk.statement.domain.ZjkMoneyCollectStatement;
import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import org.dromara.common.excel.annotation.ExcelDictFormat;
import org.dromara.common.excel.convert.ExcelDictConvert;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;
import java.util.Date;



/**
 * 报表统计视图对象 zjk_money_collect_statement
 *
 * @author wt
 * @date 2024-12-16
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = ZjkMoneyCollectStatement.class)
public class ZjkMoneyCollectStatementVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @ExcelProperty(value = "id")
    private Long id;

    /**
     * 支付总金额;支付总金额
     */
    @ExcelProperty(value = "支付总金额;支付总金额")
    private BigDecimal sumFee;

    /**
     * 未支付金额;未支付金额
     */
    @ExcelProperty(value = "未支付金额;未支付金额")
    private BigDecimal noPayMoney;

    /**
     * 支付金额;支付金额
     */
    @ExcelProperty(value = "支付金额;支付金额")
    private BigDecimal payMoney;

    /**
     * 专家人数;专家人数
     */
    @ExcelProperty(value = "专家人数;专家人数")
    private Long expertCount;

    /**
     * 结算周期;结算周期
     */
    @ExcelProperty(value = "结算周期;结算周期")
    private String moneyCycle;

    /**
     * 状态
     */
    @ExcelProperty(value = "状态")
    private String status;

    /**
     * 备注
     */
    @ExcelProperty(value = "备注")
    private String remark;


}
