package org.dromara.zjk.statement.domain.vo;

import java.math.BigDecimal;
import org.dromara.zjk.statement.domain.ZjkMoneyExpertStatement;
import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import org.dromara.common.excel.annotation.ExcelDictFormat;
import org.dromara.common.excel.convert.ExcelDictConvert;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;
import java.util.Date;



/**
 * 专家费用报表视图对象 zjk_money_expert_statement
 *
 * @author ygh
 * @date 2024-12-16
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = ZjkMoneyExpertStatement.class)
public class ZjkMoneyExpertStatementVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @ExcelProperty(value = "id")
    private Long id;

    /**
     * 专家姓名;专家姓名
     */
    @ExcelProperty(value = "专家姓名;专家姓名")
    private String expertName;

    /**
     * 专家类型;专家类型
     */
    @ExcelProperty(value = "专家类型;专家类型")
    private String expertType;

    /**
     * 总费用;总费用
     */
    @ExcelProperty(value = "总费用;总费用")
    private BigDecimal sumFee;

    /**
     * 未支付费用;未支付费用
     */
    @ExcelProperty(value = "未支付费用;未支付费用")
    private BigDecimal noPayFee;

    /**
     * 已支付费用;已支付费用
     */
    @ExcelProperty(value = "已支付费用;已支付费用")
    private BigDecimal payFee;

    /**
     * 结算周期;结算周期
     */
    @ExcelProperty(value = "结算周期;结算周期")
    private String moneyCycle;

    /**
     * 状态
     */
    @ExcelProperty(value = "状态")
    private String status;

    /**
     * 备注
     */
    @ExcelProperty(value = "备注")
    private String remark;


}
