package org.dromara.zjk.statement.domain.vo;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.dromara.zjk.statement.domain.ZjkMoneyStatement;
import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import org.dromara.common.excel.annotation.ExcelDictFormat;
import org.dromara.common.excel.convert.ExcelDictConvert;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;
import java.util.Date;



/**
 * 费用报表视图对象 zjk_money_statement
 *
 * @author ygh
 * @date 2024-12-16
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = ZjkMoneyStatement.class)
public class ZjkMoneyStatementVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @ExcelProperty(value = "id")
    private Long id;

    /**
     * 编号;编号
     */
    @ExcelProperty(value = "编号;编号")
    private String statementSn;

    /**
     * 类型(年报，月报);类型(年报，月报)
     */
    @ExcelProperty(value = "类型(年报，月报);类型(年报，月报)")
    private String type;

    /**
     * 周期（每年，每月）;周期（每年，每月）
     */
    @ExcelProperty(value = "周期", converter = ExcelDictConvert.class)
    @ExcelDictFormat(readConverterExp = "每=年，每月")
    private String period;

    /**
     * 时间范围开始
     */
    @ExcelProperty(value = "时间范围开始")
    private Date scopeStartTime;

    /**
     * 状态
     */
    @ExcelProperty(value = "状态")
    private String status;

    /**
     * 备注
     */
    @ExcelProperty(value = "备注")
    private String remark;

    /**
     * 时间范围结束
     */
    @ExcelProperty(value = "时间范围结束")
    private Date scopeEndTime;

    /**
     * 报表时间
     */
    private Date nameDate;
}
