package org.dromara.zjk.statement.service;

import org.dromara.zjk.statement.domain.ZjkMoneyAnalyseStatement;
import org.dromara.zjk.statement.domain.vo.ZjkMoneyAnalyseStatementVo;
import org.dromara.zjk.statement.domain.bo.ZjkMoneyAnalyseStatementBo;
import org.dromara.common.mybatis.core.page.TableDataInfo;
import org.dromara.common.mybatis.core.page.PageQuery;

import java.util.Collection;
import java.util.List;

/**
 * 报表分析Service接口
 *
 * @author ygh
 * @date 2024-12-16
 */
public interface IZjkMoneyAnalyseStatementService {

    /**
     * 查询报表分析
     *
     * @param id 主键
     * @return 报表分析
     */
    ZjkMoneyAnalyseStatementVo queryById(Long id);

    /**
     * 分页查询报表分析列表
     *
     * @param bo        查询条件
     * @param pageQuery 分页参数
     * @return 报表分析分页列表
     */
    TableDataInfo<ZjkMoneyAnalyseStatementVo> queryPageList(ZjkMoneyAnalyseStatementBo bo, PageQuery pageQuery);

    /**
     * 查询符合条件的报表分析列表
     *
     * @param bo 查询条件
     * @return 报表分析列表
     */
    List<ZjkMoneyAnalyseStatementVo> queryList(ZjkMoneyAnalyseStatementBo bo);

    /**
     * 新增报表分析
     *
     * @param bo 报表分析
     * @return 是否新增成功
     */
    Boolean insertByBo(ZjkMoneyAnalyseStatementBo bo);

    /**
     * 修改报表分析
     *
     * @param bo 报表分析
     * @return 是否修改成功
     */
    Boolean updateByBo(ZjkMoneyAnalyseStatementBo bo);

    /**
     * 校验并批量删除报表分析信息
     *
     * @param ids     待删除的主键集合
     * @param isValid 是否进行有效性校验
     * @return 是否删除成功
     */
    Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);
}
