package org.dromara.zjk.statement.service;

import org.dromara.zjk.statement.domain.ZjkMoneyCollectStatement;
import org.dromara.zjk.statement.domain.vo.ZjkMoneyCollectStatementVo;
import org.dromara.zjk.statement.domain.bo.ZjkMoneyCollectStatementBo;
import org.dromara.common.mybatis.core.page.TableDataInfo;
import org.dromara.common.mybatis.core.page.PageQuery;

import java.util.Collection;
import java.util.List;

/**
 * 报表统计Service接口
 *
 * @author wt
 * @date 2024-12-16
 */
public interface IZjkMoneyCollectStatementService {

    /**
     * 查询报表统计
     *
     * @param id 主键
     * @return 报表统计
     */
    ZjkMoneyCollectStatementVo queryById(Long id);

    /**
     * 分页查询报表统计列表
     *
     * @param bo        查询条件
     * @param pageQuery 分页参数
     * @return 报表统计分页列表
     */
    TableDataInfo<ZjkMoneyCollectStatementVo> queryPageList(ZjkMoneyCollectStatementBo bo, PageQuery pageQuery);

    /**
     * 查询符合条件的报表统计列表
     *
     * @param bo 查询条件
     * @return 报表统计列表
     */
    List<ZjkMoneyCollectStatementVo> queryList(ZjkMoneyCollectStatementBo bo);

    /**
     * 新增报表统计
     *
     * @param bo 报表统计
     * @return 是否新增成功
     */
    Boolean insertByBo(ZjkMoneyCollectStatementBo bo);

    /**
     * 修改报表统计
     *
     * @param bo 报表统计
     * @return 是否修改成功
     */
    Boolean updateByBo(ZjkMoneyCollectStatementBo bo);

    /**
     * 校验并批量删除报表统计信息
     *
     * @param ids     待删除的主键集合
     * @param isValid 是否进行有效性校验
     * @return 是否删除成功
     */
    Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);
}
