package org.dromara.zjk.statement.service.impl;

import org.dromara.common.core.utils.MapstructUtils;
import org.dromara.common.core.utils.StringUtils;
import org.dromara.common.mybatis.core.page.TableDataInfo;
import org.dromara.common.mybatis.core.page.PageQuery;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.dromara.zjk.statement.domain.bo.ZjkMoneyAnalyseStatementBo;
import org.dromara.zjk.statement.domain.vo.ZjkMoneyAnalyseStatementVo;
import org.dromara.zjk.statement.domain.ZjkMoneyAnalyseStatement;
import org.dromara.zjk.statement.mapper.ZjkMoneyAnalyseStatementMapper;
import org.dromara.zjk.statement.service.IZjkMoneyAnalyseStatementService;

import java.util.List;
import java.util.Map;
import java.util.Collection;

/**
 * 报表分析Service业务层处理
 *
 * @author ygh
 * @date 2024-12-16
 */
@RequiredArgsConstructor
@Service
public class ZjkMoneyAnalyseStatementServiceImpl implements IZjkMoneyAnalyseStatementService {

    private final ZjkMoneyAnalyseStatementMapper baseMapper;

    /**
     * 查询报表分析
     *
     * @param id 主键
     * @return 报表分析
     */
    @Override
    public ZjkMoneyAnalyseStatementVo queryById(Long id){
        return baseMapper.selectVoById(id);
    }

    /**
     * 分页查询报表分析列表
     *
     * @param bo        查询条件
     * @param pageQuery 分页参数
     * @return 报表分析分页列表
     */
    @Override
    public TableDataInfo<ZjkMoneyAnalyseStatementVo> queryPageList(ZjkMoneyAnalyseStatementBo bo, PageQuery pageQuery) {
        LambdaQueryWrapper<ZjkMoneyAnalyseStatement> lqw = buildQueryWrapper(bo);
        Page<ZjkMoneyAnalyseStatementVo> result = baseMapper.selectVoPage(pageQuery.build(), lqw);
        return TableDataInfo.build(result);
    }

    /**
     * 查询符合条件的报表分析列表
     *
     * @param bo 查询条件
     * @return 报表分析列表
     */
    @Override
    public List<ZjkMoneyAnalyseStatementVo> queryList(ZjkMoneyAnalyseStatementBo bo) {
        LambdaQueryWrapper<ZjkMoneyAnalyseStatement> lqw = buildQueryWrapper(bo);
        return baseMapper.selectVoList(lqw);
    }

    private LambdaQueryWrapper<ZjkMoneyAnalyseStatement> buildQueryWrapper(ZjkMoneyAnalyseStatementBo bo) {
        Map<String, Object> params = bo.getParams();
        LambdaQueryWrapper<ZjkMoneyAnalyseStatement> lqw = Wrappers.lambdaQuery();
        lqw.eq(StringUtils.isNotBlank(bo.getExpertType()), ZjkMoneyAnalyseStatement::getExpertType, bo.getExpertType());
        lqw.eq(bo.getSumFee() != null, ZjkMoneyAnalyseStatement::getSumFee, bo.getSumFee());
        lqw.eq(bo.getProportion() != null, ZjkMoneyAnalyseStatement::getProportion, bo.getProportion());
        lqw.eq(bo.getTendency() != null, ZjkMoneyAnalyseStatement::getTendency, bo.getTendency());
        lqw.eq(bo.getStatementId() != null, ZjkMoneyAnalyseStatement::getStatementId, bo.getStatementId());
        lqw.eq(StringUtils.isNotBlank(bo.getStatus()), ZjkMoneyAnalyseStatement::getStatus, bo.getStatus());
        return lqw;
    }

    /**
     * 新增报表分析
     *
     * @param bo 报表分析
     * @return 是否新增成功
     */
    @Override
    public Boolean insertByBo(ZjkMoneyAnalyseStatementBo bo) {
        ZjkMoneyAnalyseStatement add = MapstructUtils.convert(bo, ZjkMoneyAnalyseStatement.class);
        validEntityBeforeSave(add);
        boolean flag = baseMapper.insert(add) > 0;
        if (flag) {
            bo.setId(add.getId());
        }
        return flag;
    }

    /**
     * 修改报表分析
     *
     * @param bo 报表分析
     * @return 是否修改成功
     */
    @Override
    public Boolean updateByBo(ZjkMoneyAnalyseStatementBo bo) {
        ZjkMoneyAnalyseStatement update = MapstructUtils.convert(bo, ZjkMoneyAnalyseStatement.class);
        validEntityBeforeSave(update);
        return baseMapper.updateById(update) > 0;
    }

    /**
     * 保存前的数据校验
     */
    private void validEntityBeforeSave(ZjkMoneyAnalyseStatement entity){
        //TODO 做一些数据校验,如唯一约束
    }

    /**
     * 校验并批量删除报表分析信息
     *
     * @param ids     待删除的主键集合
     * @param isValid 是否进行有效性校验
     * @return 是否删除成功
     */
    @Override
    public Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid) {
        if(isValid){
            //TODO 做一些业务上的校验,判断是否需要校验
        }
        return baseMapper.deleteByIds(ids) > 0;
    }
}
