package org.dromara.zjk.utils;

import cn.hutool.core.date.DateUtil;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author : yanguohua
 * @version : 1.0
 * @date : 2024/9/11 17:25
 */
public class DateRangUtils {
    public static List<String> getDaysRange(Integer days) {
        List<String> res = new ArrayList<>();
        // 获取当前日期
        Date today = DateUtil.date();
        for (int i = (-days + 1); i < 1; i++) {
            Date daysAgo = DateUtil.offsetDay(today, i);
            res.add(DateUtil.format(daysAgo, "yyyy-MM-dd"));
        }
        return res;
    }

    public static List<String> getMonthsRange(Integer days) {
        List<String> res = new ArrayList<>();
        // 获取当前日期
        Date today = DateUtil.date();
        for (int i = -days + 1; i <= 0; i++) {
            Date daysAgo = DateUtil.offsetMonth(today, i);
            res.add(DateUtil.month(daysAgo) + 1 + "月");
        }
        return res;
    }


}
