package org.dromara.zjk.utils;

import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import java.util.Base64;

public class EncryptionUtil {
    private static final String ALGORITHM = "AES";

    public static String encrypt(String data, String key) throws Exception {
        SecretKey secretKey = getKey(key);
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(Cipher.ENCRYPT_MODE, secretKey);
        byte[] encryptedData = cipher.doFinal(data.getBytes());
        return Base64.getEncoder().encodeToString(encryptedData);
    }

    public static String decrypt(String encryptedData, String key) throws Exception {
        SecretKey secretKey = getKey(key);
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(Cipher.DECRYPT_MODE, secretKey);
        byte[] decodedData = Base64.getDecoder().decode(encryptedData);
        byte[] decryptedData = cipher.doFinal(decodedData);
        return new String(decryptedData);
    }

    private static SecretKey getKey(String key) {
        return new javax.crypto.spec.SecretKeySpec(key.getBytes(), ALGORITHM);
    }

    public static void main(String[] args) throws Exception {
        String decryptedData = EncryptionUtil.decrypt("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", "k6psy7kafT%UaPd2");
        System.out.println(decryptedData);
    }
}
