/*
 Navicat Premium Data Transfer

 Source Server         : dev-专家库
 Source Server Type    : PostgreSQL
 Source Server Version : 120001
 Source Host           : 172.16.201.65:54321
 Source Catalog        : zjk-test-cloud
 Source Schema         : public

 Target Server Type    : PostgreSQL
 Target Server Version : 120001
 File Encoding         : 65001

 Date: 04/07/2025 10:54:23
*/


-- ----------------------------
-- Table structure for zjk_annual_inspection
-- ----------------------------
DROP TABLE IF EXISTS "public"."zjk_annual_inspection";
CREATE TABLE "public"."zjk_annual_inspection" (
  "id" int8 NOT NULL,
  "user_id" int8,
  "expert_id" int8,
  "annual_inspection_sn" varchar(255) COLLATE "pg_catalog"."default",
  "annual_inspection_name" varchar(255) COLLATE "pg_catalog"."default",
  "annual_inspection_type" varchar(255) COLLATE "pg_catalog"."default",
  "annual_inspection_status" varchar(255) COLLATE "pg_catalog"."default",
  "audit_time" "sys"."date",
  "tenant_id" varchar(40) COLLATE "pg_catalog"."default",
  "create_by" int8,
  "create_time" "sys"."date",
  "update_by" int8,
  "update_time" "sys"."date",
  "del_flag" int4 DEFAULT 0,
  "create_dept" int8,
  "reason" varchar(255) COLLATE "pg_catalog"."default",
  "hmac" varchar(128) COLLATE "pg_catalog"."default"
)
;
COMMENT ON COLUMN "public"."zjk_annual_inspection"."id" IS 'id';
COMMENT ON COLUMN "public"."zjk_annual_inspection"."user_id" IS '用户 id';
COMMENT ON COLUMN "public"."zjk_annual_inspection"."expert_id" IS '专家 id';
COMMENT ON COLUMN "public"."zjk_annual_inspection"."annual_inspection_sn" IS '年检编号';
COMMENT ON COLUMN "public"."zjk_annual_inspection"."annual_inspection_name" IS '年检名称';
COMMENT ON COLUMN "public"."zjk_annual_inspection"."annual_inspection_type" IS '审核方式(1 人工年检 2 自动年检)';
COMMENT ON COLUMN "public"."zjk_annual_inspection"."annual_inspection_status" IS '年检状态(1 待年检 2 已通过 3 未通过)';
COMMENT ON COLUMN "public"."zjk_annual_inspection"."audit_time" IS '审核时间';
COMMENT ON COLUMN "public"."zjk_annual_inspection"."tenant_id" IS '租户号';
COMMENT ON COLUMN "public"."zjk_annual_inspection"."create_by" IS '创建人';
COMMENT ON COLUMN "public"."zjk_annual_inspection"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."zjk_annual_inspection"."update_by" IS '更新人';
COMMENT ON COLUMN "public"."zjk_annual_inspection"."update_time" IS '更新时间';
COMMENT ON COLUMN "public"."zjk_annual_inspection"."del_flag" IS '逻辑删除';
COMMENT ON COLUMN "public"."zjk_annual_inspection"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."zjk_annual_inspection"."reason" IS '不通过原因';

-- ----------------------------
-- Table structure for zjk_annual_inspection_records
-- ----------------------------
DROP TABLE IF EXISTS "public"."zjk_annual_inspection_records";
CREATE TABLE "public"."zjk_annual_inspection_records" (
  "id" int8 NOT NULL,
  "user_id" int8,
  "expert_id" int8,
  "records_sn" varchar(255) COLLATE "pg_catalog"."default",
  "annual_inspection_sn" varchar(255) COLLATE "pg_catalog"."default",
  "annual_inspection_name" varchar(255) COLLATE "pg_catalog"."default",
  "audit_type" varchar(255) COLLATE "pg_catalog"."default",
  "annual_inspection_status" varchar(255) COLLATE "pg_catalog"."default",
  "audit_time" "sys"."date",
  "tenant_id" varchar(40) COLLATE "pg_catalog"."default",
  "create_by" int8,
  "create_time" "sys"."date",
  "update_by" int8,
  "update_time" "sys"."date",
  "del_flag" int4 DEFAULT 0,
  "create_dept" int8
)
;
COMMENT ON COLUMN "public"."zjk_annual_inspection_records"."id" IS 'id';
COMMENT ON COLUMN "public"."zjk_annual_inspection_records"."user_id" IS '用户 id';
COMMENT ON COLUMN "public"."zjk_annual_inspection_records"."expert_id" IS '专家 id';
COMMENT ON COLUMN "public"."zjk_annual_inspection_records"."records_sn" IS '年检记录编号';
COMMENT ON COLUMN "public"."zjk_annual_inspection_records"."annual_inspection_sn" IS '年检审核编号';
COMMENT ON COLUMN "public"."zjk_annual_inspection_records"."annual_inspection_name" IS '年检名称';
COMMENT ON COLUMN "public"."zjk_annual_inspection_records"."audit_type" IS '审核方式(1 人工年检 2 自动年检)';
COMMENT ON COLUMN "public"."zjk_annual_inspection_records"."annual_inspection_status" IS '年检状态(1 待年检 2 已通过 3 未通过)';
COMMENT ON COLUMN "public"."zjk_annual_inspection_records"."audit_time" IS '审核时间';
COMMENT ON COLUMN "public"."zjk_annual_inspection_records"."tenant_id" IS '租户号';
COMMENT ON COLUMN "public"."zjk_annual_inspection_records"."create_by" IS '创建人';
COMMENT ON COLUMN "public"."zjk_annual_inspection_records"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."zjk_annual_inspection_records"."update_by" IS '更新人';
COMMENT ON COLUMN "public"."zjk_annual_inspection_records"."update_time" IS '更新时间';
COMMENT ON COLUMN "public"."zjk_annual_inspection_records"."del_flag" IS '逻辑删除';
COMMENT ON COLUMN "public"."zjk_annual_inspection_records"."create_dept" IS '创建部门';
COMMENT ON TABLE "public"."zjk_annual_inspection_records" IS '年检记录';

-- ----------------------------
-- Table structure for zjk_approval_process_logs
-- ----------------------------
DROP TABLE IF EXISTS "public"."zjk_approval_process_logs";
CREATE TABLE "public"."zjk_approval_process_logs" (
  "id" int8 NOT NULL,
  "action_item" varchar(255) COLLATE "pg_catalog"."default",
  "action_content" varchar(255) COLLATE "pg_catalog"."default",
  "approval_opinions" varchar(255) COLLATE "pg_catalog"."default",
  "tenant_id" varchar(255) COLLATE "pg_catalog"."default",
  "create_by" int8,
  "create_time" "sys"."date",
  "update_by" int8,
  "update_time" "sys"."date",
  "del_flag" int4 DEFAULT 0,
  "create_dept" int8
)
;
COMMENT ON COLUMN "public"."zjk_approval_process_logs"."id" IS 'id';
COMMENT ON COLUMN "public"."zjk_approval_process_logs"."action_item" IS '操作项(1 审批发起 2 审批通过 3 审批拒绝)';
COMMENT ON COLUMN "public"."zjk_approval_process_logs"."action_content" IS '操作内容(1.专家入库 2.专家出库 3.专家信息变更 4.项目审批 5.长期请假)';
COMMENT ON COLUMN "public"."zjk_approval_process_logs"."approval_opinions" IS '审批意见';
COMMENT ON COLUMN "public"."zjk_approval_process_logs"."tenant_id" IS '租户号';
COMMENT ON COLUMN "public"."zjk_approval_process_logs"."create_by" IS '创建人';
COMMENT ON COLUMN "public"."zjk_approval_process_logs"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."zjk_approval_process_logs"."update_by" IS '更新人';
COMMENT ON COLUMN "public"."zjk_approval_process_logs"."update_time" IS '更新时间';
COMMENT ON COLUMN "public"."zjk_approval_process_logs"."del_flag" IS '逻辑删除';
COMMENT ON COLUMN "public"."zjk_approval_process_logs"."create_dept" IS '创建部门';
COMMENT ON TABLE "public"."zjk_approval_process_logs" IS '审批流程记录';

-- ----------------------------
-- Table structure for zjk_credit
-- ----------------------------
DROP TABLE IF EXISTS "public"."zjk_credit";
CREATE TABLE "public"."zjk_credit" (
  "credit_id" int8 NOT NULL GENERATED BY DEFAULT AS IDENTITY (
INCREMENT 1
MINVALUE  1
MAXVALUE 9223372036854775807
START 1
CACHE 1
),
  "credit_count" int4,
  "rule_id" int8,
  "create_dept" varchar(255) COLLATE "pg_catalog"."default",
  "tenant_id" varchar(8) COLLATE "pg_catalog"."default",
  "CREATE_BY" int8,
  "CREATE_TIME" timestamp(0),
  "UPDATE_BY" int8,
  "UPDATE_TIME" timestamp(0),
  "expert_id" int8,
  "user_id" int8,
  "credit" varchar(255) COLLATE "pg_catalog"."default"
)
;
COMMENT ON COLUMN "public"."zjk_credit"."credit_id" IS '租户号';
COMMENT ON COLUMN "public"."zjk_credit"."credit_count" IS '信用数值';
COMMENT ON COLUMN "public"."zjk_credit"."rule_id" IS '信用事由外键';
COMMENT ON COLUMN "public"."zjk_credit"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."zjk_credit"."tenant_id" IS '租户id';
COMMENT ON COLUMN "public"."zjk_credit"."CREATE_BY" IS '创建人';
COMMENT ON COLUMN "public"."zjk_credit"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "public"."zjk_credit"."UPDATE_BY" IS '更新人';
COMMENT ON COLUMN "public"."zjk_credit"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "public"."zjk_credit"."expert_id" IS '专家id';
COMMENT ON COLUMN "public"."zjk_credit"."user_id" IS '用户id';
COMMENT ON COLUMN "public"."zjk_credit"."credit" IS '奖惩分值';
COMMENT ON TABLE "public"."zjk_credit" IS '信用记录';

-- ----------------------------
-- Table structure for zjk_credit_lv
-- ----------------------------
DROP TABLE IF EXISTS "public"."zjk_credit_lv";
CREATE TABLE "public"."zjk_credit_lv" (
  "id" int4 NOT NULL DEFAULT nextval('zjk_credit_lv_id_seq'::regclass),
  "credit_name" varchar(255) COLLATE "pg_catalog"."default",
  "credit_section_le" int4,
  "TENANT_ID" varchar(32) COLLATE "pg_catalog"."default",
  "REVISION" int4,
  "CREATE_BY" varchar(32) COLLATE "pg_catalog"."default",
  "CREATE_TIME" timestamp(6),
  "UPDATE_BY" varchar(32) COLLATE "pg_catalog"."default",
  "UPDATE_TIME" timestamp(6),
  "credit_section_ge" int4,
  "create_dept" varchar(255) COLLATE "pg_catalog"."default"
)
;
COMMENT ON COLUMN "public"."zjk_credit_lv"."id" IS '主键';
COMMENT ON COLUMN "public"."zjk_credit_lv"."credit_name" IS '信用等级名称';
COMMENT ON COLUMN "public"."zjk_credit_lv"."credit_section_le" IS '信用区间>';
COMMENT ON COLUMN "public"."zjk_credit_lv"."TENANT_ID" IS '租户号';
COMMENT ON COLUMN "public"."zjk_credit_lv"."REVISION" IS '乐观锁';
COMMENT ON COLUMN "public"."zjk_credit_lv"."CREATE_BY" IS '创建人';
COMMENT ON COLUMN "public"."zjk_credit_lv"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "public"."zjk_credit_lv"."UPDATE_BY" IS '更新人';
COMMENT ON COLUMN "public"."zjk_credit_lv"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "public"."zjk_credit_lv"."credit_section_ge" IS '信用区间<';
COMMENT ON COLUMN "public"."zjk_credit_lv"."create_dept" IS '创建部门';
COMMENT ON TABLE "public"."zjk_credit_lv" IS '信用等级';

-- ----------------------------
-- Table structure for zjk_credit_reward
-- ----------------------------
DROP TABLE IF EXISTS "public"."zjk_credit_reward";
CREATE TABLE "public"."zjk_credit_reward" (
  "ID" varchar(32) COLLATE "pg_catalog"."default" NOT NULL,
  "reward_name" varchar(255) COLLATE "pg_catalog"."default",
  "reward_type" int4,
  "reward_content" varchar(255) COLLATE "pg_catalog"."default",
  "reward_obj" int4,
  "effect_flag" varchar(32) COLLATE "pg_catalog"."default",
  "effect_standard" int2,
  "reward_until" timestamp(0),
  "is_forever" int2,
  "create_dept" varchar(255) COLLATE "pg_catalog"."default",
  "tenant_id" varchar(8) COLLATE "pg_catalog"."default",
  "status" int4,
  "CREATE_BY" int8,
  "CREATE_TIME" timestamp(0),
  "UPDATE_BY" int8,
  "UPDATE_TIME" timestamp(0),
  "sort" int2
)
;
COMMENT ON COLUMN "public"."zjk_credit_reward"."ID" IS '租户号';
COMMENT ON COLUMN "public"."zjk_credit_reward"."reward_name" IS '信用奖励名称';
COMMENT ON COLUMN "public"."zjk_credit_reward"."reward_type" IS '激励类型;字典值credit_reward_type';
COMMENT ON COLUMN "public"."zjk_credit_reward"."reward_content" IS '激励内容';
COMMENT ON COLUMN "public"."zjk_credit_reward"."reward_obj" IS '激励标的;字典值 信用';
COMMENT ON COLUMN "public"."zjk_credit_reward"."effect_flag" IS '生效符号;><=';
COMMENT ON COLUMN "public"."zjk_credit_reward"."effect_standard" IS '生效标准;临界分值';
COMMENT ON COLUMN "public"."zjk_credit_reward"."reward_until" IS '激励截至时间';
COMMENT ON COLUMN "public"."zjk_credit_reward"."is_forever" IS '是否永久;1：永久；0不永久';
COMMENT ON COLUMN "public"."zjk_credit_reward"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."zjk_credit_reward"."tenant_id" IS '租户id';
COMMENT ON COLUMN "public"."zjk_credit_reward"."status" IS '启用标识';
COMMENT ON COLUMN "public"."zjk_credit_reward"."CREATE_BY" IS '创建人';
COMMENT ON COLUMN "public"."zjk_credit_reward"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "public"."zjk_credit_reward"."UPDATE_BY" IS '更新人';
COMMENT ON COLUMN "public"."zjk_credit_reward"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "public"."zjk_credit_reward"."sort" IS '排序';
COMMENT ON TABLE "public"."zjk_credit_reward" IS '信用奖励';

-- ----------------------------
-- Table structure for zjk_credit_rule
-- ----------------------------
DROP TABLE IF EXISTS "public"."zjk_credit_rule";
CREATE TABLE "public"."zjk_credit_rule" (
  "ID" int8 NOT NULL,
  "rule_name" varchar(255) COLLATE "pg_catalog"."default",
  "expire_time" timestamp(0),
  "is_forever" int8,
  "create_dept" varchar(255) COLLATE "pg_catalog"."default",
  "tenant_id" varchar(8) COLLATE "pg_catalog"."default",
  "status" int4,
  "CREATE_BY" int8,
  "CREATE_TIME" timestamp(0),
  "UPDATE_BY" int8,
  "UPDATE_TIME" timestamp(0),
  "each_score" int4,
  "rule_key" varchar COLLATE "pg_catalog"."default",
  "point_reason" varchar(255) COLLATE "pg_catalog"."default"
)
;
COMMENT ON COLUMN "public"."zjk_credit_rule"."ID" IS '租户号';
COMMENT ON COLUMN "public"."zjk_credit_rule"."rule_name" IS '规则名称';
COMMENT ON COLUMN "public"."zjk_credit_rule"."expire_time" IS '到期时间';
COMMENT ON COLUMN "public"."zjk_credit_rule"."is_forever" IS '是否永久';
COMMENT ON COLUMN "public"."zjk_credit_rule"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."zjk_credit_rule"."tenant_id" IS '租户id';
COMMENT ON COLUMN "public"."zjk_credit_rule"."status" IS '启用标识';
COMMENT ON COLUMN "public"."zjk_credit_rule"."CREATE_BY" IS '创建人';
COMMENT ON COLUMN "public"."zjk_credit_rule"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "public"."zjk_credit_rule"."UPDATE_BY" IS '更新人';
COMMENT ON COLUMN "public"."zjk_credit_rule"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "public"."zjk_credit_rule"."each_score" IS '每次得分';
COMMENT ON COLUMN "public"."zjk_credit_rule"."rule_key" IS '信用规则code';
COMMENT ON COLUMN "public"."zjk_credit_rule"."point_reason" IS '信用获得事由';
COMMENT ON TABLE "public"."zjk_credit_rule" IS '信用规则表';

-- ----------------------------
-- Table structure for zjk_credit_user
-- ----------------------------
DROP TABLE IF EXISTS "public"."zjk_credit_user";
CREATE TABLE "public"."zjk_credit_user" (
  "ID" varchar(32) COLLATE "pg_catalog"."default" NOT NULL,
  "user_id" int8,
  "expert_id" int8,
  "reward_id" varchar(32) COLLATE "pg_catalog"."default",
  "reward_title" varchar(255) COLLATE "pg_catalog"."default",
  "credit_count" int2 DEFAULT 100,
  "create_dept" varchar(255) COLLATE "pg_catalog"."default",
  "tenant_id" varchar(8) COLLATE "pg_catalog"."default",
  "CREATE_BY" int8,
  "CREATE_TIME" timestamp(0),
  "UPDATE_BY" int8,
  "UPDATE_TIME" timestamp(0),
  "change_time" timestamp(6) DEFAULT CURRENT_TIMESTAMP,
  "lv_id" int8 DEFAULT 1
)
;
COMMENT ON COLUMN "public"."zjk_credit_user"."ID" IS '租户号';
COMMENT ON COLUMN "public"."zjk_credit_user"."user_id" IS '用户id';
COMMENT ON COLUMN "public"."zjk_credit_user"."expert_id" IS '专家id';
COMMENT ON COLUMN "public"."zjk_credit_user"."reward_id" IS '奖励id';
COMMENT ON COLUMN "public"."zjk_credit_user"."reward_title" IS '奖励内容';
COMMENT ON COLUMN "public"."zjk_credit_user"."credit_count" IS '总信用';
COMMENT ON COLUMN "public"."zjk_credit_user"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."zjk_credit_user"."tenant_id" IS '租户id';
COMMENT ON COLUMN "public"."zjk_credit_user"."CREATE_BY" IS '创建人';
COMMENT ON COLUMN "public"."zjk_credit_user"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "public"."zjk_credit_user"."UPDATE_BY" IS '更新人';
COMMENT ON COLUMN "public"."zjk_credit_user"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "public"."zjk_credit_user"."change_time" IS '信用变动时间';
COMMENT ON COLUMN "public"."zjk_credit_user"."lv_id" IS '信用等级id';
COMMENT ON TABLE "public"."zjk_credit_user" IS '信用用户';

-- ----------------------------
-- Table structure for zjk_data_changes_logs
-- ----------------------------
DROP TABLE IF EXISTS "public"."zjk_data_changes_logs";
CREATE TABLE "public"."zjk_data_changes_logs" (
  "id" int8 NOT NULL,
  "change_type" varchar(255) COLLATE "pg_catalog"."default",
  "business_type" varchar(255) COLLATE "pg_catalog"."default",
  "before_oper" varchar(5000) COLLATE "pg_catalog"."default",
  "after_oper" varchar(5000) COLLATE "pg_catalog"."default",
  "oper_ip" varchar(255) COLLATE "pg_catalog"."default",
  "tenant_id" varchar(255) COLLATE "pg_catalog"."default",
  "create_by" int8,
  "create_time" "sys"."date",
  "create_dept" int8,
  "update_by" int8,
  "update_time" "sys"."date",
  "del_flag" int4 DEFAULT 0
)
;
COMMENT ON COLUMN "public"."zjk_data_changes_logs"."id" IS 'id';
COMMENT ON COLUMN "public"."zjk_data_changes_logs"."change_type" IS '操作类型';
COMMENT ON COLUMN "public"."zjk_data_changes_logs"."business_type" IS '业务类型 1.专家信息变更 2.项目信息变更';
COMMENT ON COLUMN "public"."zjk_data_changes_logs"."before_oper" IS '操作前数据';
COMMENT ON COLUMN "public"."zjk_data_changes_logs"."after_oper" IS '操作后数据';
COMMENT ON COLUMN "public"."zjk_data_changes_logs"."oper_ip" IS '操作 ip';
COMMENT ON COLUMN "public"."zjk_data_changes_logs"."tenant_id" IS '租户号';
COMMENT ON COLUMN "public"."zjk_data_changes_logs"."create_by" IS '创建人';
COMMENT ON COLUMN "public"."zjk_data_changes_logs"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."zjk_data_changes_logs"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."zjk_data_changes_logs"."update_by" IS '更新人';
COMMENT ON COLUMN "public"."zjk_data_changes_logs"."update_time" IS '更新时间';
COMMENT ON COLUMN "public"."zjk_data_changes_logs"."del_flag" IS '逻辑删除';
COMMENT ON TABLE "public"."zjk_data_changes_logs" IS '数据变更记录';

-- ----------------------------
-- Table structure for zjk_evaluate
-- ----------------------------
DROP TABLE IF EXISTS "public"."zjk_evaluate";
CREATE TABLE "public"."zjk_evaluate" (
  "id" varchar(32) COLLATE "pg_catalog"."default" NOT NULL,
  "evaluate_user" int8,
  "expert_post" varchar(255) COLLATE "pg_catalog"."default",
  "item_id" varchar(64) COLLATE "pg_catalog"."default",
  "item_stage" int4,
  "bus_level_score" numeric(4,2),
  "work_attitude_score" numeric(4,2),
  "right_approval_score" numeric(4,2),
  "expert_comment" varchar(2000) COLLATE "pg_catalog"."default",
  "evaluate_file" varchar(255) COLLATE "pg_catalog"."default",
  "status" int4 DEFAULT 1,
  "tenant_id" varchar(8) COLLATE "pg_catalog"."default",
  "create_by" int8,
  "create_time" "sys"."date",
  "update_by" int8,
  "update_time" "sys"."date",
  "create_dept" varchar(255) COLLATE "pg_catalog"."default",
  "is_present" int2,
  "source_role" int4
)
;
COMMENT ON COLUMN "public"."zjk_evaluate"."id" IS '租户号';
COMMENT ON COLUMN "public"."zjk_evaluate"."evaluate_user" IS '待评人';
COMMENT ON COLUMN "public"."zjk_evaluate"."expert_post" IS '专家职务';
COMMENT ON COLUMN "public"."zjk_evaluate"."item_id" IS '项目id';
COMMENT ON COLUMN "public"."zjk_evaluate"."item_stage" IS '项目阶段';
COMMENT ON COLUMN "public"."zjk_evaluate"."bus_level_score" IS '业务水平得分';
COMMENT ON COLUMN "public"."zjk_evaluate"."work_attitude_score" IS '工作态度得分';
COMMENT ON COLUMN "public"."zjk_evaluate"."right_approval_score" IS '合规评审得分';
COMMENT ON COLUMN "public"."zjk_evaluate"."expert_comment" IS '专家评语';
COMMENT ON COLUMN "public"."zjk_evaluate"."evaluate_file" IS '专家评价文件id集合';
COMMENT ON COLUMN "public"."zjk_evaluate"."status" IS '评价状态;1:已评价；0：未评价';
COMMENT ON COLUMN "public"."zjk_evaluate"."tenant_id" IS '租户id';
COMMENT ON COLUMN "public"."zjk_evaluate"."create_by" IS '创建人';
COMMENT ON COLUMN "public"."zjk_evaluate"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."zjk_evaluate"."update_by" IS '更新人';
COMMENT ON COLUMN "public"."zjk_evaluate"."update_time" IS '更新时间';
COMMENT ON COLUMN "public"."zjk_evaluate"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."zjk_evaluate"."is_present" IS '出席情况 1：已出席；0未出席';
COMMENT ON COLUMN "public"."zjk_evaluate"."source_role" IS '评价角色（1：专家互评；0：机构管理员评价;2:项目管理员评价）';
COMMENT ON TABLE "public"."zjk_evaluate" IS '专家评价';

-- ----------------------------
-- Table structure for zjk_expert
-- ----------------------------
DROP TABLE IF EXISTS "public"."zjk_expert";
CREATE TABLE "public"."zjk_expert" (
  "expert_id" int8 NOT NULL,
  "expert_name" varchar(255) COLLATE "pg_catalog"."default",
  "sex" int8,
  "birth_date" timestamp(6),
  "contact" varchar(255) COLLATE "pg_catalog"."default",
  "work_unit" varchar(255) COLLATE "pg_catalog"."default",
  "duty" varchar(255) COLLATE "pg_catalog"."default",
  "politics" varchar(255) COLLATE "pg_catalog"."default",
  "graduate_school" varchar(255) COLLATE "pg_catalog"."default",
  "major" varchar(5000) COLLATE "pg_catalog"."default",
  "email" varchar(255) COLLATE "pg_catalog"."default",
  "professional" varchar(255) COLLATE "pg_catalog"."default",
  "professional_acquisition_date" timestamp(6),
  "work_professial" varchar(255) COLLATE "pg_catalog"."default",
  "work_professial_year" int8,
  "photograph" varchar(255) COLLATE "pg_catalog"."default",
  "perform_work_id" varchar(255) COLLATE "pg_catalog"."default",
  "other_describe" varchar(255) COLLATE "pg_catalog"."default",
  "work_experience" varchar(5000) COLLATE "pg_catalog"."default",
  "work_pluralistic" varchar(5000) COLLATE "pg_catalog"."default",
  "achievement" varchar(5000) COLLATE "pg_catalog"."default",
  "remark" varchar(255) COLLATE "pg_catalog"."default",
  "create_by" int8,
  "create_time" timestamp(6),
  "update_by" int8,
  "update_time" timestamp(6),
  "delete_flag" int8 DEFAULT 0,
  "tenant_id" varchar(32) COLLATE "pg_catalog"."default" DEFAULT '000000'::varchar,
  "create_dept" int8,
  "status" int8 DEFAULT '0'::bpchar,
  "paperpath" varchar(255) COLLATE "pg_catalog"."default",
  "patentpath" varchar(255) COLLATE "pg_catalog"."default",
  "use_flag" int8 DEFAULT 0,
  "user_id" int8,
  "approval_type" int8,
  "unit_type" int8,
  "id_card" varchar(255) COLLATE "pg_catalog"."default",
  "is_recommend" int8,
  "expert_sources" int8,
  "province" varchar(255) COLLATE "pg_catalog"."default",
  "city" varchar(255) COLLATE "pg_catalog"."default",
  "area" varchar(255) COLLATE "pg_catalog"."default",
  "address" varchar(255) COLLATE "pg_catalog"."default",
  "annual_inspection_status" varchar(255) COLLATE "pg_catalog"."default",
  "annual_inspection_time" varchar(255) COLLATE "pg_catalog"."default",
  "approval_time" timestamp(6),
  "other_path" varchar(2000) COLLATE "pg_catalog"."default",
  "retirement_time" timestamp(6),
  "position_title_level" int8,
  "origin" varchar(255) COLLATE "pg_catalog"."default",
  "unit_type_describe" varchar(255) COLLATE "pg_catalog"."default",
  "hmac" varchar(128) COLLATE "pg_catalog"."default"
)
;
COMMENT ON COLUMN "public"."zjk_expert"."expert_id" IS 'id';
COMMENT ON COLUMN "public"."zjk_expert"."expert_name" IS '专家姓名';
COMMENT ON COLUMN "public"."zjk_expert"."sex" IS '性别';
COMMENT ON COLUMN "public"."zjk_expert"."birth_date" IS '出生年月';
COMMENT ON COLUMN "public"."zjk_expert"."contact" IS '联系方式';
COMMENT ON COLUMN "public"."zjk_expert"."work_unit" IS '工作单位';
COMMENT ON COLUMN "public"."zjk_expert"."duty" IS '职务';
COMMENT ON COLUMN "public"."zjk_expert"."politics" IS '政治面貌';
COMMENT ON COLUMN "public"."zjk_expert"."graduate_school" IS '毕业院校';
COMMENT ON COLUMN "public"."zjk_expert"."major" IS '专业';
COMMENT ON COLUMN "public"."zjk_expert"."email" IS '邮箱';
COMMENT ON COLUMN "public"."zjk_expert"."professional" IS '专业技术资格';
COMMENT ON COLUMN "public"."zjk_expert"."professional_acquisition_date" IS '专业技术资格取得时间';
COMMENT ON COLUMN "public"."zjk_expert"."work_professial" IS '从事专业';
COMMENT ON COLUMN "public"."zjk_expert"."work_professial_year" IS '从事专业年限';
COMMENT ON COLUMN "public"."zjk_expert"."photograph" IS '照片';
COMMENT ON COLUMN "public"."zjk_expert"."perform_work_id" IS '从事工作或研究领域';
COMMENT ON COLUMN "public"."zjk_expert"."other_describe" IS '其他领域描述';
COMMENT ON COLUMN "public"."zjk_expert"."work_experience" IS '主要工作经历';
COMMENT ON COLUMN "public"."zjk_expert"."work_pluralistic" IS '社会兼职情况';
COMMENT ON COLUMN "public"."zjk_expert"."achievement" IS '主要论著、业绩成果及获奖情况';
COMMENT ON COLUMN "public"."zjk_expert"."remark" IS '备注';
COMMENT ON COLUMN "public"."zjk_expert"."create_by" IS '创建人';
COMMENT ON COLUMN "public"."zjk_expert"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."zjk_expert"."update_by" IS '更新人';
COMMENT ON COLUMN "public"."zjk_expert"."update_time" IS '更新时间';
COMMENT ON COLUMN "public"."zjk_expert"."delete_flag" IS '是否删除';
COMMENT ON COLUMN "public"."zjk_expert"."tenant_id" IS '租户id';
COMMENT ON COLUMN "public"."zjk_expert"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."zjk_expert"."status" IS '状态  0：暂存 1：待审批 2：正常  3：拒绝  4 离职 5退休';
COMMENT ON COLUMN "public"."zjk_expert"."paperpath" IS '论文';
COMMENT ON COLUMN "public"."zjk_expert"."patentpath" IS '专利';
COMMENT ON COLUMN "public"."zjk_expert"."use_flag" IS '是否启用';
COMMENT ON COLUMN "public"."zjk_expert"."user_id" IS '登录用户id';
COMMENT ON COLUMN "public"."zjk_expert"."approval_type" IS '审批类型  0 专家申请    1信息变更';
COMMENT ON COLUMN "public"."zjk_expert"."unit_type" IS '单位类型';
COMMENT ON COLUMN "public"."zjk_expert"."id_card" IS '身份证号';
COMMENT ON COLUMN "public"."zjk_expert"."is_recommend" IS '是否单位推荐 1 是 2 否';
COMMENT ON COLUMN "public"."zjk_expert"."expert_sources" IS '专家来源 1 省内 2 省外';
COMMENT ON COLUMN "public"."zjk_expert"."province" IS '省';
COMMENT ON COLUMN "public"."zjk_expert"."city" IS '市';
COMMENT ON COLUMN "public"."zjk_expert"."area" IS '区县';
COMMENT ON COLUMN "public"."zjk_expert"."address" IS '详细地址';
COMMENT ON COLUMN "public"."zjk_expert"."annual_inspection_status" IS '年检状态(1 待年检 2 已通过 3 未通过)';
COMMENT ON COLUMN "public"."zjk_expert"."annual_inspection_time" IS '年检时间';
COMMENT ON COLUMN "public"."zjk_expert"."approval_time" IS '审批时间';
COMMENT ON COLUMN "public"."zjk_expert"."other_path" IS '其他附件';
COMMENT ON COLUMN "public"."zjk_expert"."retirement_time" IS '退休时间';
COMMENT ON COLUMN "public"."zjk_expert"."position_title_level" IS '职称等级  字典为:money_type';
COMMENT ON COLUMN "public"."zjk_expert"."origin" IS '籍贯';
COMMENT ON COLUMN "public"."zjk_expert"."unit_type_describe" IS '单位性质其他描述';
COMMENT ON TABLE "public"."zjk_expert" IS '专家表';

-- ----------------------------
-- Table structure for zjk_expert_awards
-- ----------------------------
DROP TABLE IF EXISTS "public"."zjk_expert_awards";
CREATE TABLE "public"."zjk_expert_awards" (
  "id" int8 NOT NULL,
  "expert_id" int8,
  "awards_path" varchar(255) COLLATE "pg_catalog"."default",
  "awards_content" varchar(255) COLLATE "pg_catalog"."default",
  "tenant_id" varchar(255) COLLATE "pg_catalog"."default",
  "create_by" int8,
  "create_time" "sys"."date",
  "create_dept" int8,
  "update_by" int8,
  "update_time" "sys"."date",
  "del_flag" int4 DEFAULT 0,
  "user_id" int8,
  "register_sn" varchar(255) COLLATE "pg_catalog"."default"
)
;
COMMENT ON COLUMN "public"."zjk_expert_awards"."id" IS 'id';
COMMENT ON COLUMN "public"."zjk_expert_awards"."expert_id" IS '专家 id';
COMMENT ON COLUMN "public"."zjk_expert_awards"."awards_path" IS '获奖证书文件路径';
COMMENT ON COLUMN "public"."zjk_expert_awards"."awards_content" IS '执业资格证书名称';
COMMENT ON COLUMN "public"."zjk_expert_awards"."tenant_id" IS '租户号';
COMMENT ON COLUMN "public"."zjk_expert_awards"."create_by" IS '创建人';
COMMENT ON COLUMN "public"."zjk_expert_awards"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."zjk_expert_awards"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."zjk_expert_awards"."update_by" IS '更新人';
COMMENT ON COLUMN "public"."zjk_expert_awards"."update_time" IS '更新时间';
COMMENT ON COLUMN "public"."zjk_expert_awards"."del_flag" IS '逻辑删除';
COMMENT ON COLUMN "public"."zjk_expert_awards"."user_id" IS '用户 id';
COMMENT ON COLUMN "public"."zjk_expert_awards"."register_sn" IS '注册号';
COMMENT ON TABLE "public"."zjk_expert_awards" IS '执业资格证书名称及注册号
';

-- ----------------------------
-- Table structure for zjk_expert_chart
-- ----------------------------
DROP TABLE IF EXISTS "public"."zjk_expert_chart";
CREATE TABLE "public"."zjk_expert_chart" (
  "ID" varchar(32) COLLATE "pg_catalog"."default" NOT NULL,
  "expert_id" int8,
  "user_id" int8,
  "score_perform_work" int4,
  "score_paper" int4,
  "score_patent" int4,
  "score_work_year" int4,
  "score_awards" int4,
  "score_evaluate" int4,
  "score_join_time" int4,
  "score_credit" int4,
  "create_dept" varchar(255) COLLATE "pg_catalog"."default",
  "tenant_id" varchar(8) COLLATE "pg_catalog"."default",
  "CREATE_BY" int8,
  "CREATE_TIME" "sys"."date",
  "UPDATE_BY" int8,
  "UPDATE_TIME" "sys"."date"
)
;
COMMENT ON COLUMN "public"."zjk_expert_chart"."ID" IS '租户号';
COMMENT ON COLUMN "public"."zjk_expert_chart"."expert_id" IS '专家id';
COMMENT ON COLUMN "public"."zjk_expert_chart"."user_id" IS '用户id';
COMMENT ON COLUMN "public"."zjk_expert_chart"."score_perform_work" IS '业务领域得分';
COMMENT ON COLUMN "public"."zjk_expert_chart"."score_paper" IS '论文得分';
COMMENT ON COLUMN "public"."zjk_expert_chart"."score_patent" IS '专利得分';
COMMENT ON COLUMN "public"."zjk_expert_chart"."score_work_year" IS '工作经历得分';
COMMENT ON COLUMN "public"."zjk_expert_chart"."score_awards" IS '荣誉奖项得分';
COMMENT ON COLUMN "public"."zjk_expert_chart"."score_evaluate" IS '评价得分';
COMMENT ON COLUMN "public"."zjk_expert_chart"."score_join_time" IS '合作历史得分';
COMMENT ON COLUMN "public"."zjk_expert_chart"."score_credit" IS '信用得分';
COMMENT ON COLUMN "public"."zjk_expert_chart"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."zjk_expert_chart"."tenant_id" IS '租户id';
COMMENT ON COLUMN "public"."zjk_expert_chart"."CREATE_BY" IS '创建人';
COMMENT ON COLUMN "public"."zjk_expert_chart"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "public"."zjk_expert_chart"."UPDATE_BY" IS '更新人';
COMMENT ON COLUMN "public"."zjk_expert_chart"."UPDATE_TIME" IS '更新时间';
COMMENT ON TABLE "public"."zjk_expert_chart" IS '专家画像';

-- ----------------------------
-- Table structure for zjk_expert_history
-- ----------------------------
DROP TABLE IF EXISTS "public"."zjk_expert_history";
CREATE TABLE "public"."zjk_expert_history" (
  "id" int8 NOT NULL,
  "old_data" varchar(50000) COLLATE "pg_catalog"."default",
  "new_data" varchar(50000) COLLATE "pg_catalog"."default",
  "modified_fields" varchar(50000) COLLATE "pg_catalog"."default",
  "remark" varchar(255) COLLATE "pg_catalog"."default",
  "create_by" int8,
  "create_time" timestamp(6),
  "update_by" int8,
  "update_time" timestamp(6),
  "delete_flag" int8 DEFAULT 0,
  "tenant_id" varchar(32) COLLATE "pg_catalog"."default" DEFAULT '000000'::varchar,
  "create_dept" int8,
  "expect_id" int8
)
;
COMMENT ON COLUMN "public"."zjk_expert_history"."id" IS 'id';
COMMENT ON COLUMN "public"."zjk_expert_history"."old_data" IS '旧数据';
COMMENT ON COLUMN "public"."zjk_expert_history"."new_data" IS '新数据';
COMMENT ON COLUMN "public"."zjk_expert_history"."modified_fields" IS '差异字段';
COMMENT ON COLUMN "public"."zjk_expert_history"."remark" IS '备注';
COMMENT ON COLUMN "public"."zjk_expert_history"."create_by" IS '创建人';
COMMENT ON COLUMN "public"."zjk_expert_history"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."zjk_expert_history"."update_by" IS '更新人';
COMMENT ON COLUMN "public"."zjk_expert_history"."update_time" IS '更新时间';
COMMENT ON COLUMN "public"."zjk_expert_history"."delete_flag" IS '是否删除';
COMMENT ON COLUMN "public"."zjk_expert_history"."tenant_id" IS '租户id';
COMMENT ON COLUMN "public"."zjk_expert_history"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."zjk_expert_history"."expect_id" IS '专家 id';

-- ----------------------------
-- Table structure for zjk_expert_item
-- ----------------------------
DROP TABLE IF EXISTS "public"."zjk_expert_item";
CREATE TABLE "public"."zjk_expert_item" (
  "id" int8 NOT NULL,
  "expert_id" int8,
  "item_id" int8,
  "create_by" int8,
  "create_time" timestamp(6),
  "update_by" varchar(32) COLLATE "pg_catalog"."default",
  "update_time" timestamp(6),
  "leave_status" int2 DEFAULT 0,
  "accept_status" int2 DEFAULT 0,
  "tenant_id" varchar(20) COLLATE "pg_catalog"."default" DEFAULT '000000'::varchar,
  "create_dept" int8,
  "revision" int4,
  "review_id" int8,
  "user_id" int8,
  "dept_id" int8,
  "is_sure" int2 DEFAULT 0,
  "is_source" int2 DEFAULT 0,
  "extraction_status" int2,
  "confirm_code" varchar(255) COLLATE "pg_catalog"."default",
  "refuse_code" varchar(255) COLLATE "pg_catalog"."default"
)
;
COMMENT ON COLUMN "public"."zjk_expert_item"."id" IS 'id';
COMMENT ON COLUMN "public"."zjk_expert_item"."expert_id" IS '专家id';
COMMENT ON COLUMN "public"."zjk_expert_item"."item_id" IS '项目id';
COMMENT ON COLUMN "public"."zjk_expert_item"."create_by" IS '创建人';
COMMENT ON COLUMN "public"."zjk_expert_item"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."zjk_expert_item"."update_by" IS '更新人';
COMMENT ON COLUMN "public"."zjk_expert_item"."update_time" IS '更新时间';
COMMENT ON COLUMN "public"."zjk_expert_item"."leave_status" IS '专家请假状态（1：已请假；0：未请假）';
COMMENT ON COLUMN "public"."zjk_expert_item"."accept_status" IS '接受状态（1：已接受；0：未接受；2：拒绝; 4：取消）';
COMMENT ON COLUMN "public"."zjk_expert_item"."tenant_id" IS '租户编号';
COMMENT ON COLUMN "public"."zjk_expert_item"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."zjk_expert_item"."revision" IS '乐观锁';
COMMENT ON COLUMN "public"."zjk_expert_item"."review_id" IS '来源的抽取规则外键';
COMMENT ON COLUMN "public"."zjk_expert_item"."user_id" IS '用户id';
COMMENT ON COLUMN "public"."zjk_expert_item"."dept_id" IS '部门id';
COMMENT ON COLUMN "public"."zjk_expert_item"."is_sure" IS '是否确认(1:确认，0未确认)';
COMMENT ON COLUMN "public"."zjk_expert_item"."is_source" IS '数据来源（1：补抽，0：原始）';
COMMENT ON COLUMN "public"."zjk_expert_item"."extraction_status" IS '抽取状态(0:取消,1:确认，2:重抽)';
COMMENT ON COLUMN "public"."zjk_expert_item"."confirm_code" IS '短信确认随机码';
COMMENT ON COLUMN "public"."zjk_expert_item"."refuse_code" IS '短信拒绝随机码';
COMMENT ON TABLE "public"."zjk_expert_item" IS '抽取记录 规则对应的专家记录表';

-- ----------------------------
-- Table structure for zjk_expert_log
-- ----------------------------
DROP TABLE IF EXISTS "public"."zjk_expert_log";
CREATE TABLE "public"."zjk_expert_log" (
  "id" int8 NOT NULL,
  "name" varchar(255) COLLATE "pg_catalog"."default" DEFAULT NULL::varchar,
  "contact_info" varchar(255) COLLATE "pg_catalog"."default" DEFAULT NULL::varchar,
  "organization" varchar(255) COLLATE "pg_catalog"."default" DEFAULT NULL::varchar,
  "position" varchar(255) COLLATE "pg_catalog"."default" DEFAULT NULL::varchar,
  "entry_result" int8,
  "application_time" timestamptz(6) DEFAULT NULL::timestamp with time zone,
  "rejection_reason" varchar(255) COLLATE "pg_catalog"."default" DEFAULT NULL::varchar,
  "tenant_id" varchar(20) COLLATE "pg_catalog"."default" DEFAULT NULL::varchar,
  "create_by" int8,
  "create_time" timestamptz(6) DEFAULT NULL::timestamp with time zone,
  "update_by" int8,
  "update_time" timestamptz(6) DEFAULT NULL::timestamp with time zone,
  "expert_id" int8,
  "create_dept" varchar(255) COLLATE "pg_catalog"."default" DEFAULT NULL::varchar
)
;
COMMENT ON COLUMN "public"."zjk_expert_log"."id" IS 'id';
COMMENT ON COLUMN "public"."zjk_expert_log"."name" IS '姓名';
COMMENT ON COLUMN "public"."zjk_expert_log"."contact_info" IS '手机号';
COMMENT ON COLUMN "public"."zjk_expert_log"."organization" IS '工作单位';
COMMENT ON COLUMN "public"."zjk_expert_log"."position" IS '职位';
COMMENT ON COLUMN "public"."zjk_expert_log"."entry_result" IS '入库结果';
COMMENT ON COLUMN "public"."zjk_expert_log"."application_time" IS '申请时间';
COMMENT ON COLUMN "public"."zjk_expert_log"."rejection_reason" IS '驳回理由';
COMMENT ON COLUMN "public"."zjk_expert_log"."tenant_id" IS '租户 id';
COMMENT ON COLUMN "public"."zjk_expert_log"."create_by" IS '创建人';
COMMENT ON COLUMN "public"."zjk_expert_log"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."zjk_expert_log"."update_by" IS '修改人';
COMMENT ON COLUMN "public"."zjk_expert_log"."update_time" IS '修改时间';
COMMENT ON COLUMN "public"."zjk_expert_log"."expert_id" IS '专家用户id';
COMMENT ON TABLE "public"."zjk_expert_log" IS '专家入库记录';

-- ----------------------------
-- Table structure for zjk_expert_major
-- ----------------------------
DROP TABLE IF EXISTS "public"."zjk_expert_major";
CREATE TABLE "public"."zjk_expert_major" (
  "id" int8 NOT NULL,
  "user_id" int8,
  "expert_id" int8,
  "major" varchar(255) COLLATE "pg_catalog"."default",
  "degree" varchar(255) COLLATE "pg_catalog"."default",
  "tenant_id" varchar(255) COLLATE "pg_catalog"."default",
  "status" int4,
  "create_dept" int8,
  "create_by" int8,
  "create_time" "sys"."date",
  "update_by" int8,
  "update_time" "sys"."date",
  "remark" varchar(500) COLLATE "pg_catalog"."default"
)
;
COMMENT ON COLUMN "public"."zjk_expert_major"."id" IS 'id';
COMMENT ON COLUMN "public"."zjk_expert_major"."user_id" IS '用户id';
COMMENT ON COLUMN "public"."zjk_expert_major"."expert_id" IS '专家id';
COMMENT ON COLUMN "public"."zjk_expert_major"."major" IS '专业';
COMMENT ON COLUMN "public"."zjk_expert_major"."degree" IS '学历';
COMMENT ON COLUMN "public"."zjk_expert_major"."tenant_id" IS '租户号';
COMMENT ON COLUMN "public"."zjk_expert_major"."status" IS '状态';
COMMENT ON COLUMN "public"."zjk_expert_major"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."zjk_expert_major"."create_by" IS '创建人';
COMMENT ON COLUMN "public"."zjk_expert_major"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."zjk_expert_major"."update_by" IS '更新人';
COMMENT ON COLUMN "public"."zjk_expert_major"."update_time" IS '更新时间';
COMMENT ON COLUMN "public"."zjk_expert_major"."remark" IS '备注';
COMMENT ON TABLE "public"."zjk_expert_major" IS '专业专利信息';

-- ----------------------------
-- Table structure for zjk_expert_money_config
-- ----------------------------
DROP TABLE IF EXISTS "public"."zjk_expert_money_config";
CREATE TABLE "public"."zjk_expert_money_config" (
  "money_id" int8 NOT NULL,
  "money_type" varchar(255) COLLATE "pg_catalog"."default",
  "money_cycle" varchar(255) COLLATE "pg_catalog"."default",
  "money_number" int8,
  "tenant_id" varchar(255) COLLATE "pg_catalog"."default",
  "ASSIGN_ID" int4 DEFAULT 0,
  "create_dept" int8,
  "create_by" int8,
  "create_time" "sys"."date",
  "update_by" int8,
  "update_time" "sys"."date",
  "remark" varchar(500) COLLATE "pg_catalog"."default",
  "money_method" varchar(255) COLLATE "pg_catalog"."default"
)
;
COMMENT ON COLUMN "public"."zjk_expert_money_config"."money_id" IS '专家费用管理表';
COMMENT ON COLUMN "public"."zjk_expert_money_config"."money_type" IS '专家费用标准类型(引用字典money_type)';
COMMENT ON COLUMN "public"."zjk_expert_money_config"."money_cycle" IS '专家费用周期';
COMMENT ON COLUMN "public"."zjk_expert_money_config"."money_number" IS '专家费用';
COMMENT ON COLUMN "public"."zjk_expert_money_config"."tenant_id" IS '租户号';
COMMENT ON COLUMN "public"."zjk_expert_money_config"."ASSIGN_ID" IS '逻辑删除标志（0为正常，2为已删除）';
COMMENT ON COLUMN "public"."zjk_expert_money_config"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."zjk_expert_money_config"."create_by" IS '创建人';
COMMENT ON COLUMN "public"."zjk_expert_money_config"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."zjk_expert_money_config"."update_by" IS '更新人';
COMMENT ON COLUMN "public"."zjk_expert_money_config"."update_time" IS '更新时间';
COMMENT ON COLUMN "public"."zjk_expert_money_config"."remark" IS '备注';
COMMENT ON COLUMN "public"."zjk_expert_money_config"."money_method" IS '计费方式';
COMMENT ON TABLE "public"."zjk_expert_money_config" IS '专家费用管理表';

-- ----------------------------
-- Table structure for zjk_expert_money_fp
-- ----------------------------
DROP TABLE IF EXISTS "public"."zjk_expert_money_fp";
CREATE TABLE "public"."zjk_expert_money_fp" (
  "fp_id" int8 NOT NULL,
  "tenant_id" varchar(255) COLLATE "pg_catalog"."default",
  "ASSIGN_ID" int4 DEFAULT 0,
  "create_dept" int8,
  "create_by" int8,
  "create_time" "sys"."date",
  "update_by" int8,
  "update_time" "sys"."date",
  "fp_num" varchar(255) COLLATE "pg_catalog"."default",
  "fp_time" varchar(255) COLLATE "pg_catalog"."default",
  "fp_money" varchar(255) COLLATE "pg_catalog"."default",
  "fp_status" varchar(255) COLLATE "pg_catalog"."default",
  "fp_unit" varchar(255) COLLATE "pg_catalog"."default",
  "fp_file" varchar(500) COLLATE "pg_catalog"."default"
)
;
COMMENT ON COLUMN "public"."zjk_expert_money_fp"."tenant_id" IS '租户号';
COMMENT ON COLUMN "public"."zjk_expert_money_fp"."ASSIGN_ID" IS '逻辑删除标志（0为正常，2为已删除）';
COMMENT ON COLUMN "public"."zjk_expert_money_fp"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."zjk_expert_money_fp"."create_by" IS '创建人';
COMMENT ON COLUMN "public"."zjk_expert_money_fp"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."zjk_expert_money_fp"."update_by" IS '更新人';
COMMENT ON COLUMN "public"."zjk_expert_money_fp"."update_time" IS '更新时间';
COMMENT ON COLUMN "public"."zjk_expert_money_fp"."fp_num" IS '发票号码';
COMMENT ON COLUMN "public"."zjk_expert_money_fp"."fp_time" IS '开票日期';
COMMENT ON COLUMN "public"."zjk_expert_money_fp"."fp_money" IS '发票金额';
COMMENT ON COLUMN "public"."zjk_expert_money_fp"."fp_status" IS '发票审核状态(已核对，未核对)';
COMMENT ON COLUMN "public"."zjk_expert_money_fp"."fp_unit" IS '开票单位';
COMMENT ON COLUMN "public"."zjk_expert_money_fp"."fp_file" IS '发票附件';
COMMENT ON TABLE "public"."zjk_expert_money_fp" IS '专家费用发票管理表';

-- ----------------------------
-- Table structure for zjk_expert_money_info
-- ----------------------------
DROP TABLE IF EXISTS "public"."zjk_expert_money_info";
CREATE TABLE "public"."zjk_expert_money_info" (
  "money_id" int8 NOT NULL,
  "expert_type" varchar(255) COLLATE "pg_catalog"."default",
  "expert_id" varchar(255) COLLATE "pg_catalog"."default",
  "expert_money" numeric(255,0),
  "expert_name" varchar(255) COLLATE "pg_catalog"."default",
  "expert_unit" varchar(255) COLLATE "pg_catalog"."default",
  "tenant_id" varchar(255) COLLATE "pg_catalog"."default",
  "ASSIGN_ID" int4 DEFAULT 0,
  "create_dept" int8,
  "create_by" int8,
  "create_time" "sys"."date",
  "update_by" int8,
  "update_time" "sys"."date",
  "remark" varchar(500) COLLATE "pg_catalog"."default",
  "expert_money_flag" varchar(255) COLLATE "pg_catalog"."default" DEFAULT 1,
  "expert_money_file" varchar(500) COLLATE "pg_catalog"."default",
  "product_id" varchar(255) COLLATE "pg_catalog"."default",
  "product_type" varchar(255) COLLATE "pg_catalog"."default",
  "product_name" varchar(255) COLLATE "pg_catalog"."default",
  "expert_no_pay_money" numeric(255,0),
  "expert_pay_money" numeric(255,0),
  "expert_type_money_fee" varchar(255) COLLATE "pg_catalog"."default",
  "review_date" "sys"."date",
  "settlement_date" "sys"."date",
  "status" varchar(255) COLLATE "pg_catalog"."default" DEFAULT 0,
  "settlement_sn" varchar(255) COLLATE "pg_catalog"."default",
  "pay_sn" varchar(255) COLLATE "pg_catalog"."default",
  "expert_idcard" varchar(255) COLLATE "pg_catalog"."default",
  "expert_contact" varchar(255) COLLATE "pg_catalog"."default",
  "review_count" varchar(255) COLLATE "pg_catalog"."default",
  "money_cycle" varchar(255) COLLATE "pg_catalog"."default",
  "pay_method" varchar(255) COLLATE "pg_catalog"."default"
)
;
COMMENT ON COLUMN "public"."zjk_expert_money_info"."money_id" IS '主键';
COMMENT ON COLUMN "public"."zjk_expert_money_info"."expert_type" IS '专家类型';
COMMENT ON COLUMN "public"."zjk_expert_money_info"."expert_id" IS '专家ID';
COMMENT ON COLUMN "public"."zjk_expert_money_info"."expert_money" IS '专家费金额';
COMMENT ON COLUMN "public"."zjk_expert_money_info"."expert_name" IS '专家姓名';
COMMENT ON COLUMN "public"."zjk_expert_money_info"."expert_unit" IS '专家单位';
COMMENT ON COLUMN "public"."zjk_expert_money_info"."tenant_id" IS '租户号';
COMMENT ON COLUMN "public"."zjk_expert_money_info"."ASSIGN_ID" IS '逻辑删除标志（0为正常，2为已删除）';
COMMENT ON COLUMN "public"."zjk_expert_money_info"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."zjk_expert_money_info"."create_by" IS '创建人';
COMMENT ON COLUMN "public"."zjk_expert_money_info"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."zjk_expert_money_info"."update_by" IS '更新人';
COMMENT ON COLUMN "public"."zjk_expert_money_info"."update_time" IS '更新时间';
COMMENT ON COLUMN "public"."zjk_expert_money_info"."remark" IS '备注';
COMMENT ON COLUMN "public"."zjk_expert_money_info"."expert_money_flag" IS '是否支付(1未支付，2已支付,3部分支付)';
COMMENT ON COLUMN "public"."zjk_expert_money_info"."expert_money_file" IS '支付凭证上传附件';
COMMENT ON COLUMN "public"."zjk_expert_money_info"."product_id" IS '项目ID';
COMMENT ON COLUMN "public"."zjk_expert_money_info"."product_type" IS '项目阶段';
COMMENT ON COLUMN "public"."zjk_expert_money_info"."product_name" IS '项目名称';
COMMENT ON COLUMN "public"."zjk_expert_money_info"."expert_no_pay_money" IS '未支付金额';
COMMENT ON COLUMN "public"."zjk_expert_money_info"."expert_pay_money" IS '支付金额';
COMMENT ON COLUMN "public"."zjk_expert_money_info"."expert_type_money_fee" IS '费用';
COMMENT ON COLUMN "public"."zjk_expert_money_info"."review_date" IS '服务日期';
COMMENT ON COLUMN "public"."zjk_expert_money_info"."settlement_date" IS '结算日期';
COMMENT ON COLUMN "public"."zjk_expert_money_info"."status" IS '是否结算0 未结束 1结算';
COMMENT ON COLUMN "public"."zjk_expert_money_info"."settlement_sn" IS '结算编号';
COMMENT ON COLUMN "public"."zjk_expert_money_info"."pay_sn" IS '支付编号';
COMMENT ON COLUMN "public"."zjk_expert_money_info"."expert_idcard" IS '身份证';
COMMENT ON COLUMN "public"."zjk_expert_money_info"."expert_contact" IS '联系方式';
COMMENT ON COLUMN "public"."zjk_expert_money_info"."review_count" IS '评审次数';
COMMENT ON COLUMN "public"."zjk_expert_money_info"."money_cycle" IS '结算周期';
COMMENT ON COLUMN "public"."zjk_expert_money_info"."pay_method" IS '支付方式';
COMMENT ON TABLE "public"."zjk_expert_money_info" IS '专家费用管理表';

-- ----------------------------
-- Table structure for zjk_expert_paper
-- ----------------------------
DROP TABLE IF EXISTS "public"."zjk_expert_paper";
CREATE TABLE "public"."zjk_expert_paper" (
  "id" int8 NOT NULL,
  "expert_id" int8,
  "paper_name" varchar(255) COLLATE "pg_catalog"."default",
  "periodical_number" varchar(255) COLLATE "pg_catalog"."default",
  "paper_path" varchar(255) COLLATE "pg_catalog"."default",
  "tenant_id" varchar(255) COLLATE "pg_catalog"."default",
  "create_by" int8,
  "create_time" "sys"."date",
  "create_dept" int8,
  "update_by" int8,
  "update_time" "sys"."date",
  "del_flag" int4 DEFAULT 0,
  "user_id" int8,
  "product_id" int8,
  "review_sn" varchar(255) COLLATE "pg_catalog"."default"
)
;
COMMENT ON COLUMN "public"."zjk_expert_paper"."id" IS 'id';
COMMENT ON COLUMN "public"."zjk_expert_paper"."expert_id" IS '专家 id';
COMMENT ON COLUMN "public"."zjk_expert_paper"."paper_name" IS '论文名称';
COMMENT ON COLUMN "public"."zjk_expert_paper"."periodical_number" IS '期刊号';
COMMENT ON COLUMN "public"."zjk_expert_paper"."paper_path" IS '论文附件';
COMMENT ON COLUMN "public"."zjk_expert_paper"."tenant_id" IS '租户号';
COMMENT ON COLUMN "public"."zjk_expert_paper"."create_by" IS '创建人';
COMMENT ON COLUMN "public"."zjk_expert_paper"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."zjk_expert_paper"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."zjk_expert_paper"."update_by" IS '更新人';
COMMENT ON COLUMN "public"."zjk_expert_paper"."update_time" IS '更新时间';
COMMENT ON COLUMN "public"."zjk_expert_paper"."del_flag" IS '逻辑删除';
COMMENT ON COLUMN "public"."zjk_expert_paper"."user_id" IS '用户 Id';
COMMENT ON COLUMN "public"."zjk_expert_paper"."product_id" IS '项目id';
COMMENT ON COLUMN "public"."zjk_expert_paper"."review_sn" IS '阶段';
COMMENT ON TABLE "public"."zjk_expert_paper" IS '专家论文信息';

-- ----------------------------
-- Table structure for zjk_expert_patent
-- ----------------------------
DROP TABLE IF EXISTS "public"."zjk_expert_patent";
CREATE TABLE "public"."zjk_expert_patent" (
  "id" int8 NOT NULL,
  "expert_id" int8,
  "patent_number" varchar(255) COLLATE "pg_catalog"."default",
  "name_invention" varchar(255) COLLATE "pg_catalog"."default",
  "patent_path" varchar(255) COLLATE "pg_catalog"."default",
  "tenant_id" varchar(255) COLLATE "pg_catalog"."default",
  "create_by" int8,
  "create_time" "sys"."date",
  "create_dept" int8,
  "update_by" int8,
  "update_time" "sys"."date",
  "del_flag" int4 DEFAULT 0,
  "user_id" int8,
  "product_id" int8,
  "review_sn" varchar(255) COLLATE "pg_catalog"."default"
)
;
COMMENT ON COLUMN "public"."zjk_expert_patent"."id" IS 'id';
COMMENT ON COLUMN "public"."zjk_expert_patent"."expert_id" IS '专家 id';
COMMENT ON COLUMN "public"."zjk_expert_patent"."patent_number" IS '专利号';
COMMENT ON COLUMN "public"."zjk_expert_patent"."name_invention" IS '发明创造名称';
COMMENT ON COLUMN "public"."zjk_expert_patent"."patent_path" IS '附件路径';
COMMENT ON COLUMN "public"."zjk_expert_patent"."tenant_id" IS '租户号';
COMMENT ON COLUMN "public"."zjk_expert_patent"."create_by" IS '创建人';
COMMENT ON COLUMN "public"."zjk_expert_patent"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."zjk_expert_patent"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."zjk_expert_patent"."update_by" IS '更新人';
COMMENT ON COLUMN "public"."zjk_expert_patent"."update_time" IS '更新时间';
COMMENT ON COLUMN "public"."zjk_expert_patent"."del_flag" IS '逻辑删除';
COMMENT ON COLUMN "public"."zjk_expert_patent"."user_id" IS '用户 id';
COMMENT ON COLUMN "public"."zjk_expert_patent"."product_id" IS '项目id';
COMMENT ON COLUMN "public"."zjk_expert_patent"."review_sn" IS '项目阶段';
COMMENT ON TABLE "public"."zjk_expert_patent" IS '专家专利信息';

-- ----------------------------
-- Table structure for zjk_expert_perform_work
-- ----------------------------
DROP TABLE IF EXISTS "public"."zjk_expert_perform_work";
CREATE TABLE "public"."zjk_expert_perform_work" (
  "expert_perform_work_id" int4 NOT NULL,
  "expert_perform_work_name" varchar(255) COLLATE "pg_catalog"."default",
  "remark" varchar(255) COLLATE "pg_catalog"."default",
  "delete_flag" int4,
  "CREATED_BY" varchar(32) COLLATE "pg_catalog"."default",
  "CREATED_TIME" "sys"."date",
  "UPDATED_BY" varchar(32) COLLATE "pg_catalog"."default",
  "UPDATED_TIME" "sys"."date"
)
;
COMMENT ON COLUMN "public"."zjk_expert_perform_work"."expert_perform_work_id" IS 'id';
COMMENT ON COLUMN "public"."zjk_expert_perform_work"."expert_perform_work_name" IS '工作名称';
COMMENT ON COLUMN "public"."zjk_expert_perform_work"."remark" IS '备注';
COMMENT ON COLUMN "public"."zjk_expert_perform_work"."delete_flag" IS '是否删除';
COMMENT ON COLUMN "public"."zjk_expert_perform_work"."CREATED_BY" IS '创建人';
COMMENT ON COLUMN "public"."zjk_expert_perform_work"."CREATED_TIME" IS '创建时间';
COMMENT ON COLUMN "public"."zjk_expert_perform_work"."UPDATED_BY" IS '更新人';
COMMENT ON COLUMN "public"."zjk_expert_perform_work"."UPDATED_TIME" IS '更新时间';
COMMENT ON TABLE "public"."zjk_expert_perform_work" IS '专家从事工作选项表';

-- ----------------------------
-- Table structure for zjk_expert_professional
-- ----------------------------
DROP TABLE IF EXISTS "public"."zjk_expert_professional";
CREATE TABLE "public"."zjk_expert_professional" (
  "id" int8 NOT NULL,
  "user_id" int8 NOT NULL,
  "expert_id" int8 NOT NULL,
  "professional" varchar(255) COLLATE "pg_catalog"."default",
  "professional_date" varchar(255) COLLATE "pg_catalog"."default",
  "tenant_id" varchar(255) COLLATE "pg_catalog"."default",
  "status" int8,
  "create_dept" int8,
  "create_by" int8,
  "create_time" "sys"."date",
  "update_by" int8,
  "update_time" "sys"."date",
  "remark" varchar(500) COLLATE "pg_catalog"."default"
)
;
COMMENT ON COLUMN "public"."zjk_expert_professional"."id" IS 'id';
COMMENT ON COLUMN "public"."zjk_expert_professional"."user_id" IS '用户id';
COMMENT ON COLUMN "public"."zjk_expert_professional"."expert_id" IS '专家id';
COMMENT ON COLUMN "public"."zjk_expert_professional"."professional" IS '技术资格';
COMMENT ON COLUMN "public"."zjk_expert_professional"."professional_date" IS '技术资格取得时间';
COMMENT ON COLUMN "public"."zjk_expert_professional"."tenant_id" IS '租户号';
COMMENT ON COLUMN "public"."zjk_expert_professional"."status" IS '状态';
COMMENT ON COLUMN "public"."zjk_expert_professional"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."zjk_expert_professional"."create_by" IS '创建人';
COMMENT ON COLUMN "public"."zjk_expert_professional"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."zjk_expert_professional"."update_by" IS '更新人';
COMMENT ON COLUMN "public"."zjk_expert_professional"."update_time" IS '更新时间';
COMMENT ON COLUMN "public"."zjk_expert_professional"."remark" IS '备注';
COMMENT ON TABLE "public"."zjk_expert_professional" IS '专家库技术资格';

-- ----------------------------
-- Table structure for zjk_expert_recommend
-- ----------------------------
DROP TABLE IF EXISTS "public"."zjk_expert_recommend";
CREATE TABLE "public"."zjk_expert_recommend" (
  "id" int8 NOT NULL,
  "expert_id" int8,
  "user_id" int8,
  "expert_name" varchar(255) COLLATE "pg_catalog"."default",
  "expert_phone" varchar(255) COLLATE "pg_catalog"."default",
  "reason" varchar(500) COLLATE "pg_catalog"."default",
  "status" varchar(255) COLLATE "pg_catalog"."default",
  "tenant_id" varchar(255) COLLATE "pg_catalog"."default",
  "create_by" int8,
  "create_time" "sys"."date",
  "create_dept" int8,
  "update_by" int8,
  "update_time" "sys"."date",
  "del_flag" int4 DEFAULT 0,
  "hmac" varchar(128) COLLATE "pg_catalog"."default"
)
;
COMMENT ON COLUMN "public"."zjk_expert_recommend"."id" IS 'id';
COMMENT ON COLUMN "public"."zjk_expert_recommend"."expert_id" IS '专家 id';
COMMENT ON COLUMN "public"."zjk_expert_recommend"."user_id" IS '用户 id';
COMMENT ON COLUMN "public"."zjk_expert_recommend"."expert_name" IS '推荐专家姓名';
COMMENT ON COLUMN "public"."zjk_expert_recommend"."expert_phone" IS '专家手机号';
COMMENT ON COLUMN "public"."zjk_expert_recommend"."reason" IS '推荐理由';
COMMENT ON COLUMN "public"."zjk_expert_recommend"."status" IS '推荐状态 1 待审批 2 通过 3 驳回';
COMMENT ON COLUMN "public"."zjk_expert_recommend"."tenant_id" IS '租户号';
COMMENT ON COLUMN "public"."zjk_expert_recommend"."create_by" IS '创建人';
COMMENT ON COLUMN "public"."zjk_expert_recommend"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."zjk_expert_recommend"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."zjk_expert_recommend"."update_by" IS '更新人';
COMMENT ON COLUMN "public"."zjk_expert_recommend"."update_time" IS '更新时间';
COMMENT ON COLUMN "public"."zjk_expert_recommend"."del_flag" IS '逻辑删除';
COMMENT ON TABLE "public"."zjk_expert_recommend" IS '专家推荐表';

-- ----------------------------
-- Table structure for zjk_invoice
-- ----------------------------
DROP TABLE IF EXISTS "public"."zjk_invoice";
CREATE TABLE "public"."zjk_invoice" (
  "id" int8 NOT NULL,
  "invoice_number" int8 NOT NULL,
  "invoice_money" numeric(10,2),
  "start_date" timestamp(6),
  "expert_name" varchar(255) COLLATE "pg_catalog"."default",
  "expert_phone" varchar(11) COLLATE "pg_catalog"."default",
  "expert_id_number" varchar(18) COLLATE "pg_catalog"."default",
  "expert_title_level" varchar(255) COLLATE "pg_catalog"."default",
  "invoice_attached" varchar(255) COLLATE "pg_catalog"."default",
  "create_by" int8,
  "create_time" timestamp(6),
  "update_by" int8,
  "update_time" timestamp(6),
  "tenant_id" varchar(20) COLLATE "pg_catalog"."default",
  "create_dept" int8,
  "hmac" varchar(128) COLLATE "pg_catalog"."default"
)
;
COMMENT ON COLUMN "public"."zjk_invoice"."id" IS '发票表id';
COMMENT ON COLUMN "public"."zjk_invoice"."invoice_number" IS '发票号码';
COMMENT ON COLUMN "public"."zjk_invoice"."invoice_money" IS '发票金额';
COMMENT ON COLUMN "public"."zjk_invoice"."start_date" IS '开票日期';
COMMENT ON COLUMN "public"."zjk_invoice"."expert_name" IS '专家名称';
COMMENT ON COLUMN "public"."zjk_invoice"."expert_phone" IS '联系电话';
COMMENT ON COLUMN "public"."zjk_invoice"."expert_id_number" IS '专家身份证号';
COMMENT ON COLUMN "public"."zjk_invoice"."expert_title_level" IS '职称等级';
COMMENT ON COLUMN "public"."zjk_invoice"."invoice_attached" IS '电子发票附件相关 ,存储oss的id';
COMMENT ON COLUMN "public"."zjk_invoice"."create_by" IS '创建人';
COMMENT ON COLUMN "public"."zjk_invoice"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."zjk_invoice"."update_by" IS '更新人';
COMMENT ON COLUMN "public"."zjk_invoice"."update_time" IS '更新时间';
COMMENT ON COLUMN "public"."zjk_invoice"."tenant_id" IS '租户编码';
COMMENT ON COLUMN "public"."zjk_invoice"."create_dept" IS '创建部门';
COMMENT ON TABLE "public"."zjk_invoice" IS '发票';

-- ----------------------------
-- Table structure for zjk_item_extreation
-- ----------------------------
DROP TABLE IF EXISTS "public"."zjk_item_extreation";
CREATE TABLE "public"."zjk_item_extreation" (
  "id" int8 NOT NULL,
  "item_id" int8,
  "expert_sum" int8,
  "extraction_count" int8 DEFAULT 1,
  "extracted_sum" int4 DEFAULT 0,
  "extraction_status" int2 DEFAULT 0,
  "extraction_time" timestamp(0),
  "extraction_user" varchar(255) COLLATE "pg_catalog"."default",
  "extraction_sn" varchar(255) COLLATE "pg_catalog"."default",
  "create_by" varchar(32) COLLATE "pg_catalog"."default",
  "create_time" timestamp(6),
  "update_by" varchar(32) COLLATE "pg_catalog"."default",
  "update_time" timestamp(6),
  "tenant_id" varchar(20) COLLATE "pg_catalog"."default" DEFAULT '000000'::varchar,
  "create_dept" int8,
  "revision" int4,
  "review_id" int8,
  "is_sure" varchar(255) COLLATE "pg_catalog"."default" DEFAULT 0
)
;
COMMENT ON COLUMN "public"."zjk_item_extreation"."id" IS 'id';
COMMENT ON COLUMN "public"."zjk_item_extreation"."item_id" IS '项目id';
COMMENT ON COLUMN "public"."zjk_item_extreation"."expert_sum" IS '专家数量';
COMMENT ON COLUMN "public"."zjk_item_extreation"."extraction_count" IS '抽取次数';
COMMENT ON COLUMN "public"."zjk_item_extreation"."extracted_sum" IS '已抽取人数';
COMMENT ON COLUMN "public"."zjk_item_extreation"."extraction_status" IS '抽取状态(0，待抽取，1.部分抽取，2.抽取成功，3.抽取失败，4.抽取失效)';
COMMENT ON COLUMN "public"."zjk_item_extreation"."extraction_time" IS '抽取时间';
COMMENT ON COLUMN "public"."zjk_item_extreation"."extraction_user" IS '抽取人';
COMMENT ON COLUMN "public"."zjk_item_extreation"."extraction_sn" IS '抽取流水号';
COMMENT ON COLUMN "public"."zjk_item_extreation"."create_by" IS '创建人';
COMMENT ON COLUMN "public"."zjk_item_extreation"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."zjk_item_extreation"."update_by" IS '更新人';
COMMENT ON COLUMN "public"."zjk_item_extreation"."update_time" IS '更新时间';
COMMENT ON COLUMN "public"."zjk_item_extreation"."tenant_id" IS '租户编号';
COMMENT ON COLUMN "public"."zjk_item_extreation"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."zjk_item_extreation"."revision" IS '乐观锁';
COMMENT ON COLUMN "public"."zjk_item_extreation"."review_id" IS '来源的抽取规则外键';
COMMENT ON COLUMN "public"."zjk_item_extreation"."is_sure" IS '抽取确认';
COMMENT ON TABLE "public"."zjk_item_extreation" IS '抽取记录表';

-- ----------------------------
-- Table structure for zjk_learning_activity
-- ----------------------------
DROP TABLE IF EXISTS "public"."zjk_learning_activity";
CREATE TABLE "public"."zjk_learning_activity" (
  "id" int8 NOT NULL,
  "activity_name" varchar(255) COLLATE "pg_catalog"."default",
  "activity_classify" varchar(255) COLLATE "pg_catalog"."default",
  "activity_start_time" "sys"."date",
  "activity_address" varchar(255) COLLATE "pg_catalog"."default",
  "activity_num" int4,
  "activity_pic" varchar(255) COLLATE "pg_catalog"."default",
  "activity_content" varchar(255) COLLATE "pg_catalog"."default",
  "is_public" varchar(255) COLLATE "pg_catalog"."default",
  "tenant_id" varchar COLLATE "pg_catalog"."default",
  "status" varchar COLLATE "pg_catalog"."default",
  "create_dept" int8,
  "create_by" int8,
  "create_time" "sys"."date",
  "update_by" int8,
  "update_time" "sys"."date",
  "remark" varchar(500) COLLATE "pg_catalog"."default",
  "del_flag" int4 DEFAULT 0,
  "activity_end_time" "sys"."date",
  "activity_status" varchar(255) COLLATE "pg_catalog"."default" DEFAULT 1,
  "takedown_time" "sys"."date",
  "user_id" int8
)
;
COMMENT ON COLUMN "public"."zjk_learning_activity"."id" IS 'id';
COMMENT ON COLUMN "public"."zjk_learning_activity"."activity_name" IS '活动名称';
COMMENT ON COLUMN "public"."zjk_learning_activity"."activity_classify" IS '活动分类';
COMMENT ON COLUMN "public"."zjk_learning_activity"."activity_start_time" IS '活动开始时间';
COMMENT ON COLUMN "public"."zjk_learning_activity"."activity_address" IS '活动地点';
COMMENT ON COLUMN "public"."zjk_learning_activity"."activity_num" IS '活动数量';
COMMENT ON COLUMN "public"."zjk_learning_activity"."activity_pic" IS '封面图';
COMMENT ON COLUMN "public"."zjk_learning_activity"."activity_content" IS '活动内容';
COMMENT ON COLUMN "public"."zjk_learning_activity"."is_public" IS '是否发布';
COMMENT ON COLUMN "public"."zjk_learning_activity"."tenant_id" IS '租户号';
COMMENT ON COLUMN "public"."zjk_learning_activity"."status" IS '状态';
COMMENT ON COLUMN "public"."zjk_learning_activity"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."zjk_learning_activity"."create_by" IS '创建人';
COMMENT ON COLUMN "public"."zjk_learning_activity"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."zjk_learning_activity"."update_by" IS '更新人';
COMMENT ON COLUMN "public"."zjk_learning_activity"."update_time" IS '更新时间';
COMMENT ON COLUMN "public"."zjk_learning_activity"."remark" IS '备注';
COMMENT ON COLUMN "public"."zjk_learning_activity"."del_flag" IS '是否删除';
COMMENT ON COLUMN "public"."zjk_learning_activity"."activity_end_time" IS '活动结束时间';
COMMENT ON COLUMN "public"."zjk_learning_activity"."activity_status" IS '活动状态';
COMMENT ON COLUMN "public"."zjk_learning_activity"."takedown_time" IS '上下架时间';
COMMENT ON COLUMN "public"."zjk_learning_activity"."user_id" IS '用户id';
COMMENT ON TABLE "public"."zjk_learning_activity" IS '学习活动管理';

-- ----------------------------
-- Table structure for zjk_learning_commont
-- ----------------------------
DROP TABLE IF EXISTS "public"."zjk_learning_commont";
CREATE TABLE "public"."zjk_learning_commont" (
  "id" int8 NOT NULL,
  "information_id" int8,
  "reviewer_id" int8,
  "reply_id" int8,
  "comment" varchar(255) COLLATE "pg_catalog"."default",
  "comment_time" varchar(255) COLLATE "pg_catalog"."default",
  "tenant_id" varchar(255) COLLATE "pg_catalog"."default",
  "status" varchar(255) COLLATE "pg_catalog"."default" DEFAULT 2,
  "create_dept" int8,
  "create_by" int8,
  "create_time" "sys"."date",
  "update_by" int8,
  "update_time" "sys"."date",
  "remark" varchar(500) COLLATE "pg_catalog"."default",
  "del_flag" int4 DEFAULT 0,
  "parent_id" int8 DEFAULT 0,
  "takedown_time" "sys"."date"
)
;
COMMENT ON COLUMN "public"."zjk_learning_commont"."id" IS 'id';
COMMENT ON COLUMN "public"."zjk_learning_commont"."information_id" IS '资讯id';
COMMENT ON COLUMN "public"."zjk_learning_commont"."reviewer_id" IS '评论人';
COMMENT ON COLUMN "public"."zjk_learning_commont"."reply_id" IS '被回复人ID';
COMMENT ON COLUMN "public"."zjk_learning_commont"."comment" IS '评论';
COMMENT ON COLUMN "public"."zjk_learning_commont"."comment_time" IS '评论时间';
COMMENT ON COLUMN "public"."zjk_learning_commont"."tenant_id" IS '租户号';
COMMENT ON COLUMN "public"."zjk_learning_commont"."status" IS '状态';
COMMENT ON COLUMN "public"."zjk_learning_commont"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."zjk_learning_commont"."create_by" IS '创建人';
COMMENT ON COLUMN "public"."zjk_learning_commont"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."zjk_learning_commont"."update_by" IS '更新人';
COMMENT ON COLUMN "public"."zjk_learning_commont"."update_time" IS '更新时间';
COMMENT ON COLUMN "public"."zjk_learning_commont"."remark" IS '备注';
COMMENT ON COLUMN "public"."zjk_learning_commont"."del_flag" IS '是否删除';
COMMENT ON COLUMN "public"."zjk_learning_commont"."parent_id" IS '回复评论';
COMMENT ON COLUMN "public"."zjk_learning_commont"."takedown_time" IS '撤销时间';
COMMENT ON TABLE "public"."zjk_learning_commont" IS '评论表';

-- ----------------------------
-- Table structure for zjk_learning_community
-- ----------------------------
DROP TABLE IF EXISTS "public"."zjk_learning_community";
CREATE TABLE "public"."zjk_learning_community" (
  "id" int8 NOT NULL,
  "community_name" varchar(255) COLLATE "pg_catalog"."default",
  "community_introduce" varchar(255) COLLATE "pg_catalog"."default",
  "tenant_id" varchar COLLATE "pg_catalog"."default",
  "status" int4 DEFAULT 2,
  "create_dept" int8,
  "create_by" int8,
  "create_time" "sys"."date",
  "update_by" int8,
  "update_time" "sys"."date",
  "remark" varchar(500) COLLATE "pg_catalog"."default",
  "del_flag" int4 DEFAULT 0
)
;
COMMENT ON COLUMN "public"."zjk_learning_community"."id" IS 'id';
COMMENT ON COLUMN "public"."zjk_learning_community"."community_name" IS '社区名称';
COMMENT ON COLUMN "public"."zjk_learning_community"."community_introduce" IS '社区介绍';
COMMENT ON COLUMN "public"."zjk_learning_community"."tenant_id" IS '租户号';
COMMENT ON COLUMN "public"."zjk_learning_community"."status" IS '状态';
COMMENT ON COLUMN "public"."zjk_learning_community"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."zjk_learning_community"."create_by" IS '创建人';
COMMENT ON COLUMN "public"."zjk_learning_community"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."zjk_learning_community"."update_by" IS '更新人';
COMMENT ON COLUMN "public"."zjk_learning_community"."update_time" IS '更新时间';
COMMENT ON COLUMN "public"."zjk_learning_community"."remark" IS '备注';
COMMENT ON COLUMN "public"."zjk_learning_community"."del_flag" IS '是否删除';
COMMENT ON TABLE "public"."zjk_learning_community" IS '学习社区管理';

-- ----------------------------
-- Table structure for zjk_learning_course
-- ----------------------------
DROP TABLE IF EXISTS "public"."zjk_learning_course";
CREATE TABLE "public"."zjk_learning_course" (
  "id" int8 NOT NULL,
  "course_name" varchar(255) COLLATE "pg_catalog"."default",
  "course_classify" varchar(255) COLLATE "pg_catalog"."default",
  "teaching_type" varchar(255) COLLATE "pg_catalog"."default",
  "course_brief" text COLLATE "pg_catalog"."default",
  "course_pic" varchar(255) COLLATE "pg_catalog"."default",
  "tenant_id" varchar COLLATE "pg_catalog"."default",
  "status" varchar COLLATE "pg_catalog"."default",
  "create_dept" int8,
  "create_by" int8,
  "create_time" "sys"."date",
  "update_by" int8,
  "update_time" "sys"."date",
  "remark" varchar(500) COLLATE "pg_catalog"."default",
  "del_flag" int4 DEFAULT 0,
  "course_attachment" text COLLATE "pg_catalog"."default",
  "takedown_time" "sys"."date",
  "user_id" int8,
  "perform_work_id" varchar COLLATE "pg_catalog"."default"
)
;
COMMENT ON COLUMN "public"."zjk_learning_course"."id" IS 'id';
COMMENT ON COLUMN "public"."zjk_learning_course"."course_name" IS '课程名称';
COMMENT ON COLUMN "public"."zjk_learning_course"."course_classify" IS '课程分类';
COMMENT ON COLUMN "public"."zjk_learning_course"."teaching_type" IS '授课方式';
COMMENT ON COLUMN "public"."zjk_learning_course"."course_brief" IS '课程简介';
COMMENT ON COLUMN "public"."zjk_learning_course"."course_pic" IS '课程图片';
COMMENT ON COLUMN "public"."zjk_learning_course"."tenant_id" IS '租户号';
COMMENT ON COLUMN "public"."zjk_learning_course"."status" IS '状态';
COMMENT ON COLUMN "public"."zjk_learning_course"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."zjk_learning_course"."create_by" IS '创建人';
COMMENT ON COLUMN "public"."zjk_learning_course"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."zjk_learning_course"."update_by" IS '更新人';
COMMENT ON COLUMN "public"."zjk_learning_course"."update_time" IS '更新时间';
COMMENT ON COLUMN "public"."zjk_learning_course"."remark" IS '备注';
COMMENT ON COLUMN "public"."zjk_learning_course"."del_flag" IS '是否删除';
COMMENT ON COLUMN "public"."zjk_learning_course"."course_attachment" IS '附件';
COMMENT ON COLUMN "public"."zjk_learning_course"."takedown_time" IS '上下架时间';
COMMENT ON COLUMN "public"."zjk_learning_course"."user_id" IS '用户id';
COMMENT ON COLUMN "public"."zjk_learning_course"."perform_work_id" IS '学习领域';
COMMENT ON TABLE "public"."zjk_learning_course" IS '学习课程管理';

-- ----------------------------
-- Table structure for zjk_learning_credit_record
-- ----------------------------
DROP TABLE IF EXISTS "public"."zjk_learning_credit_record";
CREATE TABLE "public"."zjk_learning_credit_record" (
  "id" int8 NOT NULL DEFAULT nextval('zjk_learning_record_id_seq'::regclass),
  "tenant_id" varchar(32) COLLATE "pg_catalog"."default",
  "revision" int4,
  "create_by" int8,
  "create_time" timestamp(6),
  "update_by" int8,
  "update_time" timestamp(6),
  "user_id" int8,
  "learning_id" int8,
  "viewing_time" timestamp(6),
  "del_falg" int4 DEFAULT 0,
  "create_dept" varchar(255) COLLATE "pg_catalog"."default"
)
;
COMMENT ON COLUMN "public"."zjk_learning_credit_record"."id" IS '主键';
COMMENT ON COLUMN "public"."zjk_learning_credit_record"."tenant_id" IS '租户号';
COMMENT ON COLUMN "public"."zjk_learning_credit_record"."revision" IS '乐观锁';
COMMENT ON COLUMN "public"."zjk_learning_credit_record"."create_by" IS '创建人';
COMMENT ON COLUMN "public"."zjk_learning_credit_record"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."zjk_learning_credit_record"."update_by" IS '更新人';
COMMENT ON COLUMN "public"."zjk_learning_credit_record"."update_time" IS '更新时间';
COMMENT ON COLUMN "public"."zjk_learning_credit_record"."user_id" IS '用户id';
COMMENT ON COLUMN "public"."zjk_learning_credit_record"."learning_id" IS '资料id';
COMMENT ON COLUMN "public"."zjk_learning_credit_record"."viewing_time" IS '观看时间';
COMMENT ON COLUMN "public"."zjk_learning_credit_record"."del_falg" IS '删除字段';
COMMENT ON COLUMN "public"."zjk_learning_credit_record"."create_dept" IS '创建部门';
COMMENT ON TABLE "public"."zjk_learning_credit_record" IS '信用用户学习记录';

-- ----------------------------
-- Table structure for zjk_learning_information
-- ----------------------------
DROP TABLE IF EXISTS "public"."zjk_learning_information";
CREATE TABLE "public"."zjk_learning_information" (
  "id" int8 NOT NULL,
  "information_classify_id" varchar(255) COLLATE "pg_catalog"."default",
  "information_image" varchar(255) COLLATE "pg_catalog"."default",
  "information_title" varchar(255) COLLATE "pg_catalog"."default",
  "information_detail" varchar(2000) COLLATE "pg_catalog"."default",
  "tenant_id" varchar(255) COLLATE "pg_catalog"."default",
  "status" varchar(255) COLLATE "pg_catalog"."default" DEFAULT 2,
  "create_dept" int8,
  "create_by" int8,
  "create_time" "sys"."date",
  "update_by" int8,
  "update_time" "sys"."date",
  "remark" varchar(500) COLLATE "pg_catalog"."default",
  "del_flag" int4 DEFAULT 0,
  "user_id" int8,
  "takedown_time" "sys"."date",
  "comment_count" int4 DEFAULT 0
)
;
COMMENT ON COLUMN "public"."zjk_learning_information"."id" IS 'id';
COMMENT ON COLUMN "public"."zjk_learning_information"."information_classify_id" IS '资讯类型';
COMMENT ON COLUMN "public"."zjk_learning_information"."information_image" IS '资讯封面';
COMMENT ON COLUMN "public"."zjk_learning_information"."information_title" IS '资讯标题';
COMMENT ON COLUMN "public"."zjk_learning_information"."information_detail" IS '资讯详情';
COMMENT ON COLUMN "public"."zjk_learning_information"."tenant_id" IS '租户号';
COMMENT ON COLUMN "public"."zjk_learning_information"."status" IS '状态';
COMMENT ON COLUMN "public"."zjk_learning_information"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."zjk_learning_information"."create_by" IS '创建人';
COMMENT ON COLUMN "public"."zjk_learning_information"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."zjk_learning_information"."update_by" IS '更新人';
COMMENT ON COLUMN "public"."zjk_learning_information"."update_time" IS '更新时间';
COMMENT ON COLUMN "public"."zjk_learning_information"."remark" IS '备注';
COMMENT ON COLUMN "public"."zjk_learning_information"."del_flag" IS '是否删除';
COMMENT ON COLUMN "public"."zjk_learning_information"."user_id" IS '用户id';
COMMENT ON COLUMN "public"."zjk_learning_information"."takedown_time" IS '撤销时间';
COMMENT ON COLUMN "public"."zjk_learning_information"."comment_count" IS '评论数量';
COMMENT ON TABLE "public"."zjk_learning_information" IS '学习资讯';

-- ----------------------------
-- Table structure for zjk_learning_materials
-- ----------------------------
DROP TABLE IF EXISTS "public"."zjk_learning_materials";
CREATE TABLE "public"."zjk_learning_materials" (
  "id" int8 NOT NULL DEFAULT nextval('zjk_learning_materials_id_seq'::regclass),
  "tenant_id" varchar(32) COLLATE "pg_catalog"."default",
  "revision" int4,
  "create_by" int8,
  "create_time" timestamp(6),
  "update_by" int8,
  "update_time" timestamp(6),
  "materials_id" varchar(255) COLLATE "pg_catalog"."default",
  "materials_count" varchar(255) COLLATE "pg_catalog"."default" DEFAULT 0,
  "status" int2 DEFAULT 1,
  "del_falg" int2 DEFAULT 0,
  "materials_name" varchar(255) COLLATE "pg_catalog"."default",
  "create_dept" varchar(255) COLLATE "pg_catalog"."default",
  "materials_url" varchar(255) COLLATE "pg_catalog"."default"
)
;
COMMENT ON COLUMN "public"."zjk_learning_materials"."id" IS '主键';
COMMENT ON COLUMN "public"."zjk_learning_materials"."tenant_id" IS '租户号';
COMMENT ON COLUMN "public"."zjk_learning_materials"."revision" IS '乐观锁';
COMMENT ON COLUMN "public"."zjk_learning_materials"."create_by" IS '创建人';
COMMENT ON COLUMN "public"."zjk_learning_materials"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."zjk_learning_materials"."update_by" IS '更新人';
COMMENT ON COLUMN "public"."zjk_learning_materials"."update_time" IS '更新时间';
COMMENT ON COLUMN "public"."zjk_learning_materials"."materials_id" IS '资料id';
COMMENT ON COLUMN "public"."zjk_learning_materials"."materials_count" IS '观看次数';
COMMENT ON COLUMN "public"."zjk_learning_materials"."status" IS '状态（0，失效，1.正常）';
COMMENT ON COLUMN "public"."zjk_learning_materials"."del_falg" IS '逻辑删除（1，失效，0.正常）';
COMMENT ON COLUMN "public"."zjk_learning_materials"."materials_name" IS '资料名称';
COMMENT ON COLUMN "public"."zjk_learning_materials"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."zjk_learning_materials"."materials_url" IS '文件地址';
COMMENT ON TABLE "public"."zjk_learning_materials" IS '学习资料';

-- ----------------------------
-- Table structure for zjk_learning_records
-- ----------------------------
DROP TABLE IF EXISTS "public"."zjk_learning_records";
CREATE TABLE "public"."zjk_learning_records" (
  "id" int8 NOT NULL,
  "course_id" int8,
  "user_id" int8,
  "expert_id" int8,
  "rate" time(6),
  "view_duration" time(6),
  "tenant_id" varchar(255) COLLATE "pg_catalog"."default",
  "status" varchar(255) COLLATE "pg_catalog"."default",
  "create_dept" int8,
  "create_by" int8,
  "create_time" timestamp(6),
  "update_by" int8,
  "update_time" timestamp(6),
  "remark" varchar(500) COLLATE "pg_catalog"."default",
  "del_flag" int4 DEFAULT 0,
  "learning_session_length" int8 DEFAULT 0,
  "dept_id" int8
)
;
COMMENT ON COLUMN "public"."zjk_learning_records"."id" IS 'id';
COMMENT ON COLUMN "public"."zjk_learning_records"."course_id" IS '课程id';
COMMENT ON COLUMN "public"."zjk_learning_records"."user_id" IS '用户id';
COMMENT ON COLUMN "public"."zjk_learning_records"."expert_id" IS '专家id';
COMMENT ON COLUMN "public"."zjk_learning_records"."rate" IS '视频时长';
COMMENT ON COLUMN "public"."zjk_learning_records"."view_duration" IS '观看时长';
COMMENT ON COLUMN "public"."zjk_learning_records"."tenant_id" IS '租户号';
COMMENT ON COLUMN "public"."zjk_learning_records"."status" IS '状态';
COMMENT ON COLUMN "public"."zjk_learning_records"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."zjk_learning_records"."create_by" IS '创建人';
COMMENT ON COLUMN "public"."zjk_learning_records"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."zjk_learning_records"."update_by" IS '更新人';
COMMENT ON COLUMN "public"."zjk_learning_records"."update_time" IS '更新时间';
COMMENT ON COLUMN "public"."zjk_learning_records"."remark" IS '备注';
COMMENT ON COLUMN "public"."zjk_learning_records"."del_flag" IS '是否删除';
COMMENT ON COLUMN "public"."zjk_learning_records"."learning_session_length" IS '学习时长';
COMMENT ON COLUMN "public"."zjk_learning_records"."dept_id" IS '部门id';
COMMENT ON TABLE "public"."zjk_learning_records" IS '学习记录';

-- ----------------------------
-- Table structure for zjk_learning_resource
-- ----------------------------
DROP TABLE IF EXISTS "public"."zjk_learning_resource";
CREATE TABLE "public"."zjk_learning_resource" (
  "id" int8 NOT NULL,
  "resource_name" varchar(255) COLLATE "pg_catalog"."default",
  "resource_classify" varchar(255) COLLATE "pg_catalog"."default",
  "resource_type" varchar(255) COLLATE "pg_catalog"."default",
  "resource_brief" varchar(255) COLLATE "pg_catalog"."default",
  "resource_time" "sys"."date",
  "author" varchar(255) COLLATE "pg_catalog"."default",
  "publish_journal" varchar(255) COLLATE "pg_catalog"."default",
  "journal_no" varchar(255) COLLATE "pg_catalog"."default",
  "paper_title" varchar(255) COLLATE "pg_catalog"."default",
  "paper_accessory" text COLLATE "pg_catalog"."default",
  "del_flag" int4 DEFAULT 0,
  "tenant_id" varchar COLLATE "pg_catalog"."default",
  "status" varchar COLLATE "pg_catalog"."default",
  "create_dept" int8,
  "create_by" int8,
  "create_time" "sys"."date",
  "update_by" int8,
  "update_time" "sys"."date",
  "remark" varchar(500) COLLATE "pg_catalog"."default",
  "takedown_time" "sys"."date",
  "user_id" int8
)
;
COMMENT ON COLUMN "public"."zjk_learning_resource"."id" IS 'id';
COMMENT ON COLUMN "public"."zjk_learning_resource"."resource_name" IS '资源编号';
COMMENT ON COLUMN "public"."zjk_learning_resource"."resource_classify" IS '资源分类';
COMMENT ON COLUMN "public"."zjk_learning_resource"."resource_type" IS '资源类型';
COMMENT ON COLUMN "public"."zjk_learning_resource"."resource_brief" IS '资源简介';
COMMENT ON COLUMN "public"."zjk_learning_resource"."resource_time" IS '发布时间';
COMMENT ON COLUMN "public"."zjk_learning_resource"."author" IS '作者';
COMMENT ON COLUMN "public"."zjk_learning_resource"."publish_journal" IS '发表期刊';
COMMENT ON COLUMN "public"."zjk_learning_resource"."journal_no" IS '期刊号';
COMMENT ON COLUMN "public"."zjk_learning_resource"."paper_title" IS '论文标题';
COMMENT ON COLUMN "public"."zjk_learning_resource"."paper_accessory" IS '论文附件';
COMMENT ON COLUMN "public"."zjk_learning_resource"."del_flag" IS '是否删除';
COMMENT ON COLUMN "public"."zjk_learning_resource"."tenant_id" IS '租户号';
COMMENT ON COLUMN "public"."zjk_learning_resource"."status" IS '状态';
COMMENT ON COLUMN "public"."zjk_learning_resource"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."zjk_learning_resource"."create_by" IS '创建人';
COMMENT ON COLUMN "public"."zjk_learning_resource"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."zjk_learning_resource"."update_by" IS '更新人';
COMMENT ON COLUMN "public"."zjk_learning_resource"."update_time" IS '更新时间';
COMMENT ON COLUMN "public"."zjk_learning_resource"."remark" IS '备注';
COMMENT ON COLUMN "public"."zjk_learning_resource"."takedown_time" IS '上下架时间';
COMMENT ON COLUMN "public"."zjk_learning_resource"."user_id" IS '用户id';
COMMENT ON TABLE "public"."zjk_learning_resource" IS '学习资源管理';

-- ----------------------------
-- Table structure for zjk_learning_tool
-- ----------------------------
DROP TABLE IF EXISTS "public"."zjk_learning_tool";
CREATE TABLE "public"."zjk_learning_tool" (
  "id" int8 NOT NULL,
  "name" varchar(255) COLLATE "pg_catalog"."default",
  "attachment" varchar(900) COLLATE "pg_catalog"."default",
  "tenant_id" varchar(255) COLLATE "pg_catalog"."default",
  "status" varchar(255) COLLATE "pg_catalog"."default",
  "create_dept" int8,
  "create_by" int8,
  "create_time" "sys"."date",
  "update_by" int8,
  "update_time" "sys"."date",
  "remark" varchar(500) COLLATE "pg_catalog"."default",
  "del_flag" int4 DEFAULT 0,
  "user_id" int8,
  "takedown_time" "sys"."date"
)
;
COMMENT ON COLUMN "public"."zjk_learning_tool"."id" IS 'id';
COMMENT ON COLUMN "public"."zjk_learning_tool"."name" IS '工具名称';
COMMENT ON COLUMN "public"."zjk_learning_tool"."attachment" IS '附件';
COMMENT ON COLUMN "public"."zjk_learning_tool"."tenant_id" IS '租户号';
COMMENT ON COLUMN "public"."zjk_learning_tool"."status" IS '状态';
COMMENT ON COLUMN "public"."zjk_learning_tool"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."zjk_learning_tool"."create_by" IS '创建人';
COMMENT ON COLUMN "public"."zjk_learning_tool"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."zjk_learning_tool"."update_by" IS '更新人';
COMMENT ON COLUMN "public"."zjk_learning_tool"."update_time" IS '更新时间';
COMMENT ON COLUMN "public"."zjk_learning_tool"."remark" IS '备注';
COMMENT ON COLUMN "public"."zjk_learning_tool"."del_flag" IS '是否删除';
COMMENT ON COLUMN "public"."zjk_learning_tool"."user_id" IS '用户id';
COMMENT ON COLUMN "public"."zjk_learning_tool"."takedown_time" IS '状态操作时间';
COMMENT ON TABLE "public"."zjk_learning_tool" IS '学习工具管理';

-- ----------------------------
-- Table structure for zjk_leave
-- ----------------------------
DROP TABLE IF EXISTS "public"."zjk_leave";
CREATE TABLE "public"."zjk_leave" (
  "gid" varchar(32) COLLATE "pg_catalog"."default" NOT NULL,
  "leave_type" varchar(255) COLLATE "pg_catalog"."default" DEFAULT 1,
  "start_date" timestamp(6),
  "end_date" timestamp(6),
  "leave_days" int4,
  "leave_reason" varchar(255) COLLATE "pg_catalog"."default",
  "status" varchar(20) COLLATE "pg_catalog"."default" DEFAULT 0,
  "approval_user" varchar(255) COLLATE "pg_catalog"."default",
  "tenant_id" varchar(20) COLLATE "pg_catalog"."default",
  "approval_msg" varchar(30000) COLLATE "pg_catalog"."default",
  "create_by" int8,
  "create_time" timestamp(6),
  "update_by" int8,
  "update_time" timestamp(6),
  "create_dept" int8,
  "leave_resource" int4 DEFAULT 0
)
;
COMMENT ON COLUMN "public"."zjk_leave"."gid" IS '主键';
COMMENT ON COLUMN "public"."zjk_leave"."leave_type" IS '请假类型';
COMMENT ON COLUMN "public"."zjk_leave"."start_date" IS '开始时间';
COMMENT ON COLUMN "public"."zjk_leave"."end_date" IS '结束时间';
COMMENT ON COLUMN "public"."zjk_leave"."leave_days" IS '请假天数';
COMMENT ON COLUMN "public"."zjk_leave"."leave_reason" IS '请假原因';
COMMENT ON COLUMN "public"."zjk_leave"."status" IS '审批状态';
COMMENT ON COLUMN "public"."zjk_leave"."approval_user" IS '审批人';
COMMENT ON COLUMN "public"."zjk_leave"."tenant_id" IS '租户编码';
COMMENT ON COLUMN "public"."zjk_leave"."approval_msg" IS '审批备注';
COMMENT ON COLUMN "public"."zjk_leave"."create_by" IS '创建者';
COMMENT ON COLUMN "public"."zjk_leave"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."zjk_leave"."update_by" IS '更新者';
COMMENT ON COLUMN "public"."zjk_leave"."update_time" IS '更新时间';
COMMENT ON COLUMN "public"."zjk_leave"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."zjk_leave"."leave_resource" IS '0:自己请假；1:管理员替代请假';
COMMENT ON TABLE "public"."zjk_leave" IS '请假申请表';

-- ----------------------------
-- Table structure for zjk_leave_rule
-- ----------------------------
DROP TABLE IF EXISTS "public"."zjk_leave_rule";
CREATE TABLE "public"."zjk_leave_rule" (
  "GID" varchar(32) COLLATE "pg_catalog"."default",
  "leave_day" int4,
  "before_day" varchar(255) COLLATE "pg_catalog"."default",
  "pro_before_hour" varchar(255) COLLATE "pg_catalog"."default",
  "tenant_id" varchar(255) COLLATE "pg_catalog"."default",
  "CREATE_BY" int8,
  "CREATE_TIME" timestamp(6),
  "UPDATE_BY" int8,
  "UPDATE_TIME" timestamp(6),
  "create_dept" int8
)
;
COMMENT ON COLUMN "public"."zjk_leave_rule"."GID" IS '租户号';
COMMENT ON COLUMN "public"."zjk_leave_rule"."leave_day" IS '请假时长';
COMMENT ON COLUMN "public"."zjk_leave_rule"."before_day" IS '请假提前天数';
COMMENT ON COLUMN "public"."zjk_leave_rule"."pro_before_hour" IS '项目评审前提前小时数';
COMMENT ON COLUMN "public"."zjk_leave_rule"."tenant_id" IS '租户id';
COMMENT ON COLUMN "public"."zjk_leave_rule"."CREATE_BY" IS '创建人';
COMMENT ON COLUMN "public"."zjk_leave_rule"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "public"."zjk_leave_rule"."UPDATE_BY" IS '更新人';
COMMENT ON COLUMN "public"."zjk_leave_rule"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "public"."zjk_leave_rule"."create_dept" IS '创建部门';
COMMENT ON TABLE "public"."zjk_leave_rule" IS '请假规则';

-- ----------------------------
-- Table structure for zjk_money_analyse_statement
-- ----------------------------
DROP TABLE IF EXISTS "public"."zjk_money_analyse_statement";
CREATE TABLE "public"."zjk_money_analyse_statement" (
  "id" int8 NOT NULL,
  "expert_type" varchar(255) COLLATE "pg_catalog"."default",
  "sum_fee" numeric,
  "proportion" numeric,
  "tendency" numeric DEFAULT 100,
  "tenant_id" varchar(255) COLLATE "pg_catalog"."default",
  "status" varchar(255) COLLATE "pg_catalog"."default",
  "create_dept" int8,
  "create_by" int8,
  "create_time" timestamp(6),
  "update_by" int8,
  "update_time" timestamp(6),
  "remark" varchar(500) COLLATE "pg_catalog"."default",
  "del_flag" int4 DEFAULT 0,
  "statement_id" int8
)
;
COMMENT ON COLUMN "public"."zjk_money_analyse_statement"."id" IS 'id';
COMMENT ON COLUMN "public"."zjk_money_analyse_statement"."expert_type" IS '专家类型;专家类型';
COMMENT ON COLUMN "public"."zjk_money_analyse_statement"."sum_fee" IS '总费用;总费用';
COMMENT ON COLUMN "public"."zjk_money_analyse_statement"."proportion" IS '占比;占比';
COMMENT ON COLUMN "public"."zjk_money_analyse_statement"."tendency" IS '变化趋势;变化趋势';
COMMENT ON COLUMN "public"."zjk_money_analyse_statement"."tenant_id" IS '租户号';
COMMENT ON COLUMN "public"."zjk_money_analyse_statement"."status" IS '状态';
COMMENT ON COLUMN "public"."zjk_money_analyse_statement"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."zjk_money_analyse_statement"."create_by" IS '创建人';
COMMENT ON COLUMN "public"."zjk_money_analyse_statement"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."zjk_money_analyse_statement"."update_by" IS '更新人';
COMMENT ON COLUMN "public"."zjk_money_analyse_statement"."update_time" IS '更新时间';
COMMENT ON COLUMN "public"."zjk_money_analyse_statement"."remark" IS '备注';
COMMENT ON COLUMN "public"."zjk_money_analyse_statement"."del_flag" IS '是否删除';
COMMENT ON COLUMN "public"."zjk_money_analyse_statement"."statement_id" IS '报表id';
COMMENT ON TABLE "public"."zjk_money_analyse_statement" IS '报表分析';

-- ----------------------------
-- Table structure for zjk_money_collect_statement
-- ----------------------------
DROP TABLE IF EXISTS "public"."zjk_money_collect_statement";
CREATE TABLE "public"."zjk_money_collect_statement" (
  "id" int8 NOT NULL,
  "sum_fee" varchar(255) COLLATE "pg_catalog"."default",
  "no_pay_money" numeric(6,2),
  "pay_money" numeric(6,2),
  "expert_count" int4,
  "money_cycle" varchar(255) COLLATE "pg_catalog"."default",
  "tenant_id" varchar(255) COLLATE "pg_catalog"."default",
  "status" varchar(255) COLLATE "pg_catalog"."default",
  "create_dept" int8,
  "create_by" int8,
  "create_time" timestamp(6),
  "update_by" int8,
  "update_time" timestamp(6),
  "remark" varchar(500) COLLATE "pg_catalog"."default",
  "del_flag" int4 DEFAULT 0,
  "statement_id" int8
)
;
COMMENT ON COLUMN "public"."zjk_money_collect_statement"."id" IS 'id';
COMMENT ON COLUMN "public"."zjk_money_collect_statement"."sum_fee" IS '支付总金额;支付总金额';
COMMENT ON COLUMN "public"."zjk_money_collect_statement"."no_pay_money" IS '未支付金额;未支付金额';
COMMENT ON COLUMN "public"."zjk_money_collect_statement"."pay_money" IS '支付金额;支付金额';
COMMENT ON COLUMN "public"."zjk_money_collect_statement"."expert_count" IS '专家人数;专家人数';
COMMENT ON COLUMN "public"."zjk_money_collect_statement"."money_cycle" IS '结算周期;结算周期';
COMMENT ON COLUMN "public"."zjk_money_collect_statement"."tenant_id" IS '租户号';
COMMENT ON COLUMN "public"."zjk_money_collect_statement"."status" IS '状态';
COMMENT ON COLUMN "public"."zjk_money_collect_statement"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."zjk_money_collect_statement"."create_by" IS '创建人';
COMMENT ON COLUMN "public"."zjk_money_collect_statement"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."zjk_money_collect_statement"."update_by" IS '更新人';
COMMENT ON COLUMN "public"."zjk_money_collect_statement"."update_time" IS '更新时间';
COMMENT ON COLUMN "public"."zjk_money_collect_statement"."remark" IS '备注';
COMMENT ON COLUMN "public"."zjk_money_collect_statement"."del_flag" IS '是否删除';
COMMENT ON COLUMN "public"."zjk_money_collect_statement"."statement_id" IS '报表id';
COMMENT ON TABLE "public"."zjk_money_collect_statement" IS '报表统计';

-- ----------------------------
-- Table structure for zjk_money_expert_statement
-- ----------------------------
DROP TABLE IF EXISTS "public"."zjk_money_expert_statement";
CREATE TABLE "public"."zjk_money_expert_statement" (
  "id" int8 NOT NULL,
  "expert_name" varchar(255) COLLATE "pg_catalog"."default",
  "expert_type" varchar(255) COLLATE "pg_catalog"."default",
  "sum_fee" numeric,
  "no_pay_fee" numeric,
  "pay_fee" numeric,
  "money_cycle" varchar(255) COLLATE "pg_catalog"."default",
  "tenant_id" int4 NOT NULL DEFAULT nextval('zjk_money_expert_statement_tenant_id_seq'::regclass),
  "status" varchar(255) COLLATE "pg_catalog"."default",
  "create_dept" int8,
  "create_by" int8,
  "create_time" timestamp(6),
  "update_by" int8,
  "update_time" timestamp(6),
  "remark" varchar(500) COLLATE "pg_catalog"."default",
  "del_flag" int4 DEFAULT 0,
  "statement_id" int8
)
;
COMMENT ON COLUMN "public"."zjk_money_expert_statement"."id" IS 'id';
COMMENT ON COLUMN "public"."zjk_money_expert_statement"."expert_name" IS '专家姓名;专家姓名';
COMMENT ON COLUMN "public"."zjk_money_expert_statement"."expert_type" IS '专家类型;专家类型';
COMMENT ON COLUMN "public"."zjk_money_expert_statement"."sum_fee" IS '总费用;总费用';
COMMENT ON COLUMN "public"."zjk_money_expert_statement"."no_pay_fee" IS '未支付费用;未支付费用';
COMMENT ON COLUMN "public"."zjk_money_expert_statement"."pay_fee" IS '已支付费用;已支付费用';
COMMENT ON COLUMN "public"."zjk_money_expert_statement"."money_cycle" IS '结算周期;结算周期';
COMMENT ON COLUMN "public"."zjk_money_expert_statement"."tenant_id" IS '租户号';
COMMENT ON COLUMN "public"."zjk_money_expert_statement"."status" IS '状态';
COMMENT ON COLUMN "public"."zjk_money_expert_statement"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."zjk_money_expert_statement"."create_by" IS '创建人';
COMMENT ON COLUMN "public"."zjk_money_expert_statement"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."zjk_money_expert_statement"."update_by" IS '更新人';
COMMENT ON COLUMN "public"."zjk_money_expert_statement"."update_time" IS '更新时间';
COMMENT ON COLUMN "public"."zjk_money_expert_statement"."remark" IS '备注';
COMMENT ON COLUMN "public"."zjk_money_expert_statement"."del_flag" IS '是否删除';
COMMENT ON COLUMN "public"."zjk_money_expert_statement"."statement_id" IS '报表id';
COMMENT ON TABLE "public"."zjk_money_expert_statement" IS '专家费用报表';

-- ----------------------------
-- Table structure for zjk_money_statement
-- ----------------------------
DROP TABLE IF EXISTS "public"."zjk_money_statement";
CREATE TABLE "public"."zjk_money_statement" (
  "id" int8 NOT NULL,
  "statement_sn" varchar(500) COLLATE "pg_catalog"."default",
  "type" varchar(255) COLLATE "pg_catalog"."default",
  "period" varchar(255) COLLATE "pg_catalog"."default",
  "scope_start_time" "sys"."date",
  "tenant_id" varchar(255) COLLATE "pg_catalog"."default",
  "status" varchar(255) COLLATE "pg_catalog"."default",
  "create_dept" int8,
  "create_by" int8,
  "create_time" timestamp(6),
  "update_by" int8,
  "update_time" timestamp(6),
  "remark" varchar(500) COLLATE "pg_catalog"."default",
  "del_flag" int4 DEFAULT 0,
  "scope_end_time" "sys"."date",
  "name_date" "sys"."date"
)
;
COMMENT ON COLUMN "public"."zjk_money_statement"."id" IS 'id';
COMMENT ON COLUMN "public"."zjk_money_statement"."statement_sn" IS '编号;编号';
COMMENT ON COLUMN "public"."zjk_money_statement"."type" IS '类型(年报，月报);类型(年报，月报)';
COMMENT ON COLUMN "public"."zjk_money_statement"."period" IS '周期（每年，每月）;周期（每年，每月）';
COMMENT ON COLUMN "public"."zjk_money_statement"."scope_start_time" IS '时间范围开始';
COMMENT ON COLUMN "public"."zjk_money_statement"."tenant_id" IS '租户号';
COMMENT ON COLUMN "public"."zjk_money_statement"."status" IS '状态';
COMMENT ON COLUMN "public"."zjk_money_statement"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."zjk_money_statement"."create_by" IS '创建人';
COMMENT ON COLUMN "public"."zjk_money_statement"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."zjk_money_statement"."update_by" IS '更新人';
COMMENT ON COLUMN "public"."zjk_money_statement"."update_time" IS '更新时间';
COMMENT ON COLUMN "public"."zjk_money_statement"."remark" IS '备注';
COMMENT ON COLUMN "public"."zjk_money_statement"."del_flag" IS '是否删除';
COMMENT ON COLUMN "public"."zjk_money_statement"."scope_end_time" IS '时间范围结束';
COMMENT ON COLUMN "public"."zjk_money_statement"."name_date" IS '报表时间';
COMMENT ON TABLE "public"."zjk_money_statement" IS '费用报表';

-- ----------------------------
-- Table structure for zjk_point
-- ----------------------------
DROP TABLE IF EXISTS "public"."zjk_point";
CREATE TABLE "public"."zjk_point" (
  "ID" int8 NOT NULL GENERATED ALWAYS AS IDENTITY (
INCREMENT 1
MINVALUE  1
MAXVALUE 999999999
START 1
CACHE 1
CYCLE
),
  "points" numeric(8,2),
  "rule_id" int8,
  "create_dept" varchar(255) COLLATE "pg_catalog"."default",
  "tenant_id" varchar(8) COLLATE "pg_catalog"."default",
  "CREATE_BY" int8,
  "CREATE_TIME" timestamp(0),
  "UPDATE_BY" int8,
  "UPDATE_TIME" timestamp(0),
  "expert_id" int8,
  "user_id" int8,
  "evaluate_id" varchar(32) COLLATE "pg_catalog"."default",
  "hmac" varchar(128) COLLATE "pg_catalog"."default"
)
;
COMMENT ON COLUMN "public"."zjk_point"."ID" IS '租户号';
COMMENT ON COLUMN "public"."zjk_point"."points" IS '积分数值';
COMMENT ON COLUMN "public"."zjk_point"."rule_id" IS '积分事由外键';
COMMENT ON COLUMN "public"."zjk_point"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."zjk_point"."tenant_id" IS '租户id';
COMMENT ON COLUMN "public"."zjk_point"."CREATE_BY" IS '创建人';
COMMENT ON COLUMN "public"."zjk_point"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "public"."zjk_point"."UPDATE_BY" IS '更新人';
COMMENT ON COLUMN "public"."zjk_point"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "public"."zjk_point"."expert_id" IS '专家id';
COMMENT ON COLUMN "public"."zjk_point"."user_id" IS '用户id';
COMMENT ON COLUMN "public"."zjk_point"."evaluate_id" IS '来源的评价id';
COMMENT ON TABLE "public"."zjk_point" IS '积分记录';

-- ----------------------------
-- Table structure for zjk_point_reward
-- ----------------------------
DROP TABLE IF EXISTS "public"."zjk_point_reward";
CREATE TABLE "public"."zjk_point_reward" (
  "ID" varchar(32) COLLATE "pg_catalog"."default",
  "reward_name" varchar(255) COLLATE "pg_catalog"."default",
  "reward_type" int4,
  "reward_content" varchar(255) COLLATE "pg_catalog"."default",
  "reward_obj" int4,
  "effect_flag" int4,
  "effect_standard" numeric(6,2),
  "reward_until" timestamp(0),
  "is_forever" int2,
  "create_dept" varchar(255) COLLATE "pg_catalog"."default",
  "tenant_id" varchar(8) COLLATE "pg_catalog"."default",
  "status" int4,
  "CREATE_BY" int8,
  "CREATE_TIME" timestamp(0),
  "UPDATE_BY" int8,
  "UPDATE_TIME" timestamp(0)
)
;
COMMENT ON COLUMN "public"."zjk_point_reward"."ID" IS '租户号';
COMMENT ON COLUMN "public"."zjk_point_reward"."reward_name" IS '积分奖励名称';
COMMENT ON COLUMN "public"."zjk_point_reward"."reward_type" IS '激励类型;字典值reward_type';
COMMENT ON COLUMN "public"."zjk_point_reward"."reward_content" IS '激励内容';
COMMENT ON COLUMN "public"."zjk_point_reward"."reward_obj" IS '激励标的;字典值 积分';
COMMENT ON COLUMN "public"."zjk_point_reward"."effect_flag" IS '生效符号;><=';
COMMENT ON COLUMN "public"."zjk_point_reward"."effect_standard" IS '生效标准;临界分值';
COMMENT ON COLUMN "public"."zjk_point_reward"."reward_until" IS '激励截至时间';
COMMENT ON COLUMN "public"."zjk_point_reward"."is_forever" IS '是否永久;1：永久；0不永久';
COMMENT ON COLUMN "public"."zjk_point_reward"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."zjk_point_reward"."tenant_id" IS '租户id';
COMMENT ON COLUMN "public"."zjk_point_reward"."status" IS '启用标识';
COMMENT ON COLUMN "public"."zjk_point_reward"."CREATE_BY" IS '创建人';
COMMENT ON COLUMN "public"."zjk_point_reward"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "public"."zjk_point_reward"."UPDATE_BY" IS '更新人';
COMMENT ON COLUMN "public"."zjk_point_reward"."UPDATE_TIME" IS '更新时间';
COMMENT ON TABLE "public"."zjk_point_reward" IS '积分奖励';

-- ----------------------------
-- Table structure for zjk_point_rule
-- ----------------------------
DROP TABLE IF EXISTS "public"."zjk_point_rule";
CREATE TABLE "public"."zjk_point_rule" (
  "ID" int8 NOT NULL,
  "rule_name" varchar(255) COLLATE "pg_catalog"."default",
  "expire_time" timestamp(0),
  "is_forever" int8,
  "create_dept" varchar(255) COLLATE "pg_catalog"."default",
  "tenant_id" varchar(8) COLLATE "pg_catalog"."default",
  "status" int4,
  "CREATE_BY" int8,
  "CREATE_TIME" timestamp(0),
  "UPDATE_BY" int8,
  "UPDATE_TIME" timestamp(0),
  "each_score" numeric(6,2),
  "rule_key" varchar COLLATE "pg_catalog"."default",
  "point_reason" varchar(255) COLLATE "pg_catalog"."default"
)
;
COMMENT ON COLUMN "public"."zjk_point_rule"."ID" IS '租户号';
COMMENT ON COLUMN "public"."zjk_point_rule"."rule_name" IS '规则名称';
COMMENT ON COLUMN "public"."zjk_point_rule"."expire_time" IS '到期时间';
COMMENT ON COLUMN "public"."zjk_point_rule"."is_forever" IS '是否永久';
COMMENT ON COLUMN "public"."zjk_point_rule"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."zjk_point_rule"."tenant_id" IS '租户id';
COMMENT ON COLUMN "public"."zjk_point_rule"."status" IS '启用标识';
COMMENT ON COLUMN "public"."zjk_point_rule"."CREATE_BY" IS '创建人';
COMMENT ON COLUMN "public"."zjk_point_rule"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "public"."zjk_point_rule"."UPDATE_BY" IS '更新人';
COMMENT ON COLUMN "public"."zjk_point_rule"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "public"."zjk_point_rule"."each_score" IS '每次得分';
COMMENT ON COLUMN "public"."zjk_point_rule"."rule_key" IS '积分规则code';
COMMENT ON COLUMN "public"."zjk_point_rule"."point_reason" IS '积分获得事由';
COMMENT ON TABLE "public"."zjk_point_rule" IS '积分规则表';

-- ----------------------------
-- Table structure for zjk_point_user
-- ----------------------------
DROP TABLE IF EXISTS "public"."zjk_point_user";
CREATE TABLE "public"."zjk_point_user" (
  "ID" varchar(32) COLLATE "pg_catalog"."default" NOT NULL,
  "user_id" int8,
  "expert_id" int8,
  "reward_id" varchar(32) COLLATE "pg_catalog"."default",
  "reward_title" varchar(255) COLLATE "pg_catalog"."default",
  "point_count" numeric(6,2),
  "check_status" int2 DEFAULT 0,
  "create_dept" varchar(255) COLLATE "pg_catalog"."default",
  "tenant_id" varchar(8) COLLATE "pg_catalog"."default",
  "CREATE_BY" int8,
  "CREATE_TIME" timestamp(0),
  "UPDATE_BY" int8,
  "UPDATE_TIME" timestamp(0),
  "remark" varchar COLLATE "pg_catalog"."default",
  "check_time" timestamp(6),
  "change_time" timestamp(6) DEFAULT CURRENT_TIMESTAMP
)
;
COMMENT ON COLUMN "public"."zjk_point_user"."ID" IS '租户号';
COMMENT ON COLUMN "public"."zjk_point_user"."user_id" IS '用户id';
COMMENT ON COLUMN "public"."zjk_point_user"."expert_id" IS '专家id';
COMMENT ON COLUMN "public"."zjk_point_user"."reward_id" IS '奖励id';
COMMENT ON COLUMN "public"."zjk_point_user"."reward_title" IS '奖励内容';
COMMENT ON COLUMN "public"."zjk_point_user"."point_count" IS '总积分';
COMMENT ON COLUMN "public"."zjk_point_user"."check_status" IS '审核状态;1：冻结；2：复核通过;3：待复核；;0初始默认状态';
COMMENT ON COLUMN "public"."zjk_point_user"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."zjk_point_user"."tenant_id" IS '租户id';
COMMENT ON COLUMN "public"."zjk_point_user"."CREATE_BY" IS '创建人';
COMMENT ON COLUMN "public"."zjk_point_user"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "public"."zjk_point_user"."UPDATE_BY" IS '更新人';
COMMENT ON COLUMN "public"."zjk_point_user"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "public"."zjk_point_user"."remark" IS '复核备注';
COMMENT ON COLUMN "public"."zjk_point_user"."check_time" IS '复核时间';
COMMENT ON COLUMN "public"."zjk_point_user"."change_time" IS '积分变动时间';
COMMENT ON TABLE "public"."zjk_point_user" IS '积分用户';

-- ----------------------------
-- Table structure for zjk_problem
-- ----------------------------
DROP TABLE IF EXISTS "public"."zjk_problem";
CREATE TABLE "public"."zjk_problem" (
  "id" int8 NOT NULL,
  "problem_title" varchar(255) COLLATE "pg_catalog"."default",
  "problem" varchar(255) COLLATE "pg_catalog"."default",
  "reply" varchar(255) COLLATE "pg_catalog"."default",
  "user_id" int8,
  "reply_id" int8,
  "problem_time" "sys"."date",
  "reply_time" "sys"."date",
  "tenant_id" varchar(255) COLLATE "pg_catalog"."default",
  "status" varchar(255) COLLATE "pg_catalog"."default",
  "create_dept" int8,
  "create_by" int8,
  "create_time" "sys"."date",
  "update_by" int8,
  "update_time" "sys"."date",
  "remark" varchar(500) COLLATE "pg_catalog"."default",
  "del_flag" int4 DEFAULT 0
)
;
COMMENT ON COLUMN "public"."zjk_problem"."id" IS 'id';
COMMENT ON COLUMN "public"."zjk_problem"."problem_title" IS '问题标题';
COMMENT ON COLUMN "public"."zjk_problem"."problem" IS '问题';
COMMENT ON COLUMN "public"."zjk_problem"."reply" IS '回复内容';
COMMENT ON COLUMN "public"."zjk_problem"."user_id" IS '提问人';
COMMENT ON COLUMN "public"."zjk_problem"."reply_id" IS '回复人';
COMMENT ON COLUMN "public"."zjk_problem"."problem_time" IS '提问时间';
COMMENT ON COLUMN "public"."zjk_problem"."reply_time" IS '答复时间';
COMMENT ON COLUMN "public"."zjk_problem"."tenant_id" IS '租户号';
COMMENT ON COLUMN "public"."zjk_problem"."status" IS '状态';
COMMENT ON COLUMN "public"."zjk_problem"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."zjk_problem"."create_by" IS '创建人';
COMMENT ON COLUMN "public"."zjk_problem"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."zjk_problem"."update_by" IS '更新人';
COMMENT ON COLUMN "public"."zjk_problem"."update_time" IS '更新时间';
COMMENT ON COLUMN "public"."zjk_problem"."remark" IS '备注';
COMMENT ON COLUMN "public"."zjk_problem"."del_flag" IS '是否删除';
COMMENT ON TABLE "public"."zjk_problem" IS '问题 管理';

-- ----------------------------
-- Table structure for zjk_product
-- ----------------------------
DROP TABLE IF EXISTS "public"."zjk_product";
CREATE TABLE "public"."zjk_product" (
  "id" int8 NOT NULL,
  "product_sn" varchar(255) COLLATE "pg_catalog"."default",
  "product_name" varchar(255) COLLATE "pg_catalog"."default",
  "product_type" varchar(255) COLLATE "pg_catalog"."default" NOT NULL,
  "product_scale" varchar(255) COLLATE "pg_catalog"."default",
  "product_unit" varchar(255) COLLATE "pg_catalog"."default",
  "unit_by" varchar(255) COLLATE "pg_catalog"."default",
  "unit_concat" varchar(255) COLLATE "pg_catalog"."default",
  "product_brief" varchar(255) COLLATE "pg_catalog"."default",
  "product_data_url" text COLLATE "pg_catalog"."default",
  "tenant_id" varchar COLLATE "pg_catalog"."default",
  "status" int4,
  "create_dept" int8,
  "create_by" int8,
  "create_time" "sys"."date",
  "update_by" int8,
  "update_time" "sys"."date",
  "del_flag" int4 DEFAULT 0,
  "remark" varchar(500) COLLATE "pg_catalog"."default",
  "user_id" int8,
  "hmac" varchar(128) COLLATE "pg_catalog"."default"
)
;
COMMENT ON COLUMN "public"."zjk_product"."id" IS 'id';
COMMENT ON COLUMN "public"."zjk_product"."product_sn" IS '项目编号';
COMMENT ON COLUMN "public"."zjk_product"."product_name" IS '项目名称';
COMMENT ON COLUMN "public"."zjk_product"."product_type" IS '项目类型';
COMMENT ON COLUMN "public"."zjk_product"."product_scale" IS '项目规模';
COMMENT ON COLUMN "public"."zjk_product"."product_unit" IS '项目单位名称';
COMMENT ON COLUMN "public"."zjk_product"."unit_by" IS '单位负责人';
COMMENT ON COLUMN "public"."zjk_product"."unit_concat" IS '单位负责人联系方式';
COMMENT ON COLUMN "public"."zjk_product"."product_brief" IS '项目简介';
COMMENT ON COLUMN "public"."zjk_product"."product_data_url" IS '项目数据地址';
COMMENT ON COLUMN "public"."zjk_product"."tenant_id" IS '租户号';
COMMENT ON COLUMN "public"."zjk_product"."status" IS '状态';
COMMENT ON COLUMN "public"."zjk_product"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."zjk_product"."create_by" IS '创建人';
COMMENT ON COLUMN "public"."zjk_product"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."zjk_product"."update_by" IS '更新人';
COMMENT ON COLUMN "public"."zjk_product"."update_time" IS '更新时间';
COMMENT ON COLUMN "public"."zjk_product"."del_flag" IS '逻辑删除';
COMMENT ON COLUMN "public"."zjk_product"."remark" IS '备注';
COMMENT ON COLUMN "public"."zjk_product"."user_id" IS '用户id';

-- ----------------------------
-- Table structure for zjk_product_reviewsn
-- ----------------------------
DROP TABLE IF EXISTS "public"."zjk_product_reviewsn";
CREATE TABLE "public"."zjk_product_reviewsn" (
  "id" int8 NOT NULL,
  "product_id" int8,
  "review_sn" varchar(255) COLLATE "pg_catalog"."default",
  "tenant_id" varchar(255) COLLATE "pg_catalog"."default",
  "status" varchar(255) COLLATE "pg_catalog"."default",
  "create_dept" int8,
  "create_by" int8,
  "create_time" timestamp(6),
  "update_by" int8,
  "update_time" timestamp(6),
  "remark" varchar(500) COLLATE "pg_catalog"."default",
  "del_flag" int4 DEFAULT 0
)
;
COMMENT ON COLUMN "public"."zjk_product_reviewsn"."id" IS 'id';
COMMENT ON COLUMN "public"."zjk_product_reviewsn"."product_id" IS '项目id';
COMMENT ON COLUMN "public"."zjk_product_reviewsn"."review_sn" IS '项目阶段';
COMMENT ON COLUMN "public"."zjk_product_reviewsn"."tenant_id" IS '租户号';
COMMENT ON COLUMN "public"."zjk_product_reviewsn"."status" IS '状态';
COMMENT ON COLUMN "public"."zjk_product_reviewsn"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."zjk_product_reviewsn"."create_by" IS '创建人';
COMMENT ON COLUMN "public"."zjk_product_reviewsn"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."zjk_product_reviewsn"."update_by" IS '更新人';
COMMENT ON COLUMN "public"."zjk_product_reviewsn"."update_time" IS '更新时间';
COMMENT ON COLUMN "public"."zjk_product_reviewsn"."remark" IS '备注';
COMMENT ON COLUMN "public"."zjk_product_reviewsn"."del_flag" IS '是否删除';
COMMENT ON TABLE "public"."zjk_product_reviewsn" IS '项目阶段 文档论文新增表';

-- ----------------------------
-- Table structure for zjk_product_summarize
-- ----------------------------
DROP TABLE IF EXISTS "public"."zjk_product_summarize";
CREATE TABLE "public"."zjk_product_summarize" (
  "id" int8 NOT NULL,
  "review_id" int8,
  "product_summarize_name" varchar(255) COLLATE "pg_catalog"."default",
  "product_summarize_type" varchar(255) COLLATE "pg_catalog"."default",
  "product_general" varchar(255) COLLATE "pg_catalog"."default",
  "review_scope" varchar(255) COLLATE "pg_catalog"."default",
  "review_conclusion" varchar(255) COLLATE "pg_catalog"."default",
  "feedback" varchar(255) COLLATE "pg_catalog"."default",
  "subsequent" varchar(255) COLLATE "pg_catalog"."default",
  "attachment" text COLLATE "pg_catalog"."default",
  "tenant_id" varchar COLLATE "pg_catalog"."default",
  "expert_ids" varchar(255) COLLATE "pg_catalog"."default",
  "status" varchar(255) COLLATE "pg_catalog"."default",
  "create_dept" int8,
  "create_by" int8,
  "create_time" "sys"."date",
  "update_by" int8,
  "update_time" "sys"."date",
  "remark" varchar(500) COLLATE "pg_catalog"."default",
  "del_flag" int4 DEFAULT 0,
  "audit_status" varchar(255) COLLATE "pg_catalog"."default",
  "audit_remark" varchar(255) COLLATE "pg_catalog"."default",
  "audit_by" int8,
  "audit_time" timestamp(6),
  "product_id" int8,
  "review_sn" varchar(255) COLLATE "pg_catalog"."default",
  "is_evaluate" int2 DEFAULT 0
)
;
COMMENT ON COLUMN "public"."zjk_product_summarize"."id" IS 'id';
COMMENT ON COLUMN "public"."zjk_product_summarize"."review_id" IS '专家抽取id';
COMMENT ON COLUMN "public"."zjk_product_summarize"."product_summarize_name" IS '项目总结名称';
COMMENT ON COLUMN "public"."zjk_product_summarize"."product_summarize_type" IS '项目总结分类';
COMMENT ON COLUMN "public"."zjk_product_summarize"."product_general" IS '项目概况';
COMMENT ON COLUMN "public"."zjk_product_summarize"."review_scope" IS '评审范围';
COMMENT ON COLUMN "public"."zjk_product_summarize"."review_conclusion" IS '评审结论';
COMMENT ON COLUMN "public"."zjk_product_summarize"."feedback" IS '反馈';
COMMENT ON COLUMN "public"."zjk_product_summarize"."subsequent" IS '后续改进措施';
COMMENT ON COLUMN "public"."zjk_product_summarize"."attachment" IS '附件';
COMMENT ON COLUMN "public"."zjk_product_summarize"."tenant_id" IS '租户号';
COMMENT ON COLUMN "public"."zjk_product_summarize"."expert_ids" IS '专家id';
COMMENT ON COLUMN "public"."zjk_product_summarize"."status" IS '状态';
COMMENT ON COLUMN "public"."zjk_product_summarize"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."zjk_product_summarize"."create_by" IS '创建人';
COMMENT ON COLUMN "public"."zjk_product_summarize"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."zjk_product_summarize"."update_by" IS '更新人';
COMMENT ON COLUMN "public"."zjk_product_summarize"."update_time" IS '更新时间';
COMMENT ON COLUMN "public"."zjk_product_summarize"."remark" IS '备注';
COMMENT ON COLUMN "public"."zjk_product_summarize"."del_flag" IS '是否删除';
COMMENT ON COLUMN "public"."zjk_product_summarize"."audit_status" IS '审核状态';
COMMENT ON COLUMN "public"."zjk_product_summarize"."audit_remark" IS '审核备注';
COMMENT ON COLUMN "public"."zjk_product_summarize"."audit_by" IS '审核人';
COMMENT ON COLUMN "public"."zjk_product_summarize"."audit_time" IS '审核时间';
COMMENT ON COLUMN "public"."zjk_product_summarize"."product_id" IS '项目id';
COMMENT ON COLUMN "public"."zjk_product_summarize"."review_sn" IS '项目阶段';
COMMENT ON COLUMN "public"."zjk_product_summarize"."is_evaluate" IS '是否评价（0，未评价，1.已评价）';
COMMENT ON TABLE "public"."zjk_product_summarize" IS '项目总结';

-- ----------------------------
-- Table structure for zjk_product_summarize_log
-- ----------------------------
DROP TABLE IF EXISTS "public"."zjk_product_summarize_log";
CREATE TABLE "public"."zjk_product_summarize_log" (
  "id" int8 NOT NULL,
  "summarize_id" int8,
  "review_id" int8,
  "product_summarize_name" varchar(255) COLLATE "pg_catalog"."default",
  "product_summarize_type" varchar(255) COLLATE "pg_catalog"."default",
  "product_general" varchar(255) COLLATE "pg_catalog"."default",
  "review_scope" varchar(255) COLLATE "pg_catalog"."default",
  "review_conclusion" varchar(255) COLLATE "pg_catalog"."default",
  "feedback" varchar(255) COLLATE "pg_catalog"."default",
  "subsequent" varchar(255) COLLATE "pg_catalog"."default",
  "attachment" text COLLATE "pg_catalog"."default",
  "tenant_id" varchar COLLATE "pg_catalog"."default",
  "expert_ids" varchar(255) COLLATE "pg_catalog"."default",
  "status" varchar(255) COLLATE "pg_catalog"."default",
  "create_dept" int8,
  "create_by" int8,
  "create_time" "sys"."date",
  "update_by" int8,
  "update_time" "sys"."date",
  "remark" varchar(500) COLLATE "pg_catalog"."default",
  "del_flag" int4 DEFAULT 0,
  "audit_status" varchar(255) COLLATE "pg_catalog"."default",
  "audit_remark" varchar(255) COLLATE "pg_catalog"."default",
  "audit_by" int8,
  "audit_time" timestamp(6),
  "product_id" int8,
  "review_sn" varchar(255) COLLATE "pg_catalog"."default",
  "is_evaluate" int2 NOT NULL DEFAULT 0
)
;
COMMENT ON COLUMN "public"."zjk_product_summarize_log"."is_evaluate" IS '是否评价';

-- ----------------------------
-- Table structure for zjk_project_evaluation
-- ----------------------------
DROP TABLE IF EXISTS "public"."zjk_project_evaluation";
CREATE TABLE "public"."zjk_project_evaluation" (
  "id" int8 NOT NULL DEFAULT nextval('zjk_project_evaluation_id_seq'::regclass),
  "product_summarize_id" int8,
  "goal_achievement" numeric(24,1),
  "delivery_quality" numeric(24,1),
  "cost_control" numeric(24,1),
  "risk_management" numeric(24,1),
  "project_value" numeric(24,1),
  "evaluate_file" varchar(255) COLLATE "pg_catalog"."default",
  "TENANT_ID" varchar(32) COLLATE "pg_catalog"."default",
  "REVISION" int4,
  "CREATE_BY" varchar(32) COLLATE "pg_catalog"."default",
  "CREATE_TIME" timestamp(6),
  "UPDATE_BY" varchar(32) COLLATE "pg_catalog"."default",
  "UPDATE_TIME" timestamp(6),
  "project_summary_evaluation" text COLLATE "pg_catalog"."default",
  "create_dept" varchar(255) COLLATE "pg_catalog"."default",
  "appraiser" varchar(255) COLLATE "pg_catalog"."default",
  "appraiser_time" "sys"."date"
)
;
COMMENT ON COLUMN "public"."zjk_project_evaluation"."id" IS '主键';
COMMENT ON COLUMN "public"."zjk_project_evaluation"."product_summarize_id" IS '项目总结id';
COMMENT ON COLUMN "public"."zjk_project_evaluation"."goal_achievement" IS '目标达成';
COMMENT ON COLUMN "public"."zjk_project_evaluation"."delivery_quality" IS '交付质量';
COMMENT ON COLUMN "public"."zjk_project_evaluation"."cost_control" IS '成本控制';
COMMENT ON COLUMN "public"."zjk_project_evaluation"."risk_management" IS '风险管理';
COMMENT ON COLUMN "public"."zjk_project_evaluation"."project_value" IS '项目价值';
COMMENT ON COLUMN "public"."zjk_project_evaluation"."evaluate_file" IS '项目总结评价文件id集合';
COMMENT ON COLUMN "public"."zjk_project_evaluation"."TENANT_ID" IS '租户号';
COMMENT ON COLUMN "public"."zjk_project_evaluation"."REVISION" IS '乐观锁';
COMMENT ON COLUMN "public"."zjk_project_evaluation"."CREATE_BY" IS '创建人';
COMMENT ON COLUMN "public"."zjk_project_evaluation"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "public"."zjk_project_evaluation"."UPDATE_BY" IS '更新人';
COMMENT ON COLUMN "public"."zjk_project_evaluation"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "public"."zjk_project_evaluation"."project_summary_evaluation" IS '项目总结评价';
COMMENT ON COLUMN "public"."zjk_project_evaluation"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."zjk_project_evaluation"."appraiser" IS '评价人';
COMMENT ON COLUMN "public"."zjk_project_evaluation"."appraiser_time" IS '评价时间';
COMMENT ON TABLE "public"."zjk_project_evaluation" IS '项目总结评价';

-- ----------------------------
-- Table structure for zjk_retirement_records
-- ----------------------------
DROP TABLE IF EXISTS "public"."zjk_retirement_records";
CREATE TABLE "public"."zjk_retirement_records" (
  "id" int8 NOT NULL,
  "expert_id" int8,
  "user_id" int8,
  "retirement_time" "sys"."date",
  "expert_status" varchar(255) COLLATE "pg_catalog"."default",
  "create_by" int8,
  "create_time" "sys"."date",
  "create_dept" int8,
  "update_by" int8,
  "update_time" "sys"."date",
  "tenant_id" varchar(255) COLLATE "pg_catalog"."default",
  "del_flag" int4 DEFAULT 0,
  "reason" varchar(255) COLLATE "pg_catalog"."default",
  "file_path" varchar(1000) COLLATE "pg_catalog"."default"
)
;
COMMENT ON COLUMN "public"."zjk_retirement_records"."id" IS 'id';
COMMENT ON COLUMN "public"."zjk_retirement_records"."expert_id" IS '专家 id';
COMMENT ON COLUMN "public"."zjk_retirement_records"."user_id" IS '用户 id';
COMMENT ON COLUMN "public"."zjk_retirement_records"."retirement_time" IS '退休时间';
COMMENT ON COLUMN "public"."zjk_retirement_records"."expert_status" IS '专家状态 4 离职 5退休';
COMMENT ON COLUMN "public"."zjk_retirement_records"."create_by" IS '创建人';
COMMENT ON COLUMN "public"."zjk_retirement_records"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."zjk_retirement_records"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."zjk_retirement_records"."update_by" IS '更新人';
COMMENT ON COLUMN "public"."zjk_retirement_records"."update_time" IS '更新时间';
COMMENT ON COLUMN "public"."zjk_retirement_records"."tenant_id" IS '租户号';
COMMENT ON COLUMN "public"."zjk_retirement_records"."del_flag" IS '逻辑删除';
COMMENT ON COLUMN "public"."zjk_retirement_records"."reason" IS '离职原因';
COMMENT ON COLUMN "public"."zjk_retirement_records"."file_path" IS '附件';
COMMENT ON TABLE "public"."zjk_retirement_records" IS '专家退休记录表';

-- ----------------------------
-- Table structure for zjk_review_phase
-- ----------------------------
DROP TABLE IF EXISTS "public"."zjk_review_phase";
CREATE TABLE "public"."zjk_review_phase" (
  "id" int8 NOT NULL DEFAULT nextval('zjk_review_phase_id_seq'::regclass),
  "review_sn" int8,
  "review_time" timestamp(6),
  "review_place" varchar(90) COLLATE "pg_catalog"."default",
  "planned_intake" int8,
  "extraction_mode" varchar(64) COLLATE "pg_catalog"."default",
  "extractio_restriction" varchar(64) COLLATE "pg_catalog"."default",
  "avoidance_expert" text COLLATE "pg_catalog"."default",
  "avoidance_unit" text COLLATE "pg_catalog"."default",
  "TENANT_ID" varchar(32) COLLATE "pg_catalog"."default",
  "REVISION" int4,
  "CREATE_BY" varchar(32) COLLATE "pg_catalog"."default",
  "CREATE_TIME" timestamp(6),
  "UPDATE_BY" varchar(32) COLLATE "pg_catalog"."default",
  "item_id" int8,
  "UPDATE_TIME" timestamp(6),
  "create_dept" varchar(255) COLLATE "pg_catalog"."default",
  "item_extreation_id" int8,
  "designated_number" varchar(600) COLLATE "pg_catalog"."default",
  "area" text COLLATE "pg_catalog"."default",
  "effective" int2 DEFAULT 0,
  "cause_repum" text COLLATE "pg_catalog"."default",
  "parent_id" int8 DEFAULT 0,
  "extract_area" text COLLATE "pg_catalog"."default",
  "source" int2 DEFAULT 0,
  "is_summarize" int8 DEFAULT 0,
  "confirm_code" varchar(255) COLLATE "pg_catalog"."default",
  "refuse_code" varchar(255) COLLATE "pg_catalog"."default"
)
;
COMMENT ON COLUMN "public"."zjk_review_phase"."review_sn" IS '评审阶段';
COMMENT ON COLUMN "public"."zjk_review_phase"."review_time" IS '评审时间';
COMMENT ON COLUMN "public"."zjk_review_phase"."review_place" IS '评审地点';
COMMENT ON COLUMN "public"."zjk_review_phase"."planned_intake" IS '计划抽取人数';
COMMENT ON COLUMN "public"."zjk_review_phase"."extraction_mode" IS '抽取方式';
COMMENT ON COLUMN "public"."zjk_review_phase"."extractio_restriction" IS '抽取限制';
COMMENT ON COLUMN "public"."zjk_review_phase"."avoidance_expert" IS '回避专家';
COMMENT ON COLUMN "public"."zjk_review_phase"."avoidance_unit" IS '回避单位';
COMMENT ON COLUMN "public"."zjk_review_phase"."TENANT_ID" IS '租户号';
COMMENT ON COLUMN "public"."zjk_review_phase"."REVISION" IS '乐观锁';
COMMENT ON COLUMN "public"."zjk_review_phase"."CREATE_BY" IS '创建人';
COMMENT ON COLUMN "public"."zjk_review_phase"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "public"."zjk_review_phase"."UPDATE_BY" IS '更新人';
COMMENT ON COLUMN "public"."zjk_review_phase"."item_id" IS '项目id';
COMMENT ON COLUMN "public"."zjk_review_phase"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "public"."zjk_review_phase"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."zjk_review_phase"."item_extreation_id" IS '抽取id';
COMMENT ON COLUMN "public"."zjk_review_phase"."designated_number" IS '指定专家';
COMMENT ON COLUMN "public"."zjk_review_phase"."area" IS '抽取领域';
COMMENT ON COLUMN "public"."zjk_review_phase"."effective" IS '是否有效（0无效，1有效）';
COMMENT ON COLUMN "public"."zjk_review_phase"."cause_repum" IS '重抽原因';
COMMENT ON COLUMN "public"."zjk_review_phase"."parent_id" IS '父id';
COMMENT ON COLUMN "public"."zjk_review_phase"."extract_area" IS '抽取地域';
COMMENT ON COLUMN "public"."zjk_review_phase"."source" IS '数据来源(1：补抽)';
COMMENT ON COLUMN "public"."zjk_review_phase"."is_summarize" IS '是否总结  0 未总结 1总结 ';
COMMENT ON COLUMN "public"."zjk_review_phase"."confirm_code" IS '短信确认随机码';
COMMENT ON COLUMN "public"."zjk_review_phase"."refuse_code" IS '短信拒绝随机码';
COMMENT ON TABLE "public"."zjk_review_phase" IS '抽取规则';

-- ----------------------------
-- Table structure for zjk_sms_config
-- ----------------------------
DROP TABLE IF EXISTS "public"."zjk_sms_config";
CREATE TABLE "public"."zjk_sms_config" (
  "ID" int8 NOT NULL,
  "config_name" varchar(255) COLLATE "pg_catalog"."default",
  "sp_id" varchar(255) COLLATE "pg_catalog"."default",
  "sp_password" varchar(255) COLLATE "pg_catalog"."default",
  "send_url" varchar(255) COLLATE "pg_catalog"."default",
  "service_id" varchar(255) COLLATE "pg_catalog"."default",
  "priority" varchar(255) COLLATE "pg_catalog"."default",
  "start_flag" varchar(255) COLLATE "pg_catalog"."default",
  "create_dept" varchar(255) COLLATE "pg_catalog"."default",
  "tenant_id" varchar(8) COLLATE "pg_catalog"."default",
  "CREATE_BY" int8,
  "CREATE_TIME" "sys"."date",
  "UPDATE_BY" int8,
  "UPDATE_TIME" "sys"."date"
)
;
COMMENT ON COLUMN "public"."zjk_sms_config"."ID" IS '租户号';
COMMENT ON COLUMN "public"."zjk_sms_config"."config_name" IS '配置名称';
COMMENT ON COLUMN "public"."zjk_sms_config"."sp_id" IS 'spId';
COMMENT ON COLUMN "public"."zjk_sms_config"."sp_password" IS 'spPassword';
COMMENT ON COLUMN "public"."zjk_sms_config"."send_url" IS '短信发送请求地址';
COMMENT ON COLUMN "public"."zjk_sms_config"."service_id" IS 'serviceId';
COMMENT ON COLUMN "public"."zjk_sms_config"."priority" IS '优先级';
COMMENT ON COLUMN "public"."zjk_sms_config"."start_flag" IS '启动标识1：启动；0未启动';
COMMENT ON COLUMN "public"."zjk_sms_config"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."zjk_sms_config"."tenant_id" IS '租户id';
COMMENT ON COLUMN "public"."zjk_sms_config"."CREATE_BY" IS '创建人';
COMMENT ON COLUMN "public"."zjk_sms_config"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "public"."zjk_sms_config"."UPDATE_BY" IS '更新人';
COMMENT ON COLUMN "public"."zjk_sms_config"."UPDATE_TIME" IS '更新时间';
COMMENT ON TABLE "public"."zjk_sms_config" IS '短信配置表';

-- ----------------------------
-- Table structure for zjk_sms_info
-- ----------------------------
DROP TABLE IF EXISTS "public"."zjk_sms_info";
CREATE TABLE "public"."zjk_sms_info" (
  "ID" int8 NOT NULL,
  "send_status" int4,
  "template_id" varchar(255) COLLATE "pg_catalog"."default",
  "sms_content" varchar(5000) COLLATE "pg_catalog"."default",
  "send_num" int4,
  "status_id" varchar(255) COLLATE "pg_catalog"."default",
  "return_msg" text COLLATE "pg_catalog"."default",
  "return_code" varchar(255) COLLATE "pg_catalog"."default",
  "batch_num" varchar(32) COLLATE "pg_catalog"."default",
  "batch_type" int4,
  "receive_user_id" int8,
  "create_dept" varchar(255) COLLATE "pg_catalog"."default",
  "tenant_id" varchar(8) COLLATE "pg_catalog"."default",
  "CREATE_BY" int8,
  "CREATE_TIME" timestamp(0),
  "UPDATE_BY" int8,
  "UPDATE_TIME" timestamp(0),
  "param_json" varchar(5000) COLLATE "pg_catalog"."default",
  "receive_phone" varchar(255) COLLATE "pg_catalog"."default",
  "send_by" int8
)
;
COMMENT ON COLUMN "public"."zjk_sms_info"."ID" IS '租户号';
COMMENT ON COLUMN "public"."zjk_sms_info"."send_status" IS '发送状态;0：未发送；1已发送';
COMMENT ON COLUMN "public"."zjk_sms_info"."template_id" IS '模板id';
COMMENT ON COLUMN "public"."zjk_sms_info"."sms_content" IS '短信内容';
COMMENT ON COLUMN "public"."zjk_sms_info"."send_num" IS '重发次数';
COMMENT ON COLUMN "public"."zjk_sms_info"."status_id" IS '发送后返回的resultId';
COMMENT ON COLUMN "public"."zjk_sms_info"."return_msg" IS '发送返回的报文';
COMMENT ON COLUMN "public"."zjk_sms_info"."return_code" IS '发送返回的状态码';
COMMENT ON COLUMN "public"."zjk_sms_info"."batch_num" IS '发送批次';
COMMENT ON COLUMN "public"."zjk_sms_info"."batch_type" IS '批次类型;（1：群发；0单发）';
COMMENT ON COLUMN "public"."zjk_sms_info"."receive_user_id" IS '接收人用户id';
COMMENT ON COLUMN "public"."zjk_sms_info"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."zjk_sms_info"."tenant_id" IS '租户id';
COMMENT ON COLUMN "public"."zjk_sms_info"."CREATE_BY" IS '创建人';
COMMENT ON COLUMN "public"."zjk_sms_info"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "public"."zjk_sms_info"."UPDATE_BY" IS '更新人';
COMMENT ON COLUMN "public"."zjk_sms_info"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "public"."zjk_sms_info"."param_json" IS '模板渲染参数';
COMMENT ON COLUMN "public"."zjk_sms_info"."receive_phone" IS '接收电话号';
COMMENT ON COLUMN "public"."zjk_sms_info"."send_by" IS '发送人';

-- ----------------------------
-- Table structure for zjk_sms_template
-- ----------------------------
DROP TABLE IF EXISTS "public"."zjk_sms_template";
CREATE TABLE "public"."zjk_sms_template" (
  "ID" int4 NOT NULL,
  "tml_type" varchar(255) COLLATE "pg_catalog"."default",
  "tml_content" varchar(255) COLLATE "pg_catalog"."default",
  "start_flag" int4 DEFAULT 1,
  "create_dept" varchar(255) COLLATE "pg_catalog"."default",
  "tenant_id" varchar(8) COLLATE "pg_catalog"."default",
  "CREATE_BY" int4,
  "CREATE_TIME" timestamp(0),
  "UPDATE_BY" int4,
  "UPDATE_TIME" timestamp(0),
  "title" varchar(255) COLLATE "pg_catalog"."default"
)
;
COMMENT ON COLUMN "public"."zjk_sms_template"."ID" IS '租户号';
COMMENT ON COLUMN "public"."zjk_sms_template"."tml_type" IS '模板类型;1：专家抽取发送；2：请假通知发送';
COMMENT ON COLUMN "public"."zjk_sms_template"."tml_content" IS '模板内容';
COMMENT ON COLUMN "public"."zjk_sms_template"."start_flag" IS '启用标识（默认启用）;1：启用 0：未启用';
COMMENT ON COLUMN "public"."zjk_sms_template"."create_dept" IS '创建部门';
COMMENT ON COLUMN "public"."zjk_sms_template"."tenant_id" IS '租户id';
COMMENT ON COLUMN "public"."zjk_sms_template"."CREATE_BY" IS '创建人';
COMMENT ON COLUMN "public"."zjk_sms_template"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "public"."zjk_sms_template"."UPDATE_BY" IS '更新人';
COMMENT ON COLUMN "public"."zjk_sms_template"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "public"."zjk_sms_template"."title" IS '短信标头';
COMMENT ON TABLE "public"."zjk_sms_template" IS '短信模板';

-- ----------------------------
-- Table structure for zjk_sms_up
-- ----------------------------
DROP TABLE IF EXISTS "public"."zjk_sms_up";
CREATE TABLE "public"."zjk_sms_up" (
  "ID" int4 NOT NULL,
  "content" varchar(5000) COLLATE "pg_catalog"."default",
  "user_id" int4,
  "mobile" varchar(255) COLLATE "pg_catalog"."default",
  "send_time" timestamp(0),
  "login_name" varchar(255) COLLATE "pg_catalog"."default",
  "CREATE_TIME" timestamp(0)
)
;
COMMENT ON COLUMN "public"."zjk_sms_up"."ID" IS '租户号';
COMMENT ON COLUMN "public"."zjk_sms_up"."content" IS '上行短信内容';
COMMENT ON COLUMN "public"."zjk_sms_up"."user_id" IS '发送人id';
COMMENT ON COLUMN "public"."zjk_sms_up"."mobile" IS '发送人手机号';
COMMENT ON COLUMN "public"."zjk_sms_up"."send_time" IS '发送时间';
COMMENT ON COLUMN "public"."zjk_sms_up"."login_name" IS '登录账户';
COMMENT ON COLUMN "public"."zjk_sms_up"."CREATE_TIME" IS '创建时间';
COMMENT ON TABLE "public"."zjk_sms_up" IS '上行短信表';

-- ----------------------------
-- Primary Key structure for table zjk_annual_inspection
-- ----------------------------
ALTER TABLE "public"."zjk_annual_inspection" ADD CONSTRAINT "zjk_annual_inspection_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table zjk_annual_inspection_records
-- ----------------------------
ALTER TABLE "public"."zjk_annual_inspection_records" ADD CONSTRAINT "zjk_annual_inspection_records_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table zjk_approval_process_logs
-- ----------------------------
ALTER TABLE "public"."zjk_approval_process_logs" ADD CONSTRAINT "zjk_approval_process_logs_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table zjk_credit
-- ----------------------------
ALTER TABLE "public"."zjk_credit" ADD CONSTRAINT "zjk_point_copy1_pkey" PRIMARY KEY ("credit_id");

-- ----------------------------
-- Primary Key structure for table zjk_credit_lv
-- ----------------------------
ALTER TABLE "public"."zjk_credit_lv" ADD CONSTRAINT "zjk_credit_lv_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table zjk_credit_reward
-- ----------------------------
ALTER TABLE "public"."zjk_credit_reward" ADD CONSTRAINT "zjk_credit_reward_pkey" PRIMARY KEY ("ID");

-- ----------------------------
-- Primary Key structure for table zjk_credit_rule
-- ----------------------------
ALTER TABLE "public"."zjk_credit_rule" ADD CONSTRAINT "zjk_point_rule_copy1_pkey" PRIMARY KEY ("ID");

-- ----------------------------
-- Primary Key structure for table zjk_credit_user
-- ----------------------------
ALTER TABLE "public"."zjk_credit_user" ADD CONSTRAINT "zjk_point_user_copy1_pkey" PRIMARY KEY ("ID");

-- ----------------------------
-- Primary Key structure for table zjk_data_changes_logs
-- ----------------------------
ALTER TABLE "public"."zjk_data_changes_logs" ADD CONSTRAINT "zjk_data_changes_logs_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table zjk_evaluate
-- ----------------------------
ALTER TABLE "public"."zjk_evaluate" ADD CONSTRAINT "zjk_evaluate_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table zjk_expert_awards
-- ----------------------------
ALTER TABLE "public"."zjk_expert_awards" ADD CONSTRAINT "zjk_expert_awards_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table zjk_expert_chart
-- ----------------------------
ALTER TABLE "public"."zjk_expert_chart" ADD CONSTRAINT "zjk_expert_chart_pkey" PRIMARY KEY ("ID");

-- ----------------------------
-- Primary Key structure for table zjk_expert_item
-- ----------------------------
ALTER TABLE "public"."zjk_expert_item" ADD CONSTRAINT "zjk_expert_item_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table zjk_expert_log
-- ----------------------------
ALTER TABLE "public"."zjk_expert_log" ADD CONSTRAINT "zjk_expert_log_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table zjk_expert_major
-- ----------------------------
ALTER TABLE "public"."zjk_expert_major" ADD CONSTRAINT "zjk_expert_major_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table zjk_expert_money_config
-- ----------------------------
ALTER TABLE "public"."zjk_expert_money_config" ADD CONSTRAINT "zjk_expert_money_config_pkey" PRIMARY KEY ("money_id");

-- ----------------------------
-- Primary Key structure for table zjk_expert_money_fp
-- ----------------------------
ALTER TABLE "public"."zjk_expert_money_fp" ADD CONSTRAINT "zjk_expert_money_info_copy1_pkey" PRIMARY KEY ("fp_id");

-- ----------------------------
-- Primary Key structure for table zjk_expert_money_info
-- ----------------------------
ALTER TABLE "public"."zjk_expert_money_info" ADD CONSTRAINT "zjk_expert_money_config_copy1_pkey" PRIMARY KEY ("money_id");

-- ----------------------------
-- Primary Key structure for table zjk_expert_paper
-- ----------------------------
ALTER TABLE "public"."zjk_expert_paper" ADD CONSTRAINT "zjk_expert_paper_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table zjk_expert_patent
-- ----------------------------
ALTER TABLE "public"."zjk_expert_patent" ADD CONSTRAINT "zjk_expert_patent_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table zjk_expert_professional
-- ----------------------------
ALTER TABLE "public"."zjk_expert_professional" ADD CONSTRAINT "zjk_expert_professional_pkey" PRIMARY KEY ("id", "user_id", "expert_id");

-- ----------------------------
-- Primary Key structure for table zjk_expert_recommend
-- ----------------------------
ALTER TABLE "public"."zjk_expert_recommend" ADD CONSTRAINT "zjk_expert_recommend_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table zjk_invoice
-- ----------------------------
ALTER TABLE "public"."zjk_invoice" ADD CONSTRAINT "zjk_invoice_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table zjk_item_extreation
-- ----------------------------
ALTER TABLE "public"."zjk_item_extreation" ADD CONSTRAINT "zjk_item_extreation_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table zjk_learning_activity
-- ----------------------------
ALTER TABLE "public"."zjk_learning_activity" ADD CONSTRAINT "learning_activity_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table zjk_learning_commont
-- ----------------------------
ALTER TABLE "public"."zjk_learning_commont" ADD CONSTRAINT "zjk_learning_commont_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table zjk_learning_community
-- ----------------------------
ALTER TABLE "public"."zjk_learning_community" ADD CONSTRAINT "learning_community_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table zjk_learning_course
-- ----------------------------
ALTER TABLE "public"."zjk_learning_course" ADD CONSTRAINT "learning_course_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table zjk_learning_credit_record
-- ----------------------------
ALTER TABLE "public"."zjk_learning_credit_record" ADD CONSTRAINT "zjk_learning_record_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table zjk_learning_information
-- ----------------------------
ALTER TABLE "public"."zjk_learning_information" ADD CONSTRAINT "zjk_learning_Information_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table zjk_learning_materials
-- ----------------------------
ALTER TABLE "public"."zjk_learning_materials" ADD CONSTRAINT "zjk_learning_materials_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table zjk_learning_records
-- ----------------------------
ALTER TABLE "public"."zjk_learning_records" ADD CONSTRAINT "zjk_learning_records_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table zjk_learning_resource
-- ----------------------------
ALTER TABLE "public"."zjk_learning_resource" ADD CONSTRAINT "learning_resource_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table zjk_learning_tool
-- ----------------------------
ALTER TABLE "public"."zjk_learning_tool" ADD CONSTRAINT "learning_tool_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table zjk_leave
-- ----------------------------
ALTER TABLE "public"."zjk_leave" ADD CONSTRAINT "zjk_leave_pkey" PRIMARY KEY ("gid");

-- ----------------------------
-- Primary Key structure for table zjk_money_analyse_statement
-- ----------------------------
ALTER TABLE "public"."zjk_money_analyse_statement" ADD CONSTRAINT "zjk_money_analyse_statement_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table zjk_money_collect_statement
-- ----------------------------
ALTER TABLE "public"."zjk_money_collect_statement" ADD CONSTRAINT "zjk_money_collect_statement_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table zjk_money_expert_statement
-- ----------------------------
ALTER TABLE "public"."zjk_money_expert_statement" ADD CONSTRAINT "zjk_money_expert_statement_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table zjk_money_statement
-- ----------------------------
ALTER TABLE "public"."zjk_money_statement" ADD CONSTRAINT "zjk_money_statement_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table zjk_point
-- ----------------------------
ALTER TABLE "public"."zjk_point" ADD CONSTRAINT "zjk_point_pkey" PRIMARY KEY ("ID");

-- ----------------------------
-- Primary Key structure for table zjk_point_rule
-- ----------------------------
ALTER TABLE "public"."zjk_point_rule" ADD CONSTRAINT "zjk_point_rule_pkey" PRIMARY KEY ("ID");

-- ----------------------------
-- Primary Key structure for table zjk_point_user
-- ----------------------------
ALTER TABLE "public"."zjk_point_user" ADD CONSTRAINT "zjk_point_user_pkey" PRIMARY KEY ("ID");

-- ----------------------------
-- Primary Key structure for table zjk_problem
-- ----------------------------
ALTER TABLE "public"."zjk_problem" ADD CONSTRAINT "zjk_problem_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table zjk_product
-- ----------------------------
ALTER TABLE "public"."zjk_product" ADD CONSTRAINT "zjk_product_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table zjk_product_reviewsn
-- ----------------------------
ALTER TABLE "public"."zjk_product_reviewsn" ADD CONSTRAINT "zjk_product_reviewsn_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table zjk_product_summarize
-- ----------------------------
ALTER TABLE "public"."zjk_product_summarize" ADD CONSTRAINT "zjk_product_summarize_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table zjk_product_summarize_log
-- ----------------------------
ALTER TABLE "public"."zjk_product_summarize_log" ADD CONSTRAINT "zjk_product_summarize_log_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table zjk_project_evaluation
-- ----------------------------
ALTER TABLE "public"."zjk_project_evaluation" ADD CONSTRAINT "zjk_project_evaluation_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table zjk_retirement_records
-- ----------------------------
ALTER TABLE "public"."zjk_retirement_records" ADD CONSTRAINT "zjk_retirement_records_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table zjk_review_phase
-- ----------------------------
ALTER TABLE "public"."zjk_review_phase" ADD CONSTRAINT "zjk_review_phase_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table zjk_sms_config
-- ----------------------------
ALTER TABLE "public"."zjk_sms_config" ADD CONSTRAINT "zjk_sms_config_pkey" PRIMARY KEY ("ID");

-- ----------------------------
-- Primary Key structure for table zjk_sms_info
-- ----------------------------
ALTER TABLE "public"."zjk_sms_info" ADD CONSTRAINT "zjk_sms_info_pkey" PRIMARY KEY ("ID");

-- ----------------------------
-- Primary Key structure for table zjk_sms_template
-- ----------------------------
ALTER TABLE "public"."zjk_sms_template" ADD CONSTRAINT "zjk_sms_template_pkey" PRIMARY KEY ("ID");

-- ----------------------------
-- Primary Key structure for table zjk_sms_up
-- ----------------------------
ALTER TABLE "public"."zjk_sms_up" ADD CONSTRAINT "zjk_sms_up_pkey" PRIMARY KEY ("ID");
