package org.dromara.zjk.annualInspection.annualInspectionRecords.service;

import org.dromara.zjk.annualInspection.annualInspectionRecords.domain.vo.ZjkAnnualInspectionRecordsVo;
import org.dromara.zjk.annualInspection.annualInspectionRecords.domain.bo.ZjkAnnualInspectionRecordsBo;
import org.dromara.common.mybatis.core.page.TableDataInfo;
import org.dromara.common.mybatis.core.page.PageQuery;

import java.util.Collection;
import java.util.List;

/**
 * 年检记录Service接口
 *
 * @author zhangzhou
 * @date 2024-11-13
 */
public interface IZjkAnnualInspectionRecordsService {

    /**
     * 查询年检记录
     *
     * @param id 主键
     * @return 年检记录
     */
    ZjkAnnualInspectionRecordsVo queryById(Long id);

    /**
     * 分页查询年检记录列表
     *
     * @param bo        查询条件
     * @param pageQuery 分页参数
     * @return 年检记录分页列表
     */
    TableDataInfo<ZjkAnnualInspectionRecordsVo> queryPageList(ZjkAnnualInspectionRecordsBo bo, PageQuery pageQuery);

    /**
     * 查询符合条件的年检记录列表
     *
     * @param bo 查询条件
     * @return 年检记录列表
     */
    List<ZjkAnnualInspectionRecordsVo> queryList(ZjkAnnualInspectionRecordsBo bo);

    /**
     * 新增年检记录
     *
     * @param bo 年检记录
     * @return 是否新增成功
     */
    Boolean insertByBo(ZjkAnnualInspectionRecordsBo bo);

    /**
     * 修改年检记录
     *
     * @param bo 年检记录
     * @return 是否修改成功
     */
    Boolean updateByBo(ZjkAnnualInspectionRecordsBo bo);

    /**
     * 校验并批量删除年检记录信息
     *
     * @param ids     待删除的主键集合
     * @param isValid 是否进行有效性校验
     * @return 是否删除成功
     */
    Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);
}
