package org.dromara.zjk.domain;

import org.dromara.common.tenant.core.TenantEntity;
import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.dromara.zjk.annotation.PropertyMsg;
import java.io.Serial;

/**
 * 信用奖励对象 zjk_credit_reward
 *
 * @author ygh
 * @date 2024-11-11
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("zjk_credit_reward")
public class ZjkCreditReward extends TenantEntity {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 租户号
     */
    @PropertyMsg(propertyName = "ID")
    private String ID;

    /**
     * 信用奖励名称
     */
    @PropertyMsg(propertyName = "reward_name")
    private String rewardName;

    /**
     * 激励类型;字典值credit_reward_type
     */
    @PropertyMsg(propertyName = "reward_type")
    private Long rewardType;

    /**
     * 激励内容
     */
    @PropertyMsg(propertyName = "reward_content")
    private String rewardContent;

    /**
     * 激励标的;字典值 信用
     */
    @PropertyMsg(propertyName = "reward_obj")
    private Long rewardObj;

    /**
     * 生效符号;><=
     */
    @PropertyMsg(propertyName = "effect_flag")
    private String effectFlag;

    /**
     * 生效标准;临界分值
     */
    @PropertyMsg(propertyName = "effect_standard")
    private Long effectStandard;

    /**
     * 激励截至时间
     */
    @PropertyMsg(propertyName = "reward_until")
    private Date rewardUntil;

    /**
     * 是否永久;1：永久；0不永久
     */
    @PropertyMsg(propertyName = "is_forever")
    private Long isForever;

    /**
     * 启用标识
     */
    @PropertyMsg(propertyName = "status")
    private Long status;


}
