package org.dromara.zjk.domain.bo;

import org.dromara.zjk.domain.LearningPlanCourse;
import org.dromara.common.mybatis.core.domain.BaseEntity;
import org.dromara.common.core.validate.AddGroup;
import org.dromara.common.core.validate.EditGroup;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import lombok.EqualsAndHashCode;
import jakarta.validation.constraints.*;

/**
 * 【请填写功能名称】业务对象 zjk_learning_plan_course
 *
 * @author ygh
 * @date 2025-07-28
 */
@Data
@EqualsAndHashCode(callSuper = true)
@AutoMapper(target = LearningPlanCourse.class, reverseConvertGenerate = false)
public class LearningPlanCourseBo extends BaseEntity {

    /**
     * 主键
     */
    private Long ID;

    /**
     * 计划id
     */
    @NotBlank(message = "计划id不能为空", groups = { AddGroup.class, EditGroup.class })
    private String planId;

    /**
     * 课程id
     */
    @NotNull(message = "课程id不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long courseId;


}
