package org.dromara.zjk.domain.vo;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.dromara.zjk.domain.ZjkExpertMoneyConfig;
import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import org.dromara.common.excel.annotation.ExcelDictFormat;
import org.dromara.common.excel.convert.ExcelDictConvert;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serial;
import java.io.Serializable;
import java.util.Date;



/**
 * 专家费用管理视图对象 zjk_expert_money_config
 *
 * @author by
 * @date 2024-11-25
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = ZjkExpertMoneyConfig.class)
public class ZjkExpertMoneyConfigVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    @ExcelProperty(value = "moneyId")
    @ExcelIgnore
    private String moneyId;

    /**
     * 专家费用标准类型(引用字典money_type)
     */
    @ExcelProperty(value = "费用标准类型")
    private String moneyType;

    /**
     * 专家费用周期
     */
    @ExcelProperty(value = "专家费用周期")
    private String moneyCycle;

    /**
     * 专家费用
     */
    @ExcelProperty(value = "专家费用")
    private Long moneyNumber;

    @ExcelProperty(value = "计费方式")
    private String moneyMethod;

    /**
     * 备注
     */
    @ExcelProperty(value = "备注")
    private String remark;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ExcelIgnore
    private Date createTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ExcelIgnore
    private Date updateTime;
}
