package org.dromara.zjk.domain.vo;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import org.dromara.zjk.domain.ZjkExpert;
import org.dromara.zjk.domain.ZjkItemExtreation;
import org.dromara.zjk.domain.ZjkReviewPhase;

import java.io.Serial;
import java.io.Serializable;
import java.util.Date;
import java.util.List;


/**
 * 专家抽取视图对象 zjk_item_extreation
 *
 * @author ygh
 * @date 2024-10-29
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = ZjkItemExtreation.class)
public class ZjkItemExtreationVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     *主键
     */
    private Long id;

    /**
     * 项目id
     */
    private Long itemId;

    /**
     *专家数量
     */
    private Integer expertSum;

    /**
     *抽取次数
     */
    private Integer extractionCount;

    /**
     * 已抽取次数
     */
    private Integer extractedSum;

    /**
     * 抽取状态
     */
    private Integer extractionStatus;

    /**
     * 抽取时间
     */
    private Date extractionTime;
    /**
     * 专家确认截至时间
     */
    private Date noticeTime;

    /**
     *抽取人
     */
    private String extractionUser;

    /**
     * 抽取流水号
     */
    private String extractionSn;

    /*
    * 专家列表
    * */
    private List<ZjkExpertVo> zjkExpertVo;

    /*
    * 补抽专家列表
    * */
    private List<ZjkExpertVo> zjkRewboExpertVos;

    /*
    * 项目信息
    * */
    private ZjkProductVo zjkProductVo;

    /*
    * 抽取设置
    * */
    private ZjkReviewPhase zjkReviewPhase;

    private Long reviewId;

    private List<ZjkExpert> designatedNumbers;

    private List<ZjkExpertVo> avoidanceUnitList;

    private String avoidanceUnits;

    private List<ZjkReviewPhaseVo> zjkReviewPhaseVoList;
    /**
     * 是否确认
     * */
    private Long isSure;


}
