package org.dromara.zjk.expert.expertRecommend.domain;

import org.dromara.common.tenant.core.TenantEntity;
import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serial;

/**
 * 专家推荐信息对象 zjk_expert_recommend
 *
 * @author zhangzhou
 * @date 2024-11-10
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("zjk_expert_recommend")
public class ZjkExpertRecommend extends TenantEntity {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    private Long id;

    /**
     * 专家 id
     */
    private Long expertId;

    /**
     * 用户 id
     */
    private Long userId;

    /**
     * 推荐专家姓名
     */
    private String expertName;

    /**
     * 专家手机号
     */
    private String expertPhone;

    /**
     * 推荐理由
     */
    private String reason;

    /**
     * 推荐状态 1 待审批 2 通过 3 驳回
     */
    private String status;

    /**
     * 逻辑删除
     */
    @TableLogic
    private Long delFlag;

    private String hmac;
}
