package org.dromara.zjk.learning_world.domain.vo;

import java.util.Date;

import org.dromara.zjk.learning_world.domain.entity.ZjkProblem;
import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;


/**
 * 问题管理视图对象 zjk_problem
 *
 * @author wt
 * @date 2024-11-20
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = ZjkProblem.class)
public class ZjkProblemVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @ExcelProperty(value = "id")
    private Long id;

    /**
     * 问题标题
     */
    @ExcelProperty(value = "问题标题")
    private String problemTitle;

    /**
     * 问题
     */
    @ExcelProperty(value = "问题")
    private String problem;

    /**
     * 回复内容
     */
    @ExcelProperty(value = "回复内容")
    private String reply;

    /**
     * 提问人
     */
    @ExcelProperty(value = "提问人")
    private Long userId;

    @ExcelProperty(value = "提问人姓名")
    private String userName;

    @ExcelProperty(value = "提问人部门")
    private String deptName;

    @ExcelProperty(value = "提问人头像")
    private String userPhotograph;

    /**
     * 回复人
     */
    @ExcelProperty(value = "回复人")
    private Long replyId;

    @ExcelProperty(value = "回复人姓名")
    private String replyName;

    @ExcelProperty(value = "回复人部门")
    private String replyDeptName;

    @ExcelProperty(value = "回复人头像")
    private String replyPhotograph;


    /**
     * 提问时间
     */
    @ExcelProperty(value = "提问时间")
    private Date problemTime;

    /**
     * 答复时间
     */
    @ExcelProperty(value = "答复时间")
    private Date replyTime;

    /**
     * 状态
     */
    @ExcelProperty(value = "状态")
    private String status;

    /**
     * 备注
     */
    @ExcelProperty(value = "备注")
    private String remark;


}
