package org.dromara.zjk.learning_world.service;

import org.dromara.common.mybatis.core.page.PageQuery;
import org.dromara.common.mybatis.core.page.TableDataInfo;
import org.dromara.zjk.learning_world.domain.bo.ZjkLearningToolBo;
import org.dromara.zjk.learning_world.domain.vo.ZjkLearningToolVo;

import java.util.Collection;
import java.util.List;

/**
 * 学习工具管理Service接口
 *
 * @author ygh
 * @date 2024-11-10
 */
public interface IZjkLearningToolService {

    /**
     * 查询学习工具管理
     *
     * @param id 主键
     * @return 学习工具管理
     */
    ZjkLearningToolVo queryById(Long id);

    /**
     * 分页查询学习工具管理列表
     *
     * @param bo        查询条件
     * @param pageQuery 分页参数
     * @return 学习工具管理分页列表
     */
    TableDataInfo<ZjkLearningToolVo> queryPageList(ZjkLearningToolBo bo, PageQuery pageQuery);

    /**
     * 查询符合条件的学习工具管理列表
     *
     * @param bo 查询条件
     * @return 学习工具管理列表
     */
    List<ZjkLearningToolVo> queryList(ZjkLearningToolBo bo);

    /**
     * 新增学习工具管理
     *
     * @param bo 学习工具管理
     * @return 是否新增成功
     */
    Boolean insertByBo(ZjkLearningToolBo bo);

    /**
     * 修改学习工具管理
     *
     * @param bo 学习工具管理
     * @return 是否修改成功
     */
    Boolean updateByBo(ZjkLearningToolBo bo);

    /**
     * 校验并批量删除学习工具管理信息
     *
     * @param ids     待删除的主键集合
     * @param isValid 是否进行有效性校验
     * @return 是否删除成功
     */
    Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);

    int editStatus(ZjkLearningToolBo bo);
}
