package org.dromara.zjk.mapper;

import org.dromara.common.mybatis.core.mapper.BaseMapperPlus;
import org.dromara.zjk.domain.ZjkCreditUser;
import org.dromara.zjk.domain.vo.CreditExpertGetVO;
import org.dromara.zjk.domain.vo.CreditShowVO;
import org.dromara.zjk.domain.vo.ZjkCreditUserVo;

import java.util.Date;
import java.util.List;

/**
 * 信用用户管理Mapper接口
 *
 * @author ygh
 * @date 2024-11-11
 */
public interface ZjkCreditUserMapper extends BaseMapperPlus<ZjkCreditUser, ZjkCreditUserVo> {

    List<CreditExpertGetVO> getExpertPointRank(Date rangeDay);

    CreditShowVO getRankAndPoint(Long userId);

    int removeTheBlacklist(ZjkCreditUser zjkCreditUser);
}
