package org.dromara.zjk.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;
import org.dromara.zjk.domain.ZjkEvaluate;
import org.dromara.zjk.domain.dto.LeaveStsDto;
import org.dromara.zjk.domain.dto.SelExpertRuleDto;
import org.dromara.zjk.domain.vo.*;

import java.util.Date;
import java.util.List;

/**
 * @author EDY
 * @description 针对表【zjk_evaluate(专家评价)】的数据库操作Mapper
 * @createDate 2024-11-01 10:11:52
 * @Entity org.dromara.zjk.domain.ZjkEvaluate
 */
public interface ZjkEvaluateMapper extends BaseMapper<ZjkEvaluate> {
    /**
     * 专家获取待评价的专家信息
     *
     * @param build   分页信息
     * @param userIds 需要排除的评价人集合
     * @param ruleIds 需要匹配的抽取规则id集合
     * @param bo
     * @return
     */
    IPage<ZjkEvaluateVO> getListToZj(Page<Object> build, List<String> userIds, List<String> itemIds, @Param("bo") ZjkEvaluateVO bo);

    ZjkEvaluateVO getInfoById(String gid);

    /**
     * 获取我参与评审的项目抽取的规则id集合
     *
     * @param userId
     * @return
     */
    List<SelExpertRuleDto> getMyJoinItems(Long userId);

    /**
     * 项目某个阶段进行了评价的用户集合
     *
     * @param itemId    项目id
     * @param itemStage 项目阶段
     * @return
     */
    List<String> getHadEvaluatedUsers(String itemId, String itemStage);

    IPage<ZjkEvaluateVO> getListToOrg(Page<Object> build, List<String> userIds, String tenantId, @Param("bo") ZjkEvaluateVO bo);

    List<String> testsysrole();

    IPage<ZjkEvaluateVO> getEvaluateListByExpert(Page<Object> build, @Param("bo") ZjkEvaluateVO bo);


    IPage<ZjkEvaluateVO> getListToXm(Page<Object> build, List<String> userIds, List<String> itemIds,@Param("bo")  ZjkEvaluateVO bo);

    StsEvaluateNumVO getStsNum();

    /**
     * 按月统计评价次数
     * @param ago
     * @param now
     * @return
     */
    List<LeaveStsDto> getStsEvaluateNums(Date ago, Date now);

    List<LeaveStsDto> getStsEvaluatePerNums(Date ago, Date now);

    List<StsFiveVO> getStsFiveStar();

    IPage<StsListVO> getStsList(Page<Object> build, @Param("bo") ZjkEvaluateVO bo);

    List<StsListVO> getStsEvaluateList(@Param("bo") ZjkEvaluateVO bo);

    Integer checkIsPresentStatus(ZjkEvaluateVO vo);

    List<String> updateOtherInfoToUnPresent(ZjkEvaluate zjkEvaluate);
}




