package org.dromara.zjk.mapper;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;
import org.dromara.common.mybatis.annotation.DataColumn;
import org.dromara.common.mybatis.annotation.DataPermission;
import org.dromara.zjk.domain.ZjkProductSummarize;
import org.dromara.zjk.domain.bo.ZjkProductSummarizeBo;
import org.dromara.zjk.domain.vo.ZjkProductSummarizeVo;
import org.dromara.common.mybatis.core.mapper.BaseMapperPlus;

import java.util.List;

/**
 * 项目总结Mapper接口
 *
 * @author ygh
 * @date 2024-11-02
 */
public interface ZjkProductSummarizeMapper extends BaseMapperPlus<ZjkProductSummarize, ZjkProductSummarizeVo> {
    @DataPermission({
        @DataColumn(key = "xmUserName", value = "zp.user_id"),
        @DataColumn(key = "deptName", value = "zp.create_dept")
    })
    Page<ZjkProductSummarizeVo> getProductInfo(Page<ZjkProductSummarizeVo> build, ZjkProductSummarizeBo bo);

    List<ZjkProductSummarizeVo> exportList(@Param("bo") ZjkProductSummarizeBo bo);
}
