/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.paramcheck;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.exception.runtime.NacosRuntimeException;
import com.alibaba.nacos.common.paramcheck.AbstractParamChecker;
import com.alibaba.nacos.common.paramcheck.ParamCheckResponse;
import com.alibaba.nacos.common.paramcheck.ParamCheckerManager;
import com.alibaba.nacos.common.paramcheck.ParamInfo;
import com.alibaba.nacos.core.code.ControllerMethodsCache;
import com.alibaba.nacos.core.exception.ErrorCode;
import com.alibaba.nacos.core.paramcheck.AbstractHttpParamExtractor;
import com.alibaba.nacos.core.paramcheck.ExtractorManager;
import com.alibaba.nacos.core.paramcheck.ServerParamCheckConfig;
import com.alibaba.nacos.plugin.control.Loggers;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ParamCheckerFilter
implements Filter {
    private final ControllerMethodsCache methodsCache;

    public ParamCheckerFilter(ControllerMethodsCache methodsCache) {
        this.methodsCache = methodsCache;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean paramCheckEnabled = ServerParamCheckConfig.getInstance().isParamCheckEnabled();
        if (!paramCheckEnabled) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        try {
            Method method = this.methodsCache.getMethod(req);
            if (method == null) {
                chain.doFilter((ServletRequest)req, (ServletResponse)resp);
                return;
            }
            ExtractorManager.Extractor extractor = method.getAnnotation(ExtractorManager.Extractor.class);
            if (extractor == null && (extractor = method.getDeclaringClass().getAnnotation(ExtractorManager.Extractor.class)) == null) {
                chain.doFilter(request, response);
                return;
            }
            AbstractHttpParamExtractor httpParamExtractor = ExtractorManager.getHttpExtractor(extractor);
            List<ParamInfo> paramInfoList = httpParamExtractor.extractParam(req);
            ParamCheckerManager paramCheckerManager = ParamCheckerManager.getInstance();
            AbstractParamChecker paramChecker = paramCheckerManager.getParamChecker(ServerParamCheckConfig.getInstance().getActiveParamChecker());
            ParamCheckResponse paramCheckResponse = paramChecker.checkParamInfoList(paramInfoList);
            if (paramCheckResponse.isSuccess()) {
                chain.doFilter((ServletRequest)req, (ServletResponse)resp);
            } else {
                Loggers.CONTROL.info("Param check invalid,{},url:{}", (Object)paramCheckResponse.getMessage(), (Object)req.getRequestURI());
                this.generate400Response(resp, paramCheckResponse.getMessage());
            }
        }
        catch (NacosException e) {
            Loggers.CONTROL.error("exception: {}", (Object)e.getMessage());
            throw new NacosRuntimeException(ErrorCode.UnKnowError.getCode(), (Throwable)e);
        }
    }

    public void generate400Response(HttpServletResponse response, String message) {
        try {
            response.setHeader("Pragma", "no-cache");
            response.setDateHeader("Expires", 0L);
            response.setHeader("Cache-Control", "no-cache,no-store");
            response.setStatus(400);
            response.getOutputStream().println(message);
        }
        catch (Exception ex) {
            Loggers.CONTROL.error("Error to generate tps 400 response", (Throwable)ex);
        }
    }
}

