/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.tianfu.json.internal.bind;

import com.tongweb.tianfu.json.Json;
import com.tongweb.tianfu.json.JsonSyntaxException;
import com.tongweb.tianfu.json.TypeAdapter;
import com.tongweb.tianfu.json.TypeAdapterFactory;
import com.tongweb.tianfu.json.reflect.TypeToken;
import com.tongweb.tianfu.json.stream.JsonReader;
import com.tongweb.tianfu.json.stream.JsonToken;
import com.tongweb.tianfu.json.stream.JsonWriter;
import java.io.IOException;
import java.sql.Time;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class TimeTypeAdapter
extends TypeAdapter<Time> {
    public static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        @Override
        public <T> TypeAdapter<T> create(Json json, TypeToken<T> typeToken) {
            return typeToken.getRawType() == Time.class ? new TimeTypeAdapter() : null;
        }
    };
    private final DateFormat format = new SimpleDateFormat("hh:mm:ss a");

    @Override
    public synchronized Time read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        try {
            Date date = this.format.parse(in.nextString());
            return new Time(date.getTime());
        }
        catch (ParseException e2) {
            throw new JsonSyntaxException(e2);
        }
    }

    @Override
    public synchronized void write(JsonWriter out, Time value) throws IOException {
        out.value(value == null ? null : this.format.format(value));
    }
}

