package org.dromara.zjk.annualInspection.annualInspectionAudit.domain.bo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.github.linpeilie.annotations.AutoMapper;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.dromara.common.core.validate.AddGroup;
import org.dromara.common.core.validate.EditGroup;
import org.dromara.common.mybatis.core.domain.BaseEntity;
import org.dromara.zjk.annotation.PropertyMsg;
import org.dromara.zjk.annualInspection.annualInspectionAudit.domain.ZjkAnnualInspection;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * 年检管理业务对象 zjk_annual_inspection
 *
 * @author zhangzhou
 * @date 2024-11-13
 */
@Data
@EqualsAndHashCode(callSuper = true)
@AutoMapper(target = ZjkAnnualInspection.class, reverseConvertGenerate = false)
public class ZjkAnnualInspectionBo extends BaseEntity {

    private List<Long> ids; // 专家 ID 集合
    /**
     * id
     */
    @NotNull(message = "id不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long id;

    /**
     * 用户 id
     */
    @NotNull(message = "用户 id不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long userId;

    /**
     * 专家 id
     */
    @NotNull(message = "专家 id不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long expertId;

    /**
     * 年检编号
     */
    @NotBlank(message = "年检编号不能为空", groups = { AddGroup.class, EditGroup.class })
    private String annualInspectionSn;

    /**
     * 年检名称
     */
    @NotBlank(message = "年检名称不能为空", groups = { AddGroup.class, EditGroup.class })
    private String annualInspectionName;

    /**
     * 审核方式(1 人工年检 2 自动年检)
     */
    @NotBlank(message = "审核方式(1 人工年检 2 自动年检)不能为空", groups = { AddGroup.class, EditGroup.class })
    private String annualInspectionType;

    /**
     * 年检状态(1 待年检 2 已通过 3 未通过)
     */
    @NotBlank(message = "年检状态(1 待年检 2 已通过 3 未通过)不能为空", groups = { AddGroup.class, EditGroup.class })
    private String annualInspectionStatus;

    /**
     * 审核时间
     */
    @NotNull(message = "审核时间不能为空", groups = { AddGroup.class, EditGroup.class })
    private Date auditTime;

    /**
     * 审核原因
     */
    @PropertyMsg(propertyName = "审核原因")
    private String reason;


    private String contact;

    @JsonFormat(pattern = "yyyy-MM-dd",timezone="GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date beginAuditTime;
    @JsonFormat(pattern = "yyyy-MM-dd",timezone="GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date endAuditTime;
    private String start;
    private String end;
}
