package org.dromara.zjk.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

/**
 * 对外接口拦截器
 *
 * @author : yanguohua
 * @version : 1.0
 * @date : 2025/8/26 15:23
 */
@Configuration
public class ZjkApiWebMvcConfig  implements WebMvcConfigurer {

    @Autowired
    private ApiAuthInterceptor apiAuthInterceptor;

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor(apiAuthInterceptor)
            .addPathPatterns("/api/**"); // 拦截所有 /api 开头的请求
    }
}
