package org.dromara.zjk.domain;

import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.*;

import org.dromara.common.mybatis.core.domain.BaseEntity;
import org.dromara.zjk.zwy.annotation.EncryptSensitive;
import org.dromara.zjk.annotation.PropertyMsg;
import org.dromara.zjk.expert.expertAwards.domain.ZjkExpertAwards;
import org.dromara.zjk.expert.expertPaper.domain.ZjkExpertPaper;
import org.dromara.zjk.expert.expertPatent.domain.ZjkExpertPatent;

import java.io.Serial;
import java.util.Date;
import java.util.List;

/**
 * expert对象 zjk_expert
 *
 * @author wangtong
 * @date 2024-10-24
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("zjk_expert")
@JsonInclude(JsonInclude.Include.NON_NULL)
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class ZjkExpert extends BaseEntity {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @TableId(type = IdType.ASSIGN_ID)
    private Long expertId;

    /**
     * 姓名
     * 注解判断修改什么内容
     */
    @PropertyMsg(propertyName = "姓名")
    private String expertName;

    /**
     * 性别
     */
    @PropertyMsg(propertyName = "性别",dictType ="sys_user_sex")
    private Long sex;

    /**
     * 生日
     */
    @PropertyMsg(propertyName = "生日")
    private Date birthDate;

    /**
     * 联系方式
     */
    @PropertyMsg(propertyName = "联系方式")
    @EncryptSensitive
    private String contact;

    /**
     * 工作单位
     */
    @PropertyMsg(propertyName = "工作单位")
    private String workUnit;

    /**
     * 职务
     */
    @PropertyMsg(propertyName = "职务")
    private String duty;

    /**
     * 政治面貌
     */
    @PropertyMsg(propertyName = "政治面貌",dictType = "politics")
    private String politics;

    /**
     * 毕业学校
     */
    @PropertyMsg(propertyName = "毕业学校")
    private String graduateSchool;

    /**
     * 专业
     */
    @PropertyMsg(propertyName = "专业")
    private String major;

    /**
     * 邮箱
     */
    @PropertyMsg(propertyName = "邮箱")
    @EncryptSensitive
    private String email;

    /**
     * 专业技术资格
     */
    @PropertyMsg(propertyName = "专业技术资格")
    private String professional;

    /**
     * 专业技术资格取得时间
     */
    @PropertyMsg(propertyName = "专业技术资格取得时间")
    private Date professionalAcquisitionDate;

    /**
     * 从事专业
     */
    @PropertyMsg(propertyName = "从事专业")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String workProfessial;

    /**
     * 从事专业年限
     */
    @PropertyMsg(propertyName = "从事专业年限",dictType = "work_professial_year")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private Integer workProfessialYear;

    /**
     * 照片
     */
    @PropertyMsg(propertyName = "照片")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String photograph;

    /**
     * 从事工作或研究领域
     */
    @PropertyMsg(propertyName = "从事工作或研究领域",dictType = "perform_work_type")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String performWorkId;

    /**
     * 其他领域描述
     */
    @PropertyMsg(propertyName = "其他领域描述")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String otherDescribe;

    /**
     * 主要工作经历
     */
    @PropertyMsg(propertyName = "主要工作经历")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String workExperience;

    /**
     * 社会兼职情况
     */
    @PropertyMsg(propertyName = "社会兼职情况")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String workPluralistic;

    /**
     * 主要论著、业绩成果及获奖情况
     */
    private String achievement;

    /**
     * 论文
     */
    private String paperpath;

    /**
     * 专利
     */
    private String patentpath;

    /**
     * 备注
     */
    @PropertyMsg(propertyName = "备注")
    private String remark;

    /**
     * 是否删除
     */
    @PropertyMsg(propertyName = "是否删除")
    private Integer deleteFlag;

    /**
     * 租户ID
     */
    @PropertyMsg(propertyName = "租户id")
    private String tenantId;

    /**
     * 创建部门
     */
    @TableField(fill = FieldFill.INSERT)
    private Long createDept;

    /**
     * 是否启用
     */
    @PropertyMsg(propertyName = "是否启用")
    private Integer useFlag;

    /**
     * 状态: 0：暂存 1：待审批 2：正常  3：拒绝 4 离职 5退休
     */
    @PropertyMsg(propertyName = "状态",dictType = "expert_status")
    private Integer status;

    /**
     * 是否专家推荐 1 是 2 否
     */
    @PropertyMsg(propertyName = "是否专家推荐",dictType = "is_recommend")
    private Integer isRecommend;



    /**
     * 专家来源 1 省内 2 省外
     */
    @PropertyMsg(propertyName = "专家来源",dictType = "expert_sources")
    private String expertSources;


    /**
     * 登录用户id
     */
    private Long userId;

    /**
     * 创建者
     */
    @TableField(fill = FieldFill.INSERT)
    private Long createBy;

    /**
     * 创建时间
     */
    @TableField(fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 更新者
     */
    @TableField(fill = FieldFill.INSERT_UPDATE)
    private Long updateBy;

    /**
     * 更新时间
     */
    @TableField(fill = FieldFill.INSERT_UPDATE)
    private Date updateTime;

    /**
     * 审批类型  0 专家申请    1 信息变更
     */
    @TableField(value = "approval_type")
    @PropertyMsg(propertyName = "审批类型",dictType = "approval_type")
    private Integer approvalType;

    /**
     * 单位类型   1企业，2高校，3政府单位
     */
    @TableField(value = "unit_type")
    @PropertyMsg(propertyName = "单位性质",dictType = "unit_type")
    private String unitType;


    @TableField(value = "id_card")
    @PropertyMsg(propertyName = "身份证号")
    @EncryptSensitive
    private String idCard;


    @TableField(updateStrategy = FieldStrategy.IGNORED)
    @PropertyMsg(propertyName = "省")
    private String province;

    @TableField(updateStrategy = FieldStrategy.IGNORED)
    @PropertyMsg(propertyName = "市")
    private String city;

    @TableField(updateStrategy = FieldStrategy.IGNORED)
    @PropertyMsg(propertyName = "区")
    private String area;

    @TableField(updateStrategy = FieldStrategy.IGNORED)
    @PropertyMsg(propertyName = "详细地址")
    private String address;

    @TableField(exist = false)
    @PropertyMsg(propertyName = "专业信息")
    private List<ZjkExpertMajor> majorList;

    @TableField(exist = false)
    @PropertyMsg(propertyName = "技术资格信息")
    private List<ZjkExpertProfessional> professionalList;

    @TableField(exist = false)
    @PropertyMsg(propertyName = "执业资格证书名称及注册号")
    private List<ZjkExpertAwards> zjkExpertAwardsList;

    @TableField(exist = false)
    @PropertyMsg(propertyName = "论文信息")
    private List<ZjkExpertPaper> zjkExpertPaperList;

    @TableField(exist = false)
    @PropertyMsg(propertyName = "专利信息")
    private List<ZjkExpertPatent> zjkExpertPatentList;

    /**
     * 年检状态(1 待年检 2 已通过 3 未通过)
     */
    private String annualInspectionStatus;

    /**
     * 年检时间
     */
    private String annualInspectionTime;

    /**
     * 审批时间
     */
    private Date approvalTime;

    /**
     * 信用分
     */
    @TableField(exist = false)
    private Integer creditCount;


    /**
     * 其他附件
     */
    @PropertyMsg(propertyName = "其他附件")
    private String otherPath;

    /**
     * 离职退休息时间
     */
    private Date retirementTime;

    /**
     * 职称等级
     */
    @PropertyMsg(propertyName = "职称等级",tableName = "zjk_expert_money_config")
    private Long positionTitleLevel;

    @PropertyMsg(propertyName = "籍贯")
    private String origin;

    private String unitTypeDescribe;

    private String hmac;
    /**
     * 活动范围
     */
    private String scopeOfActivity;
    /**
     * 是否涉密
     */
    private Integer isClassified;

}

