package org.dromara.zjk.domain;

import com.alibaba.excel.annotation.ExcelProperty;
import org.dromara.common.tenant.core.TenantEntity;
import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.dromara.zjk.annotation.PropertyMsg;
import java.io.Serial;
import java.math.BigDecimal;

/**
 * 专家费用管理对象 zjk_expert_money_config
 *
 * @author by
 * @date 2024-11-25
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("zjk_expert_money_config")
public class ZjkExpertMoneyConfig extends TenantEntity {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 专家费用管理表
     */
    @TableId(value="money_id",type=IdType.ASSIGN_ID)
    @PropertyMsg(propertyName = "money_id")
    private Long moneyId;

    /**
     * 专家费用标准类型(引用字典money_type)
     */
    @PropertyMsg(propertyName = "money_type")
    private String moneyType;

    /**
     * 专家费用周期
     */
    @PropertyMsg(propertyName = "money_cycle")
    private String moneyCycle;

    /**
     *  计费方式
     */
    @PropertyMsg(propertyName = "money_method")
    private String moneyMethod;
    /**
     * 专家费用
     */
    @PropertyMsg(propertyName = "money_number")
    private BigDecimal moneyNumber;

    /**
     * 逻辑删除标志（1为正常，2为已删除）
     */
    @PropertyMsg(propertyName = "ASSIGN_ID")
    @TableLogic
    private Long assignId;

    /**
     * 备注
     */
    @PropertyMsg(propertyName = "remark")
    private String remark;


}
