package org.dromara.zjk.domain;

import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.dromara.common.tenant.core.TenantEntity;
import org.dromara.zjk.annotation.PropertyMsg;
import org.dromara.zjk.zwy.annotation.EncryptSensitive;

import java.io.Serial;

/**
 * 项目管理对象 zjk_product
 *
 * @author ygh
 * @date 2024-11-01
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("zjk_product")
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ZjkProduct extends TenantEntity {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * $column.columnComment
     */
    private Long id;

    @PropertyMsg(propertyName = "项目编号")
    private String productSn;

    @PropertyMsg(propertyName = "项目名称")
    private String productName;

    @PropertyMsg(propertyName = "项目类型",dictType = "project_type")
    private String productType;

    @PropertyMsg(propertyName = "项目规模")
    private Integer productScale;

    @PropertyMsg(propertyName = "项目单位")
    private String productUnit;

    @PropertyMsg(propertyName = "联系人")
    private String unitBy;

    @EncryptSensitive
    @PropertyMsg(propertyName = "联系电话")
    private String unitConcat;

    @PropertyMsg(propertyName = "项目简介")
    private String productBrief;

    @PropertyMsg(propertyName = "项目附件")
    private String productDataUrl;

    /**
     * $column.columnComment
     */
    private Long status;

    /**
     * $column.columnComment
     */
    @TableLogic
    private Long delFlag;

    /**
     * $column.columnComment
     */
    private String remark;

    private Long userId;

    private String hmac;
    /**
     * 审批状态（0：待审批，1：已审批，2：被驳回）
     */
    private Integer approvalStatus;
    /**
     * 审批原因
     */
    private String approvalReason;
}
