package org.dromara.zjk.domain.bo;

import org.dromara.zjk.domain.ZjkExpertLog;
import org.dromara.common.mybatis.core.domain.BaseEntity;
import org.dromara.common.core.validate.AddGroup;
import org.dromara.common.core.validate.EditGroup;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import lombok.EqualsAndHashCode;
import jakarta.validation.constraints.*;
import org.dromara.zjk.zwy.annotation.EncryptSensitive;

import java.util.Date;
/**
 * 入库记录业务对象 zjk_expert_log
 *
 * @author zhangzhou
 * @date 2024-10-31
 */
@Data
@EqualsAndHashCode(callSuper = true)
@AutoMapper(target = ZjkExpertLog.class, reverseConvertGenerate = false)
public class ZjkExpertLogBo extends BaseEntity {

    /**
     * id
     */
    @NotNull(message = "id不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long id;

    /**
     * 姓名
     */
    @NotBlank(message = "姓名不能为空", groups = { AddGroup.class, EditGroup.class })
    private String name;

    /**
     * 手机号
     */
    @EncryptSensitive
    @NotBlank(message = "手机号不能为空", groups = { AddGroup.class, EditGroup.class })
    private String contactInfo;

    /**
     * 工作单位
     */
    @NotBlank(message = "工作单位不能为空", groups = { AddGroup.class, EditGroup.class })
    private String organization;

    /**
     * 职务
     */
    @NotBlank(message = "职务不能为空", groups = { AddGroup.class, EditGroup.class })
    private String position;

    /**
     * 入库结果
     */
    @NotNull(message = "入库结果不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer entryResult;

    /**
     * 申请时间
     */
    @NotNull(message = "申请时间不能为空", groups = { AddGroup.class, EditGroup.class })
    private Date applicationTime;

    /**
     * 驳回理由
     */
    @NotBlank(message = "驳回理由不能为空", groups = { AddGroup.class, EditGroup.class })
    private String rejectionReason;

    private Long expertId;
}
