package org.dromara.zjk.domain.bo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;
import org.dromara.common.mybatis.core.domain.BaseEntity;
import org.dromara.zjk.domain.ZjkLeave;

import java.util.Date;

/**
 * 【请填写功能名称】业务对象 zjk_leave
 *
 * @author ygh
 * @date 2024-10-30
 */
@Data
@EqualsAndHashCode(callSuper = true)
@AutoMapper(target = ZjkLeave.class, reverseConvertGenerate = false)
public class ZjkLeaveBo extends BaseEntity {

    /**
     * $column.columnComment
     */
    private String gid;

    /**
     * $column.columnComment
     */
    private String leaveType;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date startDate;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date endDate;

    /**
     * $column.columnComment
     */
    private Long leaveDays;

    /**
     * $column.columnComment
     */
    private String leaveReason;

    /**
     * 0 待审批 1 通过 2驳回
     */
    private String status;

    /**
     * $column.columnComment
     */
    private String approvalUser;

    /**
     * $column.columnComment
     */
    private String approvalMsg;

    /**
     * 租户ID
     */
    private String tenantId;
    /**
     * 创建人
     */
    private String createByStr;
}
