package org.dromara.zjk.domain.vo;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import org.dromara.common.excel.annotation.ExcelDictFormat;
import org.dromara.common.excel.convert.ExcelDictConvert;
import org.dromara.zjk.domain.ZjkApprovalProcessLogs;

import java.io.Serial;
import java.io.Serializable;
import java.util.Date;


/**
 * 审批流程记录视图对象 zjk_approval_process_logs
 *
 * @author zhangzhou
 * @date 2024-11-06
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = ZjkApprovalProcessLogs.class)
public class ZjkApprovalProcessLogsVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    private Long id;

    /**
     * 操作项
     */
    @ExcelProperty(value = "操作项" ,converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = "approval_process_type")
    private String actionItem;

    /**
     * 操作内容
     */
    @ExcelProperty(value = "操作内容" ,converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = "approval_process_business_type")
    private String actionContent;

    /**
     * 审批意见
     */
    @ExcelProperty(value = "审批意见")
    private String approvalOpinions;


    /**
     * 创建人
     */
    private Long createBy;
    /**
     * 创建人
     */
    @ExcelProperty(value = "操作人")
    private String createByStr;
    /**
     * 创建时间
     */
    @ExcelProperty(value = "操作时间")
    private Date createTime;

    /**
     * 修改人
     */
    private Long updateBy;

    /**
     * 修改时间
     */
    private Date updateTime;



}
