package org.dromara.zjk.domain.vo;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.TableField;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import org.dromara.common.excel.annotation.ExcelDictFormat;
import org.dromara.common.excel.convert.ExcelDictConvert;
import org.dromara.zjk.domain.ZjkDataChangesLogs;

import java.io.Serial;
import java.io.Serializable;
import java.util.Date;


/**
 * 业务数据变更记录视图对象 zjk_data_changes_logs
 *
 * @author ygh
 * @date 2024-11-07
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = ZjkDataChangesLogs.class)
public class ZjkDataChangesLogsVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @ExcelProperty(value = "id")
    private Long id;

    /**
     * 操作类型
     */
    @ExcelProperty(value = "操作类型", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = "change_type")
    private String changeType;

    /**
     * 业务类型 1.专家信息变更 2.项目信息变更
     */
    @ExcelProperty(value = "业务类型 1.专家信息变更 2.项目信息变更", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = "business_type")
    private String businessType;

    /**
     * 操作前数据
     */
    @ExcelProperty(value = "操作前数据")
    private String beforeOper;

    /**
     * 操作后数据
     */
    @ExcelProperty(value = "操作后数据")
    private String afterOper;

    /**
     * 操作 ip
     */
    @ExcelProperty(value = "操作 ip")
    private String operIp;


    /**
     * 操作人
     */
    private Long createBy;
    /**
     * 操作人
     */
    @ExcelProperty(value = "操作人")
    private String createByStr;

    /**
     * 操作时间
     */
    private Date createTime;


}
