package org.dromara.zjk.domain.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 专家评价
 *
 * @TableName zjk_evaluate
 */
@Data
public class ZjkEvaluateVO  implements Serializable {
    /**
     * 租户号
     */
    private String id;

    /**
     * 待评人
     */
    private String evaluateUser;
    /**
     * 工作单位
     */
    private String workUnit;
    /**
     * 待评人
     */
    private String userId;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date reviewTime;
    /**
     * 接受状态
     */
    private String acceptStatus;
    /**
     * 请假状态
     */
    private String leaveStatus;
    /**
     * 项目名称
     */
    private String productName;
    /**
     * 项目编号
     */
    private String productSn;
    /**
     * 单位负责人
     */
    private String unitBy;
    /**
     * 负责单位
     */
    private String productUnit;
    /**
     * 专家职务
     */
    private String expertPost;

    /**
     * 项目id
     */
    private String itemId;
    /**
     * 出席情况1：出席；0：未出席
     */
    private String isPresent;

    /**
     * 项目阶段
     */
    private String itemStage;
    /**
     * 项目阶段
     */
    private String itemStageName;
    /**
     * 请假原因
     */
    private String leaveReason;

    /**
     * 创建时间
     */
    private Date createTime;

    private String startDate;


    private String endDate;

    /**
     * 业务水平得分
     */
    private BigDecimal busLevelScore;

    /**
     * 工作态度得分
     */
    private BigDecimal workAttitudeScore;

    /**
     * 合规评审得分
     */
    private BigDecimal rightApprovalScore;

    /**
     * 专家评语
     */
    private String expertComment;

    /**
     * 专家评价文件id集合
     */
    private String evaluateFile;

    /**
     * 评价状态;1:已评价；0：未评价
     */
    private String status;

    /**
     * 租户id
     */
    private String tenantId;

    private String isXmAdmin;
    /**
     * 评价来源
     */
    private String sourceRoleStr;
    /**
     * 1均分倒叙；2均分正序
     * 3总分倒叙；4总分正序
     */
    private Integer  sortWay;
    /**
     * 0.项目管理员评价为未出席
     * 1.正常评价，不进行控制
     */
    private Integer xmEvaluateStatus;
    /**
     * 项目管理员id
     */
    private String productCreateBy;

    private static final long serialVersionUID = 1L;
}
