package org.dromara.zjk.domain.vo;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import org.dromara.common.sensitive.annotation.Sensitive;
import org.dromara.common.sensitive.core.SensitiveStrategy;
import org.dromara.zjk.domain.ZjkExpertLog;
import org.dromara.zjk.zwy.annotation.EncryptSensitive;

import java.io.Serial;
import java.io.Serializable;
import java.util.Date;



/**
 * 入库记录视图对象 zjk_expert_log
 *
 * @author zhangzhou
 * @date 2024-10-31
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = ZjkExpertLog.class)
public class ZjkExpertLogVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    private Long id;

    /**
     * 姓名
     */
    @ExcelProperty(value = "姓名")
    private String name;

    /**
     * 手机号
     */
    @ExcelProperty(value = "手机号")

    @EncryptSensitive
    private String contactInfo;

    /**
     * 工作单位
     */
    @ExcelProperty(value = "工作单位")
    private String organization;

    /**
     * 职务
     */
    @ExcelProperty(value = "职务")
    private String position;

    /**
     * 入库结果
     */
    private Integer entryResult;
    @ExcelProperty(value = "入库结果")
    private String entryResultStr;


    /**
     * 申请时间
     */
    @ExcelProperty(value = "申请时间")
    private Date applicationTime;

    /**
     * 驳回理由
     */
    @ExcelProperty(value = "驳回理由")
    private String rejectionReason;


    private Long expertId;
}
