package org.dromara.zjk.domain.vo;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import org.dromara.zjk.domain.ZjkInvoice;
import org.dromara.zjk.zwy.annotation.EncryptSensitive;

import java.io.Serial;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;


/**
 * 发票视图对象 zjk_invoice
 *
 * @author mzx
 * @date 2024-12-09
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = ZjkInvoice.class)
public class ZjkInvoiceVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 发票表id
     */
    private Long id;

    /**
     * 发票号码
     */
    @ExcelProperty(value = "发票号码")
    private String invoiceNumber;

    /**
     * 发票金额
     */
    @ExcelProperty(value = "发票金额")
    private BigDecimal invoiceMoney;

    /**
     * 开票日期
     */
    @ExcelProperty(value = "开票日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date startDate;

    /**
     * 专家名称
     */
    @ExcelProperty(value = "专家名称")
    private String expertName;

    /**
     * 联系电话
     */
    @ExcelProperty(value = "联系电话")
    @EncryptSensitive
    private String expertPhone;

    /**
     * 专家身份证号
     */
    @ExcelProperty(value = "专家身份证号")
    @EncryptSensitive
    private String expertIdNumber;

    /**
     * 专家类型
     */
    @ExcelProperty(value = "职称等级")
    private String expertTitleLevel;

    /**
     * 电子发票附件相关 外键ossid
     */
    private String invoiceAttached;

    /**
     * 电子发票名字    由表invoice的invoiceAttached ossid 查出名字和地址
     */
    private String invoiceAttachedName;

    private String invoiceAttachedAddr;

    private String hmac;
    /**
     * 项目id
     */
    private Long productId;
    /**
     * 项目阶段
     */
    private Integer reviewSn;
    /**
     * 结算单id
     */
    private Long settleId;
    /**
     * 结算单id
     */
    private String settleIdName;
    /**
     * 审核状态1：已审核
     */
    private Integer checkStatus;

}
