package org.dromara.zjk.expert.retirementRecords.service;


import org.dromara.common.mybatis.core.page.PageQuery;
import org.dromara.common.mybatis.core.page.TableDataInfo;
import org.dromara.zjk.expert.retirementRecords.domain.bo.ZjkRetirementRecordsBo;
import org.dromara.zjk.expert.retirementRecords.domain.vo.ZjkRetirementRecordsVo;
import org.dromara.zjk.zwy.annotation.DecryptOperation;

import java.util.Collection;
import java.util.List;

/**
 * 专家退休记录Service接口
 *
 * @author zhangzhou
 * @date 2024-11-19
 */
public interface IZjkRetirementRecordsService {

    /**
     * 查询专家退休记录
     *
     * @param id 主键
     * @return 专家退休记录
     */
    ZjkRetirementRecordsVo queryById(Long id);

    /**
     * 分页查询专家退休记录列表
     *
     * @param bo        查询条件
     * @param pageQuery 分页参数
     * @return 专家退休记录分页列表
     */
    TableDataInfo<ZjkRetirementRecordsVo> queryPageList(ZjkRetirementRecordsBo bo, PageQuery pageQuery);

    /**
     * 查询符合条件的专家退休记录列表
     *
     * @param bo 查询条件
     * @return 专家退休记录列表
     */
    List<ZjkRetirementRecordsVo> queryList(ZjkRetirementRecordsBo bo);

    /**
     * 新增专家退休记录
     *
     * @param bo 专家退休记录
     * @return 是否新增成功
     */
    Boolean insertByBo(ZjkRetirementRecordsBo bo);

    /**
     * 修改专家退休记录
     *
     * @param bo 专家退休记录
     * @return 是否修改成功
     */
    Boolean updateByBo(ZjkRetirementRecordsBo bo);

    /**
     * 校验并批量删除专家退休记录信息
     *
     * @param ids     待删除的主键集合
     * @param isValid 是否进行有效性校验
     * @return 是否删除成功
     */
    Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);



    /**
     * 定时任务专家是否到年龄退休
     */
    void executeRetirement();

}


