package org.dromara.zjk.learning_world.domain.bo;

import com.fasterxml.jackson.annotation.JsonFormat;
import org.dromara.zjk.learning_world.domain.entity.ZjkLearningActivity;
import org.dromara.common.mybatis.core.domain.BaseEntity;
import org.dromara.common.core.validate.AddGroup;
import org.dromara.common.core.validate.EditGroup;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import lombok.EqualsAndHashCode;
import jakarta.validation.constraints.*;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 活动管理业务对象 zjk_learning_activity
 *
 * @author ygh
 * @date 2024-11-08
 */
@Data
@EqualsAndHashCode(callSuper = true)
@AutoMapper(target = ZjkLearningActivity.class, reverseConvertGenerate = false)
public class ZjkLearningActivityBo extends BaseEntity {

    /**
     * id
     */
    @NotNull(message = "id不能为空", groups = { EditGroup.class })
    private Long id;

    /**
     * 活动名称
     */
    @NotBlank(message = "活动名称不能为空", groups = { AddGroup.class})
    private String activityName;

    /**
     * 活动分类
     */
    @NotBlank(message = "活动分类不能为空", groups = { AddGroup.class})
    private String activityClassify;

    /**
     * 活动时间
     */
    @NotNull(message = "活动开始时间不能为空", groups = { AddGroup.class})
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date activityStartTime;
    /**
     * 活动时间
     */
    @NotNull(message = "活动结束时间不能为空", groups = { AddGroup.class})
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date activityEndTime;

    /**
     * 活动地点
     */
    @NotBlank(message = "活动地点不能为空", groups = { AddGroup.class})
    private String activityAddress;

    /**
     * 活动数量
     */
    @NotNull(message = "活动数量不能为空", groups = { AddGroup.class})
    private Long activityNum;

    /**
     * 封面图
     */
    @NotBlank(message = "封面图不能为空", groups = { AddGroup.class})
    private String activityPic;

    /**
     * 活动内容
     */
    @NotBlank(message = "活动内容不能为空", groups = { AddGroup.class })
    private String activityContent;

    /**
     * 是否发布
     */
    private String isPublic;

    /**
     * 状态
     */
    @NotBlank(message = "状态不能为空", groups = { AddGroup.class })
    private String status;

    /**
     * 活动状态
     */
    private String activityStatus;

    /**
     * 备注
     */
    private String remark;
    /**
     * 上下架时间
     */
    private Date takedownTime;

    /**
     * 创建人
     */
    private Long userId;
}
