package org.dromara.zjk.learning_world.domain.entity;

import org.dromara.common.tenant.core.TenantEntity;
import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;

import org.dromara.zjk.annotation.PropertyMsg;
import java.io.Serial;

/**
 * 学习记录对象 zjk_learning_records
 *
 * @author wt
 * @date 2024-11-26
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("zjk_learning_records")
public class ZjkLearningRecords extends TenantEntity {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @PropertyMsg(propertyName = "id")
    private Long id;

    /**
     * 课程id
     */
    @PropertyMsg(propertyName = "course_id")
    private Long courseId;

    /**
     * 用户id
     */
    @PropertyMsg(propertyName = "user_id")
    private Long userId;

    /**
     * 专家id
     */
    @PropertyMsg(propertyName = "expert_id")
    private Long expertId;

    /**
     * 视频时长
     */
    @PropertyMsg(propertyName = "rate")
    private Date rate;

    /**
     * 观看时长
     */
    @PropertyMsg(propertyName = "view_duration")
    private Date viewDuration;

    /**
     * 学习时长
     */
    @PropertyMsg(propertyName = "learning_session_length")
    private Long learningSessionLength;
    /**
     * 状态
     */
    @PropertyMsg(propertyName = "status")
    private String status;

    /**
     * 备注
     */
    @PropertyMsg(propertyName = "remark")
    private String remark;

    /**
     * 是否删除
     */
    @TableLogic
    @PropertyMsg(propertyName = "del_flag")
    private Long delFlag;

    private Long deptId;

}
