package org.dromara.zjk.learning_world.domain.excel;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import lombok.Data;
import org.dromara.common.excel.annotation.ExcelDictFormat;
import org.dromara.common.excel.convert.ExcelDictConvert;

import java.util.Date;


/**
 * 资源管理视图对象 zjk_learning_resource
 *
 * @author ygh
 * @date 2024-11-08
 */
@Data
public class ZjkLearningResourceExcel  {



    /**
     * 资源编号
     */
    @ExcelProperty(value = "资源编号")
    private String resourceName;

    @ExcelProperty(value = "资源类型", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = "source_type")
    private String resourceClassify;
    /**
     * 资源分类
     */
    @ExcelIgnore
    private String resourceClassifyName;

    /**
     * 资源类型
     */
    @ExcelIgnore
    private String resourceType;
    /**
     * 资源类型
     */
    @ExcelProperty(value = "资源分类")
    private String resourceTypeName;

    /**
     * 资源简介
     */
    @ExcelProperty(value = "资源简介")
    private String resourceBrief;

    /**
     * 发布时间
     */
    @ExcelProperty(value = "发布时间")
    @DateTimeFormat("yyyy-MM-dd")
    private Date resourceTime;

    /**
     * 作者
     */
    @ExcelProperty(value = "作者")
    private String author;

    /**
     * 发表期刊
     */
    @ExcelProperty(value = "发表期刊")
    private String publishJournal;

    /**
     * 期刊号
     */
    @ExcelProperty(value = "期刊号")
    private String journalNo;

    /**
     * 论文标题
     */
    @ExcelProperty(value = "论文标题")
    private String paperTitle;

    /**
     * 状态
     */
    @ExcelIgnore
    private String status;

    @ExcelProperty(value = "状态")
    private String statusName;

    /**
     * 备注
     */
    @ExcelProperty(value = "备注")
    private String remark;


}
