package org.dromara.zjk.learning_world.mapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;
import org.dromara.common.mybatis.annotation.DataColumn;
import org.dromara.common.mybatis.annotation.DataPermission;
import org.dromara.zjk.learning_world.domain.bo.ZjkLearningRecordsBo;
import org.dromara.zjk.learning_world.domain.entity.ZjkLearningRecords;

import org.dromara.common.mybatis.core.mapper.BaseMapperPlus;
import org.dromara.zjk.learning_world.domain.vo.ZjkLearningRecordsVo;

/**
 * 学习记录Mapper接口
 *
 * @author wt
 * @date 2024-11-26
 */
public interface ZjkLearningRecordsMapper extends BaseMapperPlus<ZjkLearningRecords, ZjkLearningRecordsVo> {

    @DataPermission({
        @DataColumn(key = "deptName", value = "zlr.dept_id"),
        @DataColumn(key = "userName", value = "zlr.user_id")
    })
    Page<ZjkLearningRecordsVo> selectRecord(@Param("page")Page<ZjkLearningRecords> build, @Param("bo") ZjkLearningRecordsBo bo);
}
