package org.dromara.zjk.mapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;
import org.dromara.common.mybatis.core.mapper.BaseMapperPlus;
import org.dromara.zjk.domain.ZjkExpertMoneyInfo;
import org.dromara.zjk.domain.bo.ZjkExpertMoneyInfoBo;
import org.dromara.zjk.domain.vo.ZjkExpertMoneyInfoVO;
import org.dromara.zjk.domain.vo.ZjkExpertVo;

import java.util.Date;
import java.util.List;

/**
* @author EDY
* @description 针对表【zjk_expert_money_info(专家费用管理表)】的数据库操作Mapper
* @createDate 2024-11-28 18:36:35
* @Entity org.dromara.zjk.domain.ZjkExpertMoneyInfo
*/
public interface ZjkExpertMoneyInfoMapper extends BaseMapperPlus<ZjkExpertMoneyInfo, ZjkExpertMoneyInfoVO> {

    Page<ZjkExpertMoneyInfo> selectMoneyInfoList(Page<ZjkExpertMoneyInfo> build, @Param("bo") ZjkExpertMoneyInfoBo bo);

    List<ZjkExpertMoneyInfoVO> selectListByMonth(@Param("startTime") Date startTime ,@Param("endTime") Date endTime,@Param("tenantId") String tenantId);

    List<String> selectTenantIds();

    List<ZjkExpertVo> getExpertList(Long productId, Integer reviewSn);

    List<ZjkExpertVo> getExpertListForSettle(Long productId, Integer reviewSn);

    ZjkExpertMoneyInfo selectByIdEx(Long moneyId);

    List<ZjkExpertMoneyInfo> selectJsList(Long productId, Integer reviewSn, String expertId);
}




