package org.dromara.zjk.mapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;
import org.dromara.common.mybatis.annotation.DataColumn;
import org.dromara.common.mybatis.annotation.DataPermission;
import org.dromara.common.mybatis.core.mapper.BaseMapperPlus;
import org.dromara.zjk.domain.ZjkReviewPhase;
import org.dromara.zjk.domain.bo.ZjkProductBo;
import org.dromara.zjk.domain.bo.ZjkReviewProductBo;
import org.dromara.zjk.domain.vo.ZjkReviewPhaseVo;
import org.dromara.zjk.domain.vo.ZjkReviewProductVo;

import java.util.Collection;
import java.util.List;

/**
 * 抽取条件Mapper接口
 *
 * @author ygh
 * @date 2024-11-01
 */
public interface ZjkReviewPhaseMapper extends BaseMapperPlus<ZjkReviewPhase, ZjkReviewPhaseVo> {


    Page<ZjkReviewProductVo> reviewProductList(Page<ZjkReviewProductVo> build, ZjkReviewProductBo bo);

    List<ZjkReviewProductVo> reviewProductListForExport(@Param("bo") ZjkReviewProductBo bo);

    @DataPermission({
        @DataColumn(key = "deptName", value = "zei.dept_id"),
        @DataColumn(key = "xmUserName", value = "zrp.create_by"),
        @DataColumn(key = "userName", value = "zei.user_id")
    })
    List<Long> getByProductId(@Param("productId") Long id);

    @DataPermission({
        @DataColumn(key = "deptName", value = "zei.dept_id"),
        @DataColumn(key = "userName", value = "zei.user_id"),
        @DataColumn(key = "xmUserName", value = "zei.user_id")
    })
    List<ZjkReviewProductVo> reviewExport(@Param("bo") ZjkReviewProductBo bo);

    List<ZjkReviewProductVo> getProductList();

    List<ZjkReviewProductVo> getByProductIds(@Param("productIds") Collection<Long> id);


    Page<ZjkReviewProductVo> getReviewProductListByExpert(Page<ZjkReviewProductVo> build, @Param("bo") ZjkReviewProductBo bo);

    ZjkReviewPhase selectVoListByLimit(Long id);


    Long getReviewProductCountByExpertId(Long expertId);

    List<ZjkReviewPhaseVo> selectVoListByZjkItemExpert(@Param("itemid") Long itemid, @Param("reviewSn") String reviewSn, @Param("rown") Long rown, @Param("supplementCause") Integer supplementCause);

    List<ZjkReviewPhaseVo> selectUpdateZjkItemExpert(Long itemid, String reviewSn);

    int updateByIds(@Param("ids") Collection<Long> reviewIds);

    List<ZjkReviewPhaseVo> selectVoListByZjkItemExpertBylast(Long itemid, String reviewSn, Long rown, int i);

    Long selectListByItem(Long reviewId);

    List<ZjkReviewPhaseVo> selectVoByExtreationId(@Param("extractionId") Long extractionId);

    List<ZjkProductBo> getInvoiceProductList();
}
