package org.dromara.zjk.service;

import org.dromara.common.mybatis.core.page.PageQuery;
import org.dromara.common.mybatis.core.page.TableDataInfo;
import org.dromara.zjk.domain.ProductCountReport;
import org.dromara.zjk.domain.ZjkProduct;
import org.dromara.zjk.domain.bo.ZjkProductBo;
import org.dromara.zjk.domain.dto.ProjectSummaryStatistics;
import org.dromara.zjk.domain.vo.*;

import java.util.Collection;
import java.util.List;
import java.util.Set;

/**
 * 项目管理Service接口
 *
 * @author ygh
 * @date 2024-11-01
 */
public interface IZjkProductService {

    /**
     * 查询项目管理
     *
     * @param id 主键
     * @return 项目管理
     */
    ZjkProductVo queryById(Long id);

    /**
     * 分页查询项目管理列表
     *
     * @param bo        查询条件
     * @param pageQuery 分页参数
     * @return 项目管理分页列表
     */
    TableDataInfo<ZjkProductVo> queryPageList(ZjkProductBo bo, PageQuery pageQuery);
    List<ZjkProductVo> queryListForApi(ZjkProductBo bo);

    /**
     * 查询符合条件的项目管理列表
     *
     * @param bo 查询条件
     * @return 项目管理列表
     */
    List<ZjkProductVo> queryList(ZjkProductBo bo);

    /**
     * 新增项目管理
     *
     * @param bo 项目管理
     * @return 是否新增成功
     */
    Boolean insertByBo(ZjkProductBo bo);

    /**
     * 修改项目管理
     *
     * @param bo 项目管理
     * @return 是否修改成功
     */
    Boolean updateByBo(ZjkProductBo bo);

    /**
     * 校验并批量删除项目管理信息
     *
     * @param ids     待删除的主键集合
     * @param isValid 是否进行有效性校验
     * @return 是否删除成功
     */
    Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);

    TableDataInfo<ZjkProductVo> getProduct(PageQuery pageQuery,Long id);

    ItemVO getItemId(Long productId, Long reviewId);

    List<ZjkReviewProductVo> getProductReview(Long productId);

    TableDataInfo<ZjkProduct> queryByList();

    TableDataInfo<ProductPanoramaVo> productPanorama(ProductPanoramaVo vo, PageQuery pageQuery);

    List<ProductPanoramaDetailVo> getProductPanoramaDetailVoById(Long productId);

    Long getProductPanoramaCount();

    List<ProductCountReport> getProductTypeCountReport();

    List<ProjectSummaryStatisticsVo> getReviewStageSummary();

    List<ZjkProductVo> queryPageListByName(ZjkProductBo bo);

    boolean addBo(ZjkProductBo bo);

    TableDataInfo<ZjkProductVo> selectList(ZjkProductBo bo, PageQuery pageQuery);

    boolean removeByProductId(Long productReviewId);

    ZjkProductVo selectDocumentcByproductId(Long productReviewId);

    boolean productReviewUpdate(ZjkProductBo bo);

    ProjectSummaryStatistics projectSummaryStatistics();

    Set<ProductPanoramaDeptVo> productPanoramaDept();

    Boolean approval(ZjkProductBo bo);

    TableDataInfo<ProductPanoramaVo> getProductList(ProductPanoramaVo vo, PageQuery pageQuery);
}
