package org.dromara.zjk.service;

import org.dromara.common.core.domain.R;
import org.dromara.common.mybatis.core.page.PageQuery;
import org.dromara.common.mybatis.core.page.TableDataInfo;
import org.dromara.zjk.domain.bo.ZjkProductBo;
import org.dromara.zjk.domain.bo.ZjkReviewPhaseBo;
import org.dromara.zjk.domain.bo.ZjkReviewProductBo;
import org.dromara.zjk.domain.vo.ZjkReviewPhaseVo;
import org.dromara.zjk.domain.vo.ZjkReviewProductVo;

import java.util.Collection;
import java.util.List;

/**
 * 抽取条件Service接口
 *
 * @author ygh
 * @date 2024-11-01
 */
public interface IZjkReviewPhaseService {

    /**
     * 查询抽取条件
     *
     * @param tenantId 主键
     * @return 抽取条件
     */
    ZjkReviewPhaseVo queryById(String tenantId);

    /**
     * 分页查询抽取条件列表
     *
     * @param bo        查询条件
     * @param pageQuery 分页参数
     * @return 抽取条件分页列表
     */
    TableDataInfo<ZjkReviewPhaseVo> queryPageList(ZjkReviewPhaseBo bo, PageQuery pageQuery);

    /**
     * 查询符合条件的抽取条件列表
     *
     * @param bo 查询条件
     * @return 抽取条件列表
     */
    List<ZjkReviewPhaseVo> queryList(ZjkReviewPhaseBo bo);

    /**
     * 新增抽取条件
     *
     * @param bo 抽取条件
     * @return 是否新增成功
     */
    Boolean insertByBo(ZjkReviewPhaseBo bo);

    /**
     * 修改抽取条件
     *
     * @param bo 抽取条件
     * @return 是否修改成功
     */
    Boolean updateByBo(ZjkReviewPhaseBo bo);

    /**
     * 校验并批量删除抽取条件信息
     *
     * @param ids     待删除的主键集合
     * @param isValid 是否进行有效性校验
     * @return 是否删除成功
     */
    Boolean deleteWithValidByIds(Collection<String> ids, Boolean isValid);

    TableDataInfo<ZjkReviewProductVo> reviewProductList(ZjkReviewProductBo bo, PageQuery pageQuery);

    ZjkReviewProductVo reviewListById(Long id);

    List<ZjkReviewProductVo> reviewExport(ZjkReviewProductBo bo);

    TableDataInfo<ZjkReviewProductVo> getReviewProductListByExpert(ZjkReviewProductBo bo, PageQuery pageQuery);

    Long getReviewCount();

    Long getReviewProductCountByExpertId(Long expertId);

    R<List<ZjkProductBo>> invoiceProductList();
}
