package org.dromara.zjk.service;

import com.baomidou.mybatisplus.extension.service.IService;
import jakarta.validation.constraints.NotNull;
import org.dromara.common.mybatis.core.page.PageQuery;
import org.dromara.common.mybatis.core.page.TableDataInfo;
import org.dromara.zjk.domain.ZjkExpertMoneyInfo;
import org.dromara.zjk.domain.bo.ZjkExpertMoneyInfoBo;
import org.dromara.zjk.domain.vo.ZjkExpertMoneyInfoVO;
import org.dromara.zjk.domain.vo.ZjkExpertVo;

import java.util.Collection;
import java.util.List;

/**
* @author EDY
* @description 针对表【zjk_expert_money_info(专家费用管理表)】的数据库操作Service
* @createDate 2024-11-28 18:36:35
*/
public interface ZjkExpertMoneyInfoService extends IService<ZjkExpertMoneyInfo> {
    /**
     * 查询专家费用管理
     *
     * @param moneyId 主键
     * @return 专家费用管理
     */
    ZjkExpertMoneyInfo queryById(Long moneyId);

    /**
     * 分页查询专家费用管理列表
     *
     * @param bo        查询条件
     * @param pageQuery 分页参数
     * @return 专家费用管理分页列表
     */
    TableDataInfo<ZjkExpertMoneyInfo> queryPageList(ZjkExpertMoneyInfoBo bo, PageQuery pageQuery);

    boolean updateMoneyInfo(ZjkExpertMoneyInfoBo bo);

    boolean updateMoneyInfoPay(ZjkExpertMoneyInfoBo bo);

    /**
     * 查询符合条件的【请填写功能名称】列表
     *
     * @param bo 查询条件
     * @return 【请填写功能名称】列表
     */
    List<ZjkExpertMoneyInfoVO> queryList(ZjkExpertMoneyInfoBo bo);

    /**
     * 新增【请填写功能名称】
     *
     * @param bo 【请填写功能名称】
     * @return 是否新增成功
     */
    Boolean insertByBo(ZjkExpertMoneyInfoBo bo);

    /**
     * 修改【请填写功能名称】
     *
     * @param bo 【请填写功能名称】
     * @return 是否修改成功
     */
    Boolean updateByBo(ZjkExpertMoneyInfoBo bo);

    /**
     * 校验并批量删除【请填写功能名称】信息
     *
     * @param ids     待删除的主键集合
     * @param isValid 是否进行有效性校验
     * @return 是否删除成功
     */
    Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);

    List<ZjkExpertMoneyInfo> getJsList(@NotNull(message = "项目不能为空") Long productId, @NotNull(message = "阶段不能为空") Integer reviewSn, String expertId);

    List<ZjkExpertVo> getExpertList(@NotNull(message = "项目不能为空") Long productId, @NotNull(message = "阶段不能为空") Integer reviewSn);

    List<ZjkExpertVo> getExpertListForSettle(@NotNull(message = "项目不能为空") Long productId, @NotNull(message = "阶段不能为空") Integer reviewSn);
}
